/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcResultSet;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcTypeInfo;

public class JdbcOdbcStatement
extends JdbcOdbcObject
implements Statement {
    protected JdbcOdbc OdbcApi = null;
    protected int hDbc = 0;
    protected int hStmt = 0;
    protected SQLWarning lastWarning = null;
    protected Hashtable typeInfo;
    protected ResultSet myResultSet;
    protected JdbcOdbcConnectionInterface myConnection;

    public JdbcOdbcStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        this.myConnection = jdbcOdbcConnectionInterface;
    }

    public void addBatch(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void cancel() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.cancel");
        }
        this.clearWarnings();
        try {
            this.OdbcApi.SQLCancel(this.hStmt);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
    }

    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected synchronized void clearMyResultSet() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public synchronized void close() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0;
            }
        }
        catch (SQLException sQLException) {}
        this.myConnection.deregisterStatement(this);
    }

    public synchronized boolean execute(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.execute (" + string + ")");
        }
        boolean bl = false;
        SQLWarning sQLWarning = null;
        this.reset();
        this.lockIfNecessary(string);
        try {
            this.OdbcApi.SQLExecDirect(this.hStmt, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        if (this.getColumnCount() > 0) {
            bl = true;
        }
        return bl;
    }

    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.executeQuery (" + string + ")");
        }
        ResultSet resultSet = null;
        if (!this.execute(string)) {
            throw new SQLException("No ResultSet was produced");
        }
        resultSet = this.getResultSet(false);
        return resultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.executeUpdate (" + string + ")");
        }
        int n = -1;
        if (this.execute(string)) {
            throw new SQLException("No row count was produced");
        }
        n = this.getUpdateCount();
        return n;
    }

    protected void finalize() {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Statement.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {}
    }

    protected int getColumnCount() throws SQLException {
        int n = 0;
        try {
            n = this.OdbcApi.SQLNumResultCols(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
        }
        return n;
    }

    public Connection getConnection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxFieldSize() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.getMaxFieldSize");
        }
        return this.getStmtOption((short)3);
    }

    public int getMaxRows() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.getMaxRows");
        }
        return this.getStmtOption((short)1);
    }

    public boolean getMoreResults() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.getMoreResults");
        }
        Object var1_1 = null;
        SQLWarning sQLWarning = null;
        boolean bl = false;
        this.clearWarnings();
        try {
            bl = this.OdbcApi.SQLMoreResults(this.hStmt);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        if (bl && this.getColumnCount() == 0) {
            bl = false;
        }
        this.setWarning(sQLWarning);
        return bl;
    }

    protected int getPrecision(int n) {
        JdbcOdbcTypeInfo jdbcOdbcTypeInfo;
        int n2 = -1;
        if (this.typeInfo != null && (jdbcOdbcTypeInfo = (JdbcOdbcTypeInfo)this.typeInfo.get(new Integer(n))) != null) {
            n2 = jdbcOdbcTypeInfo.getPrec();
        }
        return n2;
    }

    public int getQueryTimeout() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.getQueryTimeout");
        }
        return this.getStmtOption((short)0);
    }

    public ResultSet getResultSet() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.getResultSet");
        }
        this.myResultSet = this.getResultSet(true);
        return this.myResultSet;
    }

    public ResultSet getResultSet(boolean bl) throws SQLException {
        if (this.myResultSet != null) {
            throw new SQLException("Invalid state for getResultSet");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        int n = 1;
        if (bl) {
            n = this.getColumnCount();
        }
        if (n > 0) {
            jdbcOdbcResultSet = new JdbcOdbcResultSet();
            jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, this.hStmt, true, this);
        } else {
            this.clearMyResultSet();
        }
        return jdbcOdbcResultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetType() {
        throw new UnsupportedOperationException();
    }

    protected int getRowCount() throws SQLException {
        int n = 0;
        try {
            n = this.OdbcApi.SQLRowCount(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
        }
        return n;
    }

    protected int getStmtOption(short s) throws SQLException {
        int n = 0;
        this.clearWarnings();
        try {
            n = this.OdbcApi.SQLGetStmtOption(this.hStmt, s);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    public int getUpdateCount() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.getUpdateCount");
        }
        int n = -1;
        if (this.getColumnCount() == 0) {
            n = this.getRowCount();
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.getWarnings");
        }
        return this.lastWarning;
    }

    public void initialize(JdbcOdbc jdbcOdbc, int n) throws SQLException {
        int n2 = jdbcOdbc.SQLAllocStmt(n);
        this.initialize(jdbcOdbc, n, n2, null);
    }

    public void initialize(JdbcOdbc jdbcOdbc, int n, int n2, Hashtable hashtable) throws SQLException {
        this.OdbcApi = jdbcOdbc;
        this.hDbc = n;
        this.hStmt = n2;
        this.typeInfo = hashtable;
    }

    protected boolean lockIfNecessary(String string) throws SQLException {
        boolean bl = false;
        String string2 = string.toUpperCase();
        int n = string2.indexOf(" FOR UPDATE");
        if (n > 0) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("Setting concurrency for update");
            }
            try {
                this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)7, 2);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
            }
            bl = true;
        }
        return bl;
    }

    protected void reset() throws SQLException {
        this.clearWarnings();
        if (this.myResultSet != null) {
            this.clearMyResultSet();
        } else {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 0);
        }
    }

    public void setCursorName(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.setCursorName " + string + ")");
        }
        this.OdbcApi.SQLSetCursorName(this.hStmt, string);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.setEscapeProcessing (" + bl + ")");
        }
        int n = 0;
        if (!bl) {
            n = 1;
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)2, n);
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.setMaxFieldSize (" + n + ")");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)3, n);
    }

    public void setMaxRows(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.setMaxRows (" + n + ")");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)1, n);
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.setQueryTimeout (" + n + ")");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)0, n);
    }

    public void setWarning(SQLWarning sQLWarning) throws SQLException {
        this.lastWarning = sQLWarning;
    }
}

