/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.ftp.FtpClient;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.URLConnection;
import sun.net.www.protocol.ftp.FtpDirectoryThread;
import sun.security.action.GetPropertyAction;

public class FtpURLConnection
extends URLConnection {
    InputStream is = null;
    FtpClient ftp = null;
    Permission permission;
    String password;
    String user;
    String host;

    public FtpURLConnection(URL uRL) {
        super(uRL);
        this.host = uRL.getHost();
        int n = this.host.indexOf(64);
        if (n > -1) {
            int n2 = this.host.indexOf(58);
            this.user = this.host.substring(0, n2++);
            this.password = this.host.substring(n2, n++);
            this.host = this.host.substring(n);
        }
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.ftp = new FtpClient(this.host);
        if (this.user == null || this.password == null) {
            this.user = "anonymous";
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
            this.password = (String)AccessController.doPrivileged(new GetPropertyAction("ftp.protocol.user", "Java" + string + "@"));
        }
        this.ftp.login(this.user, this.password);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.is != null) {
            return this.is;
        }
        MessageHeader messageHeader = new MessageHeader();
        try {
            String string;
            this.ftp.binary();
            this.is = this.ftp.get(this.url.getFile());
            try {
                string = this.ftp.getResponseString();
                int n = string.indexOf(" bytes)");
                if (n != -1) {
                    char c;
                    int n2 = n;
                    while (--n2 >= 0 && (c = string.charAt(n2)) >= '0' && c <= '9') {
                    }
                    n2 = Integer.parseInt(string.substring(n2 + 1, n));
                    messageHeader.add("content-length", String.valueOf(n2));
                    if (n2 > 0) {
                        ProgressEntry progressEntry = new ProgressEntry(this.url.getFile(), null);
                        progressEntry.update(0, n2);
                        ProgressData.pdata.register(progressEntry);
                        this.is = new MeteredStream(this.is, progressEntry);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if ((string = java.net.URLConnection.guessContentTypeFromName(this.url.getFile())) == null && this.is.markSupported()) {
                string = java.net.URLConnection.guessContentTypeFromStream(this.is);
            }
            if (string != null) {
                messageHeader.add("content-type", string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.ftp.cd(this.url.getFile());
            this.ftp.ascii();
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.is = new PipedInputStream(pipedOutputStream);
            new FtpDirectoryThread(this, this.ftp, this.url, this.host, this.ftp.list(), pipedOutputStream).start();
            messageHeader.add("content-type", "text/html");
        }
        this.setProperties(messageHeader);
        return this.is;
    }

    public Permission getPermission() {
        if (this.permission == null) {
            int n = this.url.getPort();
            n = n < 0 ? 21 : n;
            String string = String.valueOf(this.host) + ":" + n;
            this.permission = new SocketPermission(string, "connect");
        }
        return this.permission;
    }

    String guessContentTypeFromFilename(String string) {
        return java.net.URLConnection.guessContentTypeFromName(string);
    }
}

