MetametaClass OMEAttributeMetaClass
end

MetaClass OMEClass
end

MetaClass OMEVisibleClass
	isA OMEClass
    with
	attribute
	    imagename : String;
	    imagesize : Integer;   
	    name : String
end

MetaClass OMEInstantiableClass 
	isA OMEClass, OMEVisibleClass
    with
	attribute
	    autogui : Integer
end

MetaClass OMEObjectClass
	isA OMEClass
    with
	attribute
	    {*# The target of an OMEAttribute must be of OMEAttributeClass.*}
	    OMEAttributes : OMEAttributeMetaClass;
	    
	    {*# if this is set then we use it, otherwise we use type_index*}
	    defaultname : String;

	    {*# These we provide arbitary value attribute support.*}
	    OMEValueAttributes : SimpleClass
end

MetaClass OMEElementClass
	isA OMEObjectClass
end

MetaClass OMEGrowableElementClass
	isA OMEObjectClass, OMEElementClass
end

MetaClass OMELinkClass
	isA OMEObjectClass
   with
	attribute
	    stroke : String
end

MetaClass OMEAttributeClass
    with
	attribute
	    name : String;
	    imagename : String;
	    
{*# must be width and height.*}
	    imagesize : Integer;  
	    
{*# relative to position of centre of source: dx and dy*}
	    imageposition : Integer 
end



SimpleClass OMEObject	
	in OMEObjectClass
    with
	attribute
	    name : String;
	    links : OMELink;
	    comment : String	   
end
SimpleClass OMELink
	in OMELinkClass
	isA OMEObject
    with
	attribute
	    to : OMEObject;
	    from : OMEObject
end
SimpleClass OMEElement
	in OMEElementClass
	isA OMEObject
    with
	attribute
	    parent : OMEElement
end

SimpleClass OMEGrowableElement
	in OMEGrowableElementClass
	isA OMEElement
    with
	attribute
	    children : OMEElement
end



SimpleClass SerializedView 
    with
	attribute 
	    view_objects : Token
end

SimpleClass SerializedObject
    with
	attribute
	    type : String
end



	    



