/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CORBA;

import com.sun.CORBA.MarshalOutputStream;
import com.sun.CORBA.ORB;
import com.sun.CORBA.Profile;
import com.sun.CORBA.util.HexOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.portable.InputStream;

public final class IOR {
    private String typeId;
    private int[] profileTags;
    private byte[][] profileData;
    private ORB factory;
    private Profile iop;
    private static final int InternetIOPTag = 0;

    public IOR(ORB oRB) {
        this.factory = oRB;
    }

    public IOR(ORB oRB, String string, Profile profile) {
        this(oRB);
        this.typeId = string;
        if (string.length() == 0 && profile == null) {
            this.profileTags = new int[0];
            return;
        }
        this.putProfile(profile);
    }

    public IOR(ORB oRB, String string, String string2, int n, byte[] byArray) {
        this(oRB);
        Profile profile = new Profile(oRB, string2, n, byArray);
        this.typeId = string;
        if (string.length() == 0 && profile == null) {
            this.profileTags = new int[0];
            return;
        }
        this.putProfile(profile);
    }

    public synchronized Profile getProfile() {
        if (this.iop != null) {
            return this.iop;
        }
        int n = 0;
        while (n < this.profileTags.length) {
            if (this.profileTags[n] == 0) {
                this.iop = new Profile(this.factory, this.profileData[n]);
                return this.iop;
            }
            ++n;
        }
        throw new INV_OBJREF(1, CompletionStatus.COMPLETED_NO);
    }

    public String getTypeId() {
        return this.typeId;
    }

    public boolean isEquivalent(IOR iOR) {
        return this.getProfile().isEquivalent(iOR.getProfile());
    }

    public boolean is_nil() {
        return this.profileTags.length == 0;
    }

    public void putProfile(Profile profile) {
        int n = 0;
        if (this.profileTags != null) {
            n = this.profileTags.length;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.profileTags[n2] == 0) {
                this.profileData[n2] = profile.getEncapsulation();
                this.iop = profile;
                return;
            }
            ++n2;
        }
        int[] nArray = new int[n + 1];
        byte[][] byArray = new byte[n + 1][];
        n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.profileTags[n2];
            byArray[n2] = this.profileData[n2];
            ++n2;
        }
        nArray[n2] = 0;
        byArray[n2] = profile.getEncapsulation();
        this.profileTags = nArray;
        this.profileData = byArray;
        this.iop = profile;
    }

    public void read(InputStream inputStream) {
        this.typeId = inputStream.read_string();
        int n = inputStream.read_long();
        this.profileTags = new int[n];
        this.profileData = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            this.profileTags[n2] = inputStream.read_long();
            this.profileData[n2] = new byte[inputStream.read_long()];
            inputStream.read_octet_array(this.profileData[n2], 0, this.profileData[n2].length);
            ++n2;
        }
    }

    public String stringify() {
        MarshalOutputStream marshalOutputStream = this.factory.newOutputStream();
        marshalOutputStream.putEndian();
        this.write(marshalOutputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            marshalOutputStream.writeTo(new HexOutputStream(byteArrayOutputStream));
        }
        catch (IOException iOException) {
            throw new INTERNAL(10, CompletionStatus.COMPLETED_NO);
        }
        return "IOR:" + byteArrayOutputStream;
    }

    public void write(MarshalOutputStream marshalOutputStream) {
        marshalOutputStream.write_string(this.typeId);
        marshalOutputStream.write_long(this.profileTags.length);
        int n = 0;
        while (n < this.profileTags.length) {
            marshalOutputStream.write_long(this.profileTags[n]);
            marshalOutputStream.write_long(this.profileData[n].length);
            marshalOutputStream.write_octet_array(this.profileData[n], 0, this.profileData[n].length);
            ++n;
        }
    }
}

