/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.MimeTypeParseException;
import java.util.Enumeration;
import java.util.Hashtable;

class MimeTypeParameterList
implements Cloneable {
    private Hashtable parameters;
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public MimeTypeParameterList() {
        this.parameters = new Hashtable();
    }

    public MimeTypeParameterList(String string) throws MimeTypeParseException {
        this.parameters = new Hashtable();
        this.parse(string);
    }

    private MimeTypeParameterList(Hashtable hashtable) throws CloneNotSupportedException {
        this.parameters = (Hashtable)hashtable.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        return new MimeTypeParameterList(this.parameters);
    }

    public String get(String string) {
        return (String)this.parameters.get(string.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(String string) throws MimeTypeParseException {
        int n = string.length();
        if (n <= 0) return;
        int n2 = MimeTypeParameterList.skipWhiteSpace(string, 0);
        int n3 = 0;
        if (n2 >= n) return;
        char c = string.charAt(n2);
        while (n2 < n && c == ';') {
            String string2;
            boolean bl;
            ++n2;
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n) throw new MimeTypeParseException("Couldn't find parameter name");
            n3 = n2;
            c = string.charAt(n2);
            while (n2 < n && MimeTypeParameterList.isTokenChar(c)) {
                c = string.charAt(++n2);
            }
            String string3 = string.substring(n3, n2).toLowerCase();
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n || string.charAt(n2) != '=') throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            ++n2;
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n) throw new MimeTypeParseException("Couldn't find a value for parameter named " + string3);
            c = string.charAt(n2);
            if (c == '\"') {
                n3 = ++n2;
                if (n2 >= n) throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                bl = false;
                while (n2 < n && !bl) {
                    c = string.charAt(n2);
                    if (c == '\\') {
                        n2 += 2;
                        continue;
                    }
                    if (c == '\"') {
                        bl = true;
                        continue;
                    }
                    ++n2;
                }
                if (c != '\"') throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                string2 = MimeTypeParameterList.unquote(string.substring(n3, n2));
                ++n2;
            } else {
                if (!MimeTypeParameterList.isTokenChar(c)) throw new MimeTypeParseException("Unexpected character encountered at index " + n2);
                n3 = n2;
                bl = false;
                while (n2 < n && !bl) {
                    c = string.charAt(n2);
                    if (MimeTypeParameterList.isTokenChar(c)) {
                        ++n2;
                        continue;
                    }
                    bl = true;
                }
                string2 = string.substring(n3, n2);
            }
            this.parameters.put(string3, string2);
            n2 = MimeTypeParameterList.skipWhiteSpace(string, n2);
            if (n2 >= n) continue;
            c = string.charAt(n2);
        }
        if (n2 >= n) return;
        throw new MimeTypeParseException("More characters encountered in input than expected.");
    }

    private static String quote(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        while (n2 < n && !bl) {
            bl = MimeTypeParameterList.isTokenChar(string.charAt(n2)) ^ true;
            ++n2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.ensureCapacity((int)((double)n * 1.5));
            stringBuffer.append('\"');
            int n3 = 0;
            while (n3 < n) {
                char c = string.charAt(n3);
                if (c == '\\' || c == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                ++n3;
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    public void remove(String string) {
        this.parameters.remove(string.trim().toLowerCase());
    }

    public void set(String string, String string2) {
        this.parameters.put(string.trim().toLowerCase(), string2);
    }

    public int size() {
        return this.parameters.size();
    }

    private static int skipWhiteSpace(String string, int n) {
        int n2 = string.length();
        if (n < n2) {
            char c = string.charAt(n);
            while (n < n2 && Character.isWhitespace(c)) {
                c = string.charAt(++n);
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("; ");
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(MimeTypeParameterList.quote((String)this.parameters.get(string)));
        }
        return stringBuffer.toString();
    }

    private static String unquote(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!bl && c != '\\') {
                stringBuffer.append(c);
            } else if (bl) {
                stringBuffer.append(c);
                bl = false;
            } else {
                bl = true;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

