/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextJustifier;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.im.InputMethodHighlight;
import java.io.Serializable;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import sun.awt.SunToolkit;
import sun.awt.font.Bidi;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.ExtendedTextLabelComponent;
import sun.awt.font.GraphicComponent;
import sun.awt.font.TextLabelFactory;
import sun.awt.font.TextLineComponent;
import sun.awt.im.InputMethodHighlightMapping;
import sun.java2d.SunGraphicsEnvironment;

final class TextLine {
    private TextLineComponent[] fComponents;
    private float[] fBaselineOffsets;
    private int[] fComponentVisualOrder;
    private char[] fChars;
    private int fCharsStart;
    private int fCharsLimit;
    private int[] fCharVisualOrder;
    private int[] fCharLogicalOrder;
    private byte[] fCharLevels;
    private boolean fIsDirectionLTR;
    private TextLineMetrics fMetrics = null;
    private static Function fgAdvanceF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            return textLineComponent.getCharAdvance(n2);
        }
    };
    private static Function fgXPositionF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            int n3;
            float f = 0.0f;
            if (textLine.fComponentVisualOrder == null) {
                n3 = 0;
                while (n3 < n) {
                    Rectangle2D rectangle2D = textLine.fComponents[n3].getLogicalBounds();
                    f += (float)rectangle2D.getWidth();
                    ++n3;
                }
            } else {
                n3 = 0;
                while (textLine.fComponentVisualOrder[n3] != n) {
                    int n4 = textLine.fComponentVisualOrder[n3];
                    Rectangle2D rectangle2D = textLine.fComponents[n4].getLogicalBounds();
                    f += (float)rectangle2D.getWidth();
                    ++n3;
                }
            }
            TextLineComponent textLineComponent = textLine.fComponents[n];
            return f + textLineComponent.getCharX(n2);
        }
    };
    private static Function fgYPositionF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            float f = textLineComponent.getCharY(n2);
            return f + textLine.getComponentShift(n);
        }
    };

    public TextLine(TextLineComponent[] textLineComponentArray, float[] fArray, char[] cArray, int n, int n2, int[] nArray, byte[] byArray, boolean bl) {
        int[] nArray2 = TextLine.computeComponentOrder(textLineComponentArray, nArray);
        this.fComponents = textLineComponentArray;
        this.fBaselineOffsets = fArray;
        this.fComponentVisualOrder = nArray2;
        this.fChars = cArray;
        this.fCharsStart = n;
        this.fCharsLimit = n2;
        this.fCharLogicalOrder = nArray;
        this.fCharLevels = byArray;
        this.fIsDirectionLTR = bl;
        this.checkCtorArgs();
    }

    private static Map addInputMethodAttrs(Map map) {
        Object object = map.get(TextAttribute.INPUT_METHOD_HIGHLIGHT);
        try {
            if (object != null) {
                if (object instanceof Annotation) {
                    object = ((Annotation)object).getValue();
                }
                InputMethodHighlight inputMethodHighlight = (InputMethodHighlight)object;
                SunToolkit sunToolkit = (SunToolkit)Toolkit.getDefaultToolkit();
                InputMethodHighlightMapping inputMethodHighlightMapping = sunToolkit.getInputMethodHighlightMapping();
                Map map2 = inputMethodHighlightMapping.mapHighlight(inputMethodHighlight);
                if (map2 != null) {
                    Hashtable hashtable = new Hashtable(5, 0.9f);
                    hashtable.putAll(map);
                    hashtable.putAll(map2);
                    return hashtable;
                }
            }
        }
        catch (ClassCastException classCastException) {}
        return map;
    }

    private float applyFunctionAtIndex(int n, Function function) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fComponents.length) {
            int n4 = n2 + this.fComponents[n3].getNumCharacters();
            if (n4 > n) {
                return function.computeFunction(this, n3, n - n2);
            }
            n2 = n4;
            ++n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public boolean caretAtOffsetIsValid(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative offset.");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fComponents.length) {
            int n4 = n2 + this.fComponents[n3].getNumCharacters();
            if (n4 > n) {
                return this.fComponents[n3].caretAtOffsetIsValid(n - n2);
            }
            n2 = n4;
            ++n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public int characterCount() {
        return this.fCharsLimit - this.fCharsStart;
    }

    private void checkCtorArgs() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fComponents.length) {
            n += this.fComponents[n2].getNumCharacters();
            ++n2;
        }
        if (n != this.characterCount()) {
            throw new IllegalArgumentException("Invalid TextLine!  char count is different from sum of char counts of components.");
        }
    }

    private static int[] computeComponentOrder(TextLineComponent[] textLineComponentArray, int[] nArray) {
        int[] nArray2 = null;
        if (nArray != null && textLineComponentArray.length > 1) {
            nArray2 = new int[textLineComponentArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < textLineComponentArray.length) {
                nArray2[n2] = nArray[n];
                n += textLineComponentArray[n2].getNumCharacters();
                ++n2;
            }
            nArray2 = Bidi.getContiguousOrder(nArray2);
            nArray2 = Bidi.getInverseOrder(nArray2);
        }
        return nArray2;
    }

    public static TextLine createLineFromText(char[] cArray, int n, int n2, FontSource fontSource, TextLabelFactory textLabelFactory, boolean bl, float[] fArray) {
        textLabelFactory.setLineContext(n, n2);
        Bidi bidi = textLabelFactory.getLineBidi();
        int[] nArray = null;
        byte[] byArray = null;
        if (bidi != null) {
            nArray = bidi.getLogicalToVisualMap();
            byArray = bidi.getLevels();
        }
        TextLineComponent[] textLineComponentArray = TextLine.getComponents(fontSource, cArray, n, n2, nArray, byArray, textLabelFactory);
        return new TextLine(textLineComponentArray, fArray, cArray, n, n2, nArray, byArray, bl);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        float f3 = f;
        int n = 0;
        while (n < this.fComponents.length) {
            int n2 = this.fComponentVisualOrder == null ? n : this.fComponentVisualOrder[n];
            TextLineComponent textLineComponent = this.fComponents[n2];
            float f4 = this.getComponentShift(n2);
            textLineComponent.draw(graphics2D, f3, f2 + f4);
            if (n != this.fComponents.length - 1) {
                Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
                f3 += (float)rectangle2D.getWidth();
            }
            ++n;
        }
    }

    private static TextLineComponent[] expandArrays(TextLineComponent[] textLineComponentArray) {
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[textLineComponentArray.length + 8];
        System.arraycopy(textLineComponentArray, 0, textLineComponentArray2, 0, textLineComponentArray.length);
        return textLineComponentArray2;
    }

    public static TextLine fastCreateTextLine(FontRenderContext fontRenderContext, char[] cArray, int n, int n2, Font font, LineMetrics lineMetrics, Map map) {
        TextLineComponent[] textLineComponentArray;
        int n3;
        byte by;
        char[] cArray2;
        boolean bl = true;
        byte[] byArray = null;
        int[] nArray = null;
        Bidi bidi = null;
        int n4 = n2 - n;
        if (n != 0) {
            cArray2 = new char[n4];
            System.arraycopy(cArray, n, cArray2, 0, n4);
        } else {
            cArray2 = cArray;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray2 = null;
        if (map != null) {
            Serializable serializable;
            try {
                serializable = (Boolean)map.get(TextAttribute.RUN_DIRECTION);
                if (serializable != null) {
                    bl3 = true;
                    bl = TextAttribute.RUN_DIRECTION_LTR.equals(serializable);
                    bl2 = bl ^ true;
                }
            }
            catch (ClassCastException classCastException) {}
            try {
                int n5;
                serializable = (Integer)map.get(TextAttribute.BIDI_EMBEDDING);
                if (serializable != null && (n5 = ((Integer)serializable).intValue()) >= -15 && n5 < 16) {
                    by = (byte)n5;
                    bl2 = true;
                    byArray2 = new byte[n4];
                    n3 = 0;
                    while (n3 < byArray2.length) {
                        byArray2[n3] = by;
                        ++n3;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
        }
        if (!bl2) {
            int n6 = 0;
            while (n6 < cArray2.length) {
                if (Bidi.requiresBidi(cArray2[n6])) {
                    bl2 = true;
                    break;
                }
                ++n6;
            }
        }
        if (bl2) {
            if (!bl3) {
                bl = Bidi.defaultIsLTR(cArray2, 0, n4);
            }
            if (byArray2 == null) {
                byArray2 = Bidi.getEmbeddingArray(cArray2, bl);
            }
            bidi = new Bidi(cArray2, byArray2, bl);
            byArray = bidi.getLevels();
            nArray = bidi.getLogicalToVisualMap();
        }
        if (map != null) {
            map = TextLine.addInputMethodAttrs(map);
        }
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray2, bidi);
        if (bidi == null || bidi.getLevelLimit(0) == n4) {
            textLineComponentArray = new TextLineComponent[1];
            ExtendedTextLabel extendedTextLabel = textLabelFactory.createExtended(font, lineMetrics, 0, n4);
            textLineComponentArray[0] = new ExtendedTextLabelComponent(extendedTextLabel, map);
        } else {
            by = 0;
            n3 = 0;
            while (n3 < n4) {
                n3 = bidi.getLevelLimit(n3);
                by = (byte)(by + 1);
            }
            textLineComponentArray = new TextLineComponent[by];
            by = 0;
            n3 = 0;
            while (n3 < n4) {
                int n7 = bidi.getLevelLimit(n3);
                ExtendedTextLabel extendedTextLabel = textLabelFactory.createExtended(font, lineMetrics, n3, n7);
                textLineComponentArray[by] = new ExtendedTextLabelComponent(extendedTextLabel, map);
                by = (byte)(by + 1);
                n3 = n7;
            }
        }
        return new TextLine(textLineComponentArray, lineMetrics.getBaselineOffsets(), cArray, n, n2, nArray, byArray, bl);
    }

    private static int firstVisualChunk(int[] nArray, byte[] byArray, int n, int n2) {
        if (nArray != null && byArray != null) {
            byte by = byArray[n];
            while (++n < n2 && byArray[n] == by) {
            }
            return n;
        }
        return n2;
    }

    public static float getAdvanceBetween(TextLineComponent[] textLineComponentArray, int n, int n2) {
        float f = 0.0f;
        int n3 = 0;
        int n4 = 0;
        while (n4 < textLineComponentArray.length) {
            TextLineComponent textLineComponent = textLineComponentArray[n4];
            int n5 = textLineComponent.getNumCharacters();
            int n6 = n3 + n5;
            if (n6 > n) {
                int n7 = Math.max(0, n - n3);
                int n8 = Math.min(n5, n2 - n3);
                f += textLineComponent.getAdvanceBetween(n7, n8);
                if (n6 >= n2) break;
            }
            n3 = n6;
            ++n4;
        }
        return f;
    }

    public Rectangle2D getBounds() {
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MIN_VALUE;
        int n = 0;
        while (n < this.fComponents.length) {
            int n2 = this.fComponentVisualOrder == null ? n : this.fComponentVisualOrder[n];
            TextLineComponent textLineComponent = this.fComponents[n2];
            Rectangle2D rectangle2D = textLineComponent.getVisualBounds();
            f2 = Math.min(f2, (float)rectangle2D.getX() + f);
            f3 = Math.max(f3, (float)rectangle2D.getMaxX() + f);
            float f6 = this.getComponentShift(n2);
            f4 = Math.min(f4, (float)rectangle2D.getY() + f6);
            f5 = Math.max(f5, (float)rectangle2D.getMaxY() + f6);
            Rectangle2D rectangle2D2 = textLineComponent.getLogicalBounds();
            f += (float)rectangle2D2.getWidth();
            ++n;
        }
        return new Rectangle2D.Float(f2, f4, f3 - f2, f5 - f4);
    }

    public float getCharAdvance(int n) {
        return this.applyFunctionAtIndex(n, fgAdvanceF);
    }

    public float getCharAngle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (n > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 += this.fComponents[n2].getNumCharacters()) <= n && ++n2 < this.fComponents.length) {
        }
        return this.fComponents[n2].getItalicAngle();
    }

    public float getCharAscent(int n) {
        return this.getLineMetricsAt(n).getAscent();
    }

    public Rectangle2D getCharBounds(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fComponents.length) {
            int n4 = n2 + this.fComponents[n3].getNumCharacters();
            if (n4 > n) {
                TextLineComponent textLineComponent = this.fComponents[n3];
                int n5 = n - n2;
                Rectangle2D rectangle2D = textLineComponent.getCharVisualBounds(n5);
                float f = 0.0f;
                if (this.fComponentVisualOrder == null) {
                    int n6 = 0;
                    while (n6 < n3) {
                        Rectangle2D rectangle2D2 = this.fComponents[n6].getLogicalBounds();
                        f += (float)rectangle2D2.getWidth();
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (this.fComponentVisualOrder[n7] != n3) {
                        int n8 = this.fComponentVisualOrder[n7];
                        Rectangle2D rectangle2D3 = this.fComponents[n8].getLogicalBounds();
                        f += (float)rectangle2D3.getWidth();
                        ++n7;
                    }
                }
                rectangle2D.setRect(rectangle2D.getX() + (double)f, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                return rectangle2D;
            }
            n2 = n4;
            ++n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public float getCharDescent(int n) {
        return this.getLineMetricsAt(n).getDescent();
    }

    public byte getCharLevel(int n) {
        return this.fCharLevels == null ? (byte)0 : this.fCharLevels[n];
    }

    public float getCharLinePosition(int n) {
        return this.getCharXPosition(n);
    }

    public int getCharType(int n) {
        return Character.getType(this.fChars[n + this.fCharsStart]);
    }

    public float getCharXPosition(int n) {
        return this.applyFunctionAtIndex(n, fgXPositionF);
    }

    public float getCharYPosition(int n) {
        return this.applyFunctionAtIndex(n, fgYPositionF);
    }

    private float getComponentShift(int n) {
        byte by = (byte)this.fComponents[n].getLineMetrics().getBaselineIndex();
        if (by >= 0) {
            return this.fBaselineOffsets[by];
        }
        TextLineMetrics textLineMetrics = this.getMetrics();
        LineMetrics lineMetrics = this.fComponents[n].getLineMetrics();
        if (by == -1) {
            return lineMetrics.getAscent() - textLineMetrics.ascent;
        }
        return textLineMetrics.descent - lineMetrics.getDescent();
    }

    public static TextLineComponent[] getComponents(FontSource fontSource, char[] cArray, int n, int n2, int[] nArray, byte[] byArray, TextLabelFactory textLabelFactory) {
        TextLineComponent[] textLineComponentArray;
        FontRenderContext fontRenderContext = textLabelFactory.getFontRenderContext();
        int n3 = 0;
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[8];
        int n4 = n;
        do {
            Object object;
            int n5;
            GraphicAttribute graphicAttribute;
            int n6;
            if ((n6 = fontSource.getRunLimit(n4)) > n2) {
                n6 = n2;
            }
            if ((graphicAttribute = fontSource.graphicAt(n4)) != null) {
                do {
                    n5 = n + TextLine.firstVisualChunk(nArray, byArray, n4 - n, n6 - n);
                    object = fontSource.attributesAt(n4);
                    GraphicComponent graphicComponent = new GraphicComponent(graphicAttribute, (Map)object, nArray, byArray, n4 - n, n5 - n);
                    n4 = n5;
                    if (++n3 >= textLineComponentArray2.length) {
                        textLineComponentArray2 = TextLine.expandArrays(textLineComponentArray2);
                    }
                    textLineComponentArray2[n3 - 1] = graphicComponent;
                } while (n4 < n6);
                continue;
            }
            do {
                n5 = n6;
                object = fontSource.fontAt(n4);
                if (object == null && (n5 = ((Font)(object = fontSource.getBestFontAt(n4))).canDisplayUpTo(cArray, n4, n6)) == n4) {
                    ++n5;
                }
                do {
                    int n7 = n + TextLine.firstVisualChunk(nArray, byArray, n4 - n, n5 - n);
                    do {
                        Map map = fontSource.attributesAt(n4);
                        int n8 = n4;
                        LineMetrics lineMetrics = ((Font)object).getLineMetrics(cArray, n4, n7, fontRenderContext);
                        ExtendedTextLabel extendedTextLabel = textLabelFactory.createExtended((Font)object, lineMetrics, n8, n4 += lineMetrics.getNumChars());
                        map = TextLine.addInputMethodAttrs(map);
                        ExtendedTextLabelComponent extendedTextLabelComponent = new ExtendedTextLabelComponent(extendedTextLabel, map);
                        if (++n3 >= textLineComponentArray2.length) {
                            textLineComponentArray2 = TextLine.expandArrays(textLineComponentArray2);
                        }
                        textLineComponentArray2[n3 - 1] = extendedTextLabelComponent;
                    } while (n4 < n7);
                } while (n4 < n5);
            } while (n4 < n6);
        } while (n4 < n2);
        if (textLineComponentArray2.length == n3) {
            textLineComponentArray = textLineComponentArray2;
        } else {
            textLineComponentArray = new TextLineComponent[n3];
            System.arraycopy(textLineComponentArray2, 0, textLineComponentArray, 0, n3);
        }
        return textLineComponentArray;
    }

    public TextLine getJustifiedLine(float f, float f2, int n, int n2) {
        boolean bl;
        TextLineComponent[] textLineComponentArray = new TextLineComponent[this.fComponents.length];
        System.arraycopy(this.fComponents, 0, textLineComponentArray, 0, this.fComponents.length);
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl2 = false;
        block0: do {
            int n3;
            int n4;
            f4 = TextLine.getAdvanceBetween(textLineComponentArray, 0, this.characterCount());
            float f6 = TextLine.getAdvanceBetween(textLineComponentArray, n, n2);
            f5 = (f - f6) * f2;
            int[] nArray = new int[textLineComponentArray.length];
            int n5 = 0;
            int n6 = 0;
            while (n6 < textLineComponentArray.length) {
                int n7 = this.fComponentVisualOrder == null ? n6 : this.fComponentVisualOrder[n6];
                nArray[n7] = n5;
                n5 += textLineComponentArray[n7].getNumJustificationInfos();
                ++n6;
            }
            GlyphJustificationInfo[] glyphJustificationInfoArray = new GlyphJustificationInfo[n5];
            int n8 = 0;
            int n9 = 0;
            while (n9 < textLineComponentArray.length) {
                TextLineComponent textLineComponent = textLineComponentArray[n9];
                n4 = textLineComponent.getNumCharacters();
                int n10 = n8 + n4;
                if (n10 > n) {
                    int n11 = Math.max(0, n - n8);
                    n3 = Math.min(n4, n2 - n8);
                    textLineComponent.getJustificationInfos(glyphJustificationInfoArray, nArray[n9], n11, n3);
                    if (n10 >= n2) break;
                }
                ++n9;
            }
            int n12 = 0;
            n4 = n5;
            while (n12 < n4 && glyphJustificationInfoArray[n12] == null) {
                ++n12;
            }
            while (n4 > n12 && glyphJustificationInfoArray[n4 - 1] == null) {
                --n4;
            }
            TextJustifier textJustifier = new TextJustifier(glyphJustificationInfoArray, n12, n4);
            float[] fArray = textJustifier.justify(f5);
            n3 = bl2 ? 0 : 1;
            bl = false;
            boolean[] blArray = new boolean[1];
            n8 = 0;
            int n13 = 0;
            while (n13 < textLineComponentArray.length) {
                TextLineComponent textLineComponent = textLineComponentArray[n13];
                int n14 = textLineComponent.getNumCharacters();
                int n15 = n8 + n14;
                if (n15 > n) {
                    int n16 = Math.max(0, n - n8);
                    int n17 = Math.min(n14, n2 - n8);
                    textLineComponentArray[n13] = textLineComponent.applyJustificationDeltas(fArray, nArray[n13] * 2, blArray);
                    bl |= blArray[0];
                    if (n15 >= n2) continue block0;
                }
                ++n13;
            }
        } while (bl2 = bl && !bl2);
        return new TextLine(textLineComponentArray, this.fBaselineOffsets, this.fChars, this.fCharsStart, this.fCharsLimit, this.fCharLogicalOrder, this.fCharLevels, this.fIsDirectionLTR);
    }

    private LineMetrics getLineMetricsAt(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (n > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n4 += this.fComponents[n2].getNumCharacters()) <= n) {
            n3 = n4;
            if (++n2 < this.fComponents.length) continue;
        }
        return this.fComponents[n2].getLineMetrics();
    }

    public TextLineMetrics getMetrics() {
        if (this.fMetrics == null) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            boolean bl = false;
            int n = 0;
            while (n < this.fComponents.length) {
                float f7;
                float f8;
                TextLineComponent textLineComponent = this.fComponents[n];
                Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
                f4 += (float)rectangle2D.getWidth();
                byte by = (byte)textLineComponent.getLineMetrics().getBaselineIndex();
                LineMetrics lineMetrics = textLineComponent.getLineMetrics();
                if (by >= 0) {
                    f8 = this.fBaselineOffsets[by];
                    f = Math.max(f, -f8 + lineMetrics.getAscent());
                    f7 = f8 + lineMetrics.getDescent();
                    f2 = Math.max(f2, f7);
                    f3 = Math.max(f3, f7 + lineMetrics.getLeading());
                } else {
                    bl = true;
                    f8 = lineMetrics.getAscent() + lineMetrics.getDescent();
                    f7 = f8 + lineMetrics.getLeading();
                    f5 = Math.max(f5, f8);
                    f6 = Math.max(f6, f7);
                }
                ++n;
            }
            if (bl) {
                if (f5 > f + f2) {
                    f2 = f5 - f;
                }
                if (f6 > f + f3) {
                    f3 = f6 - f;
                }
            }
            this.fMetrics = new TextLineMetrics(f, f2, f3 -= f2, f4);
        }
        return this.fMetrics;
    }

    public Shape getOutline(AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath(0);
        float f = 0.0f;
        int n = 0;
        while (n < this.fComponents.length) {
            int n2 = this.fComponentVisualOrder == null ? n : this.fComponentVisualOrder[n];
            TextLineComponent textLineComponent = this.fComponents[n2];
            float f2 = this.getComponentShift(n2);
            generalPath.append(textLineComponent.getOutline(f, f2), false);
            Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
            f += (float)rectangle2D.getWidth();
            ++n;
        }
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public int hashCode() {
        return this.fComponents.length << 16 ^ this.fComponents[0].hashCode() << 3 ^ this.fCharsLimit - this.fCharsStart;
    }

    public boolean isCharLTR(int n) {
        return (this.getCharLevel(n) & 1) == 0;
    }

    public boolean isCharSpace(int n) {
        return Character.isSpaceChar(this.fChars[n + this.fCharsStart]);
    }

    public boolean isCharWhitespace(int n) {
        return Character.isWhitespace(this.fChars[n + this.fCharsStart]);
    }

    public boolean isDirectionLTR() {
        return this.fIsDirectionLTR;
    }

    public int logicalToVisual(int n) {
        return this.fCharLogicalOrder == null ? n : this.fCharLogicalOrder[n];
    }

    public static TextLine standardCreateTextLine(FontRenderContext fontRenderContext, AttributedCharacterIterator attributedCharacterIterator, char[] cArray, float[] fArray) {
        Object object;
        int n;
        ACIFontSource aCIFontSource = new ACIFontSource(attributedCharacterIterator);
        boolean bl = true;
        Bidi bidi = null;
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray = null;
        attributedCharacterIterator.first();
        Map map = attributedCharacterIterator.getAttributes();
        if (map != null) {
            try {
                Boolean bl4 = (Boolean)map.get(TextAttribute.RUN_DIRECTION);
                if (bl4 != null) {
                    bl3 = true;
                    bl = TextAttribute.RUN_DIRECTION_LTR.equals(bl4);
                    bl2 = bl ^ true;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        int n2 = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        int n4 = n2;
        byte by = 0;
        byte by2 = (byte)(bl3 && !bl ? 1 : 0);
        do {
            int n5;
            block21: {
                attributedCharacterIterator.setIndex(n4);
                map = attributedCharacterIterator.getAttributes();
                object = map.get(TextAttribute.BIDI_EMBEDDING);
                n = attributedCharacterIterator.getRunLimit(TextAttribute.BIDI_EMBEDDING);
                if (object != null) {
                    try {
                        n5 = (Integer)object;
                        if (n5 < -15 || n5 >= 16) break block21;
                        by = (byte)n5;
                        if (byArray == null) {
                            byArray = new byte[cArray.length];
                            bl2 = true;
                            if (!bl3) {
                                bl3 = true;
                                bl = Bidi.defaultIsLTR(cArray, 0, cArray.length);
                                by2 = (byte)(!bl ? 1 : 0);
                            }
                            if (!bl) {
                                int n6 = 0;
                                while (n6 < n4 - n2) {
                                    byArray[n6] = by2;
                                    ++n6;
                                }
                            }
                        }
                    }
                    catch (ClassCastException classCastException) {}
                } else if (byArray != null) {
                    by = by2;
                }
            }
            if (byArray == null || by == 0) continue;
            n5 = n4 - n2;
            while (n5 < n - n2) {
                byArray[n5] = by;
                ++n5;
            }
        } while ((n4 = n) < n3);
        if (!bl2) {
            int n7 = 0;
            while (n7 < cArray.length) {
                if (Bidi.requiresBidi(cArray[n7])) {
                    bl2 = true;
                    break;
                }
                ++n7;
            }
        }
        if (bl2) {
            if (!bl3) {
                bl = Bidi.defaultIsLTR(cArray, 0, cArray.length);
            }
            if (byArray == null) {
                byArray = Bidi.getEmbeddingArray(cArray, bl);
            }
            bidi = new Bidi(cArray, byArray, bl);
        }
        object = new TextLabelFactory(fontRenderContext, cArray, bidi);
        return TextLine.createLineFromText(cArray, 0, cArray.length, aCIFontSource, (TextLabelFactory)object, bl, fArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fComponents.length) {
            stringBuffer.append(this.fComponents[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int visualToLogical(int n) {
        if (this.fCharLogicalOrder == null) {
            return n;
        }
        if (this.fCharVisualOrder == null) {
            this.fCharVisualOrder = Bidi.getInverseOrder(this.fCharLogicalOrder);
        }
        return this.fCharVisualOrder[n];
    }

    public static final class TextLineMetrics {
        public final float ascent;
        public final float descent;
        public final float leading;
        public final float advance;

        public TextLineMetrics(float f, float f2, float f3, float f4) {
            this.ascent = f;
            this.descent = f2;
            this.leading = f3;
            this.advance = f4;
        }
    }

    private static abstract class Function {
        Function() {
        }

        abstract float computeFunction(TextLine var1, int var2, int var3);
    }

    static abstract class FontSource {
        FontSource() {
        }

        abstract Map attributesAt(int var1);

        abstract Font fontAt(int var1);

        abstract Font getBestFontAt(int var1);

        abstract int getLength();

        abstract int getRunLimit(int var1);

        abstract GraphicAttribute graphicAt(int var1);
    }

    static class ACIFontSource
    extends FontSource {
        private AttributedCharacterIterator fIter;
        private int fIterStart;

        public ACIFontSource(AttributedCharacterIterator attributedCharacterIterator) {
            this.fIter = attributedCharacterIterator;
            this.fIterStart = attributedCharacterIterator.getBeginIndex();
        }

        Map attributesAt(int n) {
            this.fIter.setIndex(n + this.fIterStart);
            return this.fIter.getAttributes();
        }

        Font fontAt(int n) {
            this.fIter.setIndex(n + this.fIterStart);
            return (Font)this.fIter.getAttribute(TextAttribute.FONT);
        }

        Font getBestFontAt(int n) {
            int n2 = n + this.fIterStart;
            this.fIter.setIndex(n2);
            return SunGraphicsEnvironment.getBestFontFor(this.fIter, n2, this.fIter.getRunLimit());
        }

        int getLength() {
            return this.fIter.getEndIndex() - this.fIterStart;
        }

        int getRunLimit(int n) {
            this.fIter.setIndex(n + this.fIterStart);
            return this.fIter.getRunLimit() - this.fIterStart;
        }

        GraphicAttribute graphicAt(int n) {
            this.fIter.setIndex(n + this.fIterStart);
            return (GraphicAttribute)this.fIter.getAttribute(TextAttribute.CHAR_REPLACEMENT);
        }
    }
}

