/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import sun.awt.font.TextSource;

public class StandardTextSource
extends TextSource {
    char[] chars;
    int start;
    int len;
    int cstart;
    int clen;
    int level;
    int linedir;
    Font font;
    FontRenderContext frc;
    LineMetrics lm;

    public StandardTextSource(String string, int n, int n2, Font font, FontRenderContext fontRenderContext) {
        this(string.toCharArray(), 0, string.length(), 0, string.length(), n, n2, font, fontRenderContext, null);
    }

    public StandardTextSource(char[] cArray, int n, int n2, int n3, int n4, int n5, int n6, Font font, FontRenderContext fontRenderContext, LineMetrics lineMetrics) {
        if (cArray == null) {
            throw new IllegalArgumentException("bad chars: null");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("bad cstart: " + n3);
        }
        if (n < n3) {
            throw new IllegalArgumentException("bad start: " + n + " for cstart: " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("bad clen: " + n4);
        }
        if (n3 + n4 > cArray.length) {
            throw new IllegalArgumentException("bad clen: " + n4 + " cstart: " + n3 + " for array len: " + cArray.length);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("bad len: " + n2);
        }
        if (n + n2 > n3 + n4) {
            throw new IllegalArgumentException("bad len: " + n2 + " start: " + n + " for cstart: " + n3 + " clen: " + n4);
        }
        if (font == null) {
            throw new IllegalArgumentException("bad font: null");
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException("bad frc: null");
        }
        this.chars = cArray;
        this.start = n;
        this.len = n2;
        this.cstart = n3;
        this.clen = n4;
        this.level = n5;
        this.linedir = n6;
        this.font = font;
        this.frc = fontRenderContext;
        this.lm = lineMetrics != null ? lineMetrics : font.getLineMetrics(cArray, n3, n4, fontRenderContext);
    }

    public StandardTextSource(char[] cArray, int n, int n2, int n3, int n4, Font font, FontRenderContext fontRenderContext, LineMetrics lineMetrics) {
        this(cArray, n, n2, n, n2, n3, n4, font, fontRenderContext, lineMetrics);
    }

    public StandardTextSource(char[] cArray, int n, int n2, Font font, FontRenderContext fontRenderContext) {
        this(cArray, 0, cArray.length, 0, cArray.length, n, n2, font, fontRenderContext, null);
    }

    public boolean dataIsLTR() {
        return (this.level & 1) == 0;
    }

    public int getBidiLevel() {
        return this.level;
    }

    public char[] getChars() {
        return this.chars;
    }

    public int getContextLength() {
        return this.clen;
    }

    public int getContextStart() {
        return this.cstart;
    }

    public FontRenderContext getFRC() {
        return this.frc;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLength() {
        return this.len;
    }

    public LineMetrics getLineMetrics() {
        return this.lm;
    }

    public int getStart() {
        return this.start;
    }

    public TextSource getSubSource(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n + n2 > this.len) {
            throw new IllegalArgumentException("bad start (" + n + ") or length (" + n2 + ")");
        }
        int n4 = this.level;
        if (n3 != 2) {
            boolean bl = this.lineIsLTR();
            if (!(n3 == 0 && bl || n3 == 1 && !bl)) {
                throw new IllegalArgumentException("direction flag is invalid");
            }
            n4 = bl ? 0 : 1;
        }
        return new StandardTextSource(this.chars, this.start + n, n2, this.cstart, this.clen, n4, this.linedir, this.font, this.frc, this.lm);
    }

    public boolean lineIsLTR() {
        return (this.linedir & 1) == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[start:");
        stringBuffer.append(this.start);
        stringBuffer.append(", len:");
        stringBuffer.append(this.len);
        stringBuffer.append(", cstart:");
        stringBuffer.append(this.cstart);
        stringBuffer.append(", clen:");
        stringBuffer.append(this.clen);
        stringBuffer.append(", chars:\"");
        int n = this.cstart;
        int n2 = this.cstart + this.clen;
        while (n < n2) {
            if (n > this.cstart) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Integer.toHexString(this.chars[n]));
            ++n;
        }
        stringBuffer.append("\"");
        stringBuffer.append(", level:");
        stringBuffer.append(this.level);
        stringBuffer.append(", linedir:");
        stringBuffer.append(this.linedir);
        stringBuffer.append(", font:");
        stringBuffer.append(this.font);
        stringBuffer.append(", frc:");
        stringBuffer.append(this.frc);
        stringBuffer.append(", lm:");
        stringBuffer.append(this.lm);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

