/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import sun.java2d.OutputManager;
import sun.java2d.loops.RasterOutputManager;

public class BufferedImageGraphicsConfig
extends GraphicsConfiguration {
    private static final int numconfigs = 12;
    private static BufferedImageGraphicsConfig[] configs = new BufferedImageGraphicsConfig[12];
    BufferedImage bImg;

    public BufferedImageGraphicsConfig(BufferedImage bufferedImage) {
        this.bImg = bufferedImage;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.bImg.getColorModel();
        WritableRaster writableRaster = this.bImg.getRaster().createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        return this.createCompatibleImage(n, n2);
    }

    public ColorModel getColorModel() {
        return this.bImg.getColorModel();
    }

    public ColorModel getColorModel(int n) {
        ColorModel colorModel = this.bImg.getColorModel();
        if (colorModel.getTransparency() == n) {
            return colorModel;
        }
        return null;
    }

    public static GraphicsConfiguration getConfig(BufferedImage bufferedImage) {
        BufferedImageGraphicsConfig bufferedImageGraphicsConfig;
        int n = bufferedImage.getType();
        if (n > 0 && n < 12 && (bufferedImageGraphicsConfig = configs[n]) != null) {
            return bufferedImageGraphicsConfig;
        }
        bufferedImageGraphicsConfig = new BufferedImageGraphicsConfig(bufferedImage);
        if (n > 0 && n < 12) {
            BufferedImageGraphicsConfig.configs[n] = bufferedImageGraphicsConfig;
        }
        return bufferedImageGraphicsConfig;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public GraphicsDevice getDevice() {
        return null;
    }

    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    public static OutputManager getOutputManager(BufferedImage bufferedImage) {
        return RasterOutputManager.getManager();
    }
}

