/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;

class WMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    protected static final int motionThreshold = WMouseDragGestureRecognizer.getMotionThreshold();
    protected static final int ButtonMask = 16;
    protected static final int ModMask = 3;

    protected WMouseDragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    protected WMouseDragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    protected WMouseDragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    protected WMouseDragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        super(dragSource, component, n, dragGestureListener);
    }

    private static int getMotionThreshold() {
        try {
            return (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception exception) {
            return 5;
        }
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0xFFFFFFEC) != 0) {
            return 0;
        }
        if ((n & 0x10) != 16) {
            return 0;
        }
        if ((n &= 3) == 0) {
            return 2;
        }
        if (n == 3) {
            return 0x40000000;
        }
        if (n == 2) {
            return 1;
        }
        return 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n == 0) {
                return;
            }
            MouseEvent mouseEvent2 = (MouseEvent)this.events.get(0);
            Point point = mouseEvent2.getPoint();
            Point point2 = mouseEvent.getPoint();
            int n2 = Math.abs(point.x - point2.x);
            int n3 = Math.abs(point.y - point2.y);
            if (n2 > motionThreshold || n3 > motionThreshold) {
                this.fireDragGestureRecognized(n, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(mouseEvent);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n != 0) {
                this.appendEvent(mouseEvent);
                this.fireDragGestureRecognized(n, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.events.clear();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.events.clear();
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.appendEvent(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.clear();
    }
}

