/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.security.AccessController;
import sun.security.action.GetIntegerAction;

public final class InetAddressCachePolicy {
    private static final String cachePolicyProp = "sun.net.inetaddr.ttl";
    public static final int FOREVER = -1;
    public static final int NEVER = 0;
    private static int cachePolicy;
    private static boolean set;

    static {
        set = false;
        Integer n = (Integer)AccessController.doPrivileged(new GetIntegerAction(cachePolicyProp));
        if (n == null) {
            n = new Integer(-1);
            set = false;
        } else {
            set = true;
        }
        cachePolicy = n;
    }

    public static synchronized int get() {
        return cachePolicy;
    }

    public static synchronized void setIfNotSet(int n) {
        if (!set) {
            if (n > cachePolicy || n < -1) {
                throw new SecurityException("can't make InetAddress cache more lax");
            }
            cachePolicy = n;
        }
    }
}

