/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.MimeTypeParameterList;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class MimeType
implements Externalizable,
Cloneable {
    static final long serialVersionUID = -6568722458793895906L;
    private String primaryType;
    private String subType;
    private MimeTypeParameterList parameters;
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public MimeType() {
    }

    public MimeType(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    public MimeType(String string, String string2) throws MimeTypeParseException {
        this(string, string2, new MimeTypeParameterList());
    }

    public MimeType(String string, String string2, MimeTypeParameterList mimeTypeParameterList) throws MimeTypeParseException {
        if (!this.isValidToken(string)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        this.primaryType = string.toLowerCase();
        if (!this.isValidToken(string2)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
        this.subType = string2.toLowerCase();
        try {
            mimeTypeParameterList = (MimeTypeParameterList)mimeTypeParameterList.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("failed to clone parameter list");
        }
        try {
            this.parameters = (MimeTypeParameterList)mimeTypeParameterList.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("cannot clone parameter list");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new MimeType(this.primaryType, this.subType, this.parameters);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new CloneNotSupportedException();
        }
    }

    public String getBaseType() {
        return String.valueOf(this.primaryType) + "/" + this.subType;
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public MimeTypeParameterList getParameters() {
        try {
            return (MimeTypeParameterList)this.parameters.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("cannot clone parameter list");
        }
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private boolean isValidToken(String string) {
        int n = string.length();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!MimeType.isTokenChar(c)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean match(MimeType mimeType) {
        if (mimeType == null) {
            return false;
        }
        return this.primaryType.equals(mimeType.getPrimaryType()) && (this.subType.equals("*") || mimeType.getSubType().equals("*") || this.subType.equals(mimeType.getSubType()));
    }

    public boolean match(String string) throws MimeTypeParseException {
        if (string == null) {
            return false;
        }
        return this.match(new MimeType(string));
    }

    private void parse(String string) throws MimeTypeParseException {
        int n = string.indexOf(47);
        int n2 = string.indexOf(59);
        if (n < 0 && n2 < 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n < 0 && n2 >= 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n >= 0 && n2 < 0) {
            this.primaryType = string.substring(0, n).trim().toLowerCase();
            this.subType = string.substring(n + 1).trim().toLowerCase();
            this.parameters = new MimeTypeParameterList();
        } else if (n < n2) {
            this.primaryType = string.substring(0, n).trim().toLowerCase();
            this.subType = string.substring(n + 1, n2).trim().toLowerCase();
            this.parameters = new MimeTypeParameterList(string.substring(n2));
        } else {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (!this.isValidToken(this.primaryType)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        if (!this.isValidToken(this.subType)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.parse(objectInput.readUTF());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IOException(mimeTypeParseException.toString());
        }
    }

    public void removeParameter(String string) {
        this.parameters.remove(string);
    }

    public void setParameter(String string, String string2) {
        this.parameters.set(string, string2);
    }

    public String toString() {
        return String.valueOf(this.getBaseType()) + this.parameters.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.toString());
    }
}

