/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;

public class OutputStreamWriter
extends Writer {
    private CharToByteConverter ctb;
    private OutputStream out;
    private static final int defaultByteBufferSize = 8192;
    private byte[] bb;
    private int nextByte = 0;
    private int nBytes = 0;

    public OutputStreamWriter(OutputStream outputStream) {
        this(outputStream, CharToByteConverter.getDefault());
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, CharToByteConverter.getConverter(string));
    }

    private OutputStreamWriter(OutputStream outputStream, CharToByteConverter charToByteConverter) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("out is null");
        }
        this.out = outputStream;
        this.ctb = charToByteConverter;
        this.bb = new byte[8192];
        this.nBytes = 8192;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                Object var2_2 = null;
                return;
            }
            this.flush();
            this.out.close();
            this.out = null;
            this.bb = null;
            this.ctb = null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.out.flush();
        }
    }

    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                try {
                    this.nextByte += this.ctb.flushAny(this.bb, this.nextByte, this.nBytes);
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte == 0) break;
                if (this.nextByte <= 0) continue;
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
            }
        }
    }

    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            if (this.ctb != null) {
                String string = this.ctb.getCharacterEncoding();
                Object var3_4 = null;
                return string;
            }
            String string = null;
            Object var3_5 = null;
            return string;
        }
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    public void write(String string, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                Object var5_5 = null;
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            boolean bl = false;
            while (n3 < n4) {
                boolean bl2 = false;
                try {
                    this.nextByte += this.ctb.convertAny(cArray, n3, n4, this.bb, this.nextByte, this.nBytes);
                    n3 = n4;
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    int n5 = this.ctb.nextCharIndex();
                    if (n5 == n3 && bl) {
                        throw new CharConversionException("Output buffer too small");
                    }
                    n3 = n5;
                    bl2 = true;
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte < this.nBytes && !bl2) continue;
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
                bl = true;
            }
        }
    }
}

