/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.resources.LocaleData;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class NumberFormat
extends Format {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private static final Hashtable cachedLocaleData = new Hashtable(3);
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private static final int SCIENTIFICSTYLE = 3;
    private boolean groupingUsed = true;
    private byte maxIntegerDigits = (byte)40;
    private byte minIntegerDigits = 1;
    private byte maxFractionDigits = (byte)3;
    private byte minFractionDigits = 0;
    private boolean parseIntegerOnly = false;
    private int maximumIntegerDigits = 40;
    private int minimumIntegerDigits = 1;
    private int maximumFractionDigits = 3;
    private int minimumFractionDigits = 0;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    static final long serialVersionUID = -2308460125733713944L;

    public Object clone() {
        NumberFormat numberFormat = (NumberFormat)super.clone();
        return numberFormat;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NumberFormat numberFormat = (NumberFormat)object;
        return this.maximumIntegerDigits == numberFormat.maximumIntegerDigits && this.minimumIntegerDigits == numberFormat.minimumIntegerDigits && this.maximumFractionDigits == numberFormat.maximumFractionDigits && this.minimumFractionDigits == numberFormat.minimumFractionDigits && this.groupingUsed == numberFormat.groupingUsed && this.parseIntegerOnly == numberFormat.parseIntegerOnly;
    }

    public final String format(double d) {
        return this.format(d, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public final String format(long l) {
        return this.format(l, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Long || object instanceof BigInteger && ((BigInteger)object).bitLength() < 64) {
            return this.format(((Number)object).longValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(((Number)object).doubleValue(), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public static Locale[] getAvailableLocales() {
        return LocaleData.getAvailableLocales("NumberPatterns");
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 1);
    }

    public static NumberFormat getCurrencyInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 1);
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 0);
    }

    public static NumberFormat getInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 0);
    }

    private static NumberFormat getInstance(Locale locale, int n) {
        String[] stringArray = (String[])cachedLocaleData.get(locale);
        if (stringArray == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            stringArray = resourceBundle.getStringArray("NumberPatterns");
            cachedLocaleData.put(locale, stringArray);
        }
        return new DecimalFormat(stringArray[n], new DecimalFormatSymbols(locale));
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 0);
    }

    public static NumberFormat getNumberInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 0);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 2);
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 2);
    }

    static final NumberFormat getScientificInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 3);
    }

    static NumberFormat getScientificInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 3);
    }

    public int hashCode() {
        return this.maximumIntegerDigits * 37 + this.maxFractionDigits;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public Number parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.parse(string, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("Unparseable number: \"" + string + "\"", parsePosition.errorIndex);
        }
        return number;
    }

    public abstract Number parse(String var1, ParsePosition var2);

    public final Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.maximumIntegerDigits = this.maxIntegerDigits;
            this.minimumIntegerDigits = this.minIntegerDigits;
            this.maximumFractionDigits = this.maxFractionDigits;
            this.minimumFractionDigits = this.minFractionDigits;
        }
        this.serialVersionOnStream = 1;
    }

    public void setGroupingUsed(boolean bl) {
        this.groupingUsed = bl;
    }

    public void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = Math.max(0, n);
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
        }
    }

    public void setMaximumIntegerDigits(int n) {
        this.maximumIntegerDigits = Math.max(0, n);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
        }
    }

    public void setMinimumFractionDigits(int n) {
        this.minimumFractionDigits = Math.max(0, n);
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
        }
    }

    public void setMinimumIntegerDigits(int n) {
        this.minimumIntegerDigits = Math.max(0, n);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
        }
    }

    public void setParseIntegerOnly(boolean bl) {
        this.parseIntegerOnly = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.maxIntegerDigits = (byte)(this.maximumIntegerDigits > 127 ? 127 : (byte)this.maximumIntegerDigits);
        this.minIntegerDigits = (byte)(this.minimumIntegerDigits > 127 ? 127 : (byte)this.minimumIntegerDigits);
        this.maxFractionDigits = (byte)(this.maximumFractionDigits > 127 ? 127 : (byte)this.maximumFractionDigits);
        this.minFractionDigits = (byte)(this.minimumFractionDigits > 127 ? 127 : (byte)this.minimumFractionDigits);
        objectOutputStream.defaultWriteObject();
    }
}

