/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import sun.awt.windows.WPathGraphics;
import sun.java2d.PeekGraphics;
import sun.java2d.PeekMetrics;
import sun.java2d.RasterPrinterJob;
import sun.security.action.LoadLibraryAction;

public class WPrinterJob
extends RasterPrinterJob {
    protected static final int POLYFILL_ALTERNATE = 1;
    protected static final int POLYFILL_WINDING = 2;
    private static final int MAX_WCOLOR = 255;
    private int mPrintDC;
    private int mPrintXRes;
    private int mPrintYRes;
    private Color mLastColor;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }

    protected void beginPath() {
        this.beginPath(this.mPrintDC);
    }

    protected native void beginPath(int var1);

    protected void closeFigure() {
        this.closeFigure(this.mPrintDC);
    }

    protected native void closeFigure(int var1);

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob) {
        WPathGraphics wPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing() || peekMetrics.hasImages()) {
            wPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            wPathGraphics = new WPathGraphics(graphics2D, printerJob);
        }
        return wPathGraphics;
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        return pageFormat;
    }

    protected native void deleteDC();

    protected native void endDoc();

    protected native void endPage(PageFormat var1, Printable var2, int var3);

    protected void endPath() {
        this.endPath(this.mPrintDC);
    }

    protected native void endPath(int var1);

    protected void fillPath() {
        this.fillPath(this.mPrintDC);
    }

    protected native void fillPath(int var1);

    protected void finalize() {
        this.deleteDC();
    }

    protected int getNoncollatedCopies() {
        return 1;
    }

    protected int getPenX() {
        return this.getPenX(this.mPrintDC);
    }

    protected native int getPenX(int var1);

    protected int getPenY() {
        return this.getPenY(this.mPrintDC);
    }

    protected native int getPenY(int var1);

    protected int getPrintDC() {
        return this.mPrintDC;
    }

    protected double getXRes() {
        return this.mPrintXRes;
    }

    protected double getYRes() {
        return this.mPrintYRes;
    }

    private native boolean jobSetup(Pageable var1);

    protected void lineTo(float f, float f2) {
        this.lineTo(this.mPrintDC, f, f2);
    }

    protected native void lineTo(int var1, float var2, float var3);

    protected void moveTo(float f, float f2) {
        this.moveTo(this.mPrintDC, f, f2);
    }

    protected native void moveTo(int var1, float var2, float var3);

    public PageFormat pageDialog(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        boolean bl = WPrinterJob.pageSetup(pageFormat2, null);
        return bl ? pageFormat2 : pageFormat;
    }

    public static native boolean pageSetup(PageFormat var0, Printable var1);

    protected void polyBezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.polyBezierTo(this.mPrintDC, f, f2, f3, f4, f5, f6);
    }

    protected native void polyBezierTo(int var1, float var2, float var3, float var4, float var5, float var6, float var7);

    protected native void printBand(int[] var1, int var2, int var3, int var4, int var5);

    public boolean printDialog() {
        return this.jobSetup(this.getPageable());
    }

    protected void selectClipPath() {
        this.selectClipPath(this.mPrintDC);
    }

    protected native void selectClipPath(int var1);

    protected native void selectSolidBrush(int var1, int var2, int var3, int var4);

    protected void selectSolidBrush(Color color) {
        if (!color.equals(this.mLastColor)) {
            this.mLastColor = color;
            float[] fArray = color.getColorComponents(null);
            this.selectSolidBrush(this.mPrintDC, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    protected void setPolyFillMode(int n) {
        this.setPolyFillMode(this.mPrintDC, n);
    }

    protected native void setPolyFillMode(int var1, int var2);

    protected native void startDoc();

    protected native void startPage(PageFormat var1, Printable var2, int var3);

    public PageFormat validatePage(PageFormat pageFormat) {
        return pageFormat;
    }
}

