/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ComponentOrientation
implements Serializable {
    private static final int UNK_BIT = 1;
    private static final int HORIZ_BIT = 2;
    private static final int LTR_BIT = 4;
    public static final ComponentOrientation LEFT_TO_RIGHT = new ComponentOrientation(6);
    public static final ComponentOrientation RIGHT_TO_LEFT = new ComponentOrientation(2);
    public static final ComponentOrientation UNKNOWN = new ComponentOrientation(7);
    private int orientation;

    private ComponentOrientation(int n) {
        this.orientation = n;
    }

    public static ComponentOrientation getOrientation(Locale locale) {
        ComponentOrientation componentOrientation = UNKNOWN;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            componentOrientation = (ComponentOrientation)resourceBundle.getObject("Orientation");
        }
        catch (Exception exception) {}
        return componentOrientation;
    }

    public static ComponentOrientation getOrientation(ResourceBundle resourceBundle) {
        ComponentOrientation componentOrientation = null;
        try {
            componentOrientation = (ComponentOrientation)resourceBundle.getObject("Orientation");
        }
        catch (Exception exception) {}
        if (componentOrientation == null) {
            componentOrientation = ComponentOrientation.getOrientation(resourceBundle.getLocale());
        }
        if (componentOrientation == null) {
            componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        }
        return componentOrientation;
    }

    public boolean isHorizontal() {
        return (this.orientation & 2) != 0;
    }

    public boolean isLeftToRight() {
        return (this.orientation & 4) != 0;
    }
}

