/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Scrollbar
extends Component
implements Adjustable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int value;
    int maximum;
    int minimum;
    int visibleAmount;
    int orientation;
    int lineIncrement = 1;
    int pageIncrement = 10;
    transient AdjustmentListener adjustmentListener;
    private static final String base = "scrollbar";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 8451667562882310543L;
    private int scrollbarSerializedDataVersion = 1;

    static {
        Toolkit.loadLibraries();
        Scrollbar.initIDs();
    }

    public Scrollbar() {
        this(1, 0, 10, 0, 100);
    }

    public Scrollbar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public Scrollbar(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: 
            case 1: {
                this.orientation = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar orientation");
            }
        }
        this.setValues(n2, n3, n4, n5);
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
        this.newEventsOnly = true;
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createScrollbar(this);
            }
            super.addNotify();
        }
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 601) {
            return (this.eventMask & 0x100L) != 0L || this.adjustmentListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public int getBlockIncrement() {
        return this.getPageIncrement();
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public int getUnitIncrement() {
        return this.getLineIncrement();
    }

    public int getValue() {
        return this.value;
    }

    public int getVisible() {
        return this.visibleAmount;
    }

    public int getVisibleAmount() {
        return this.getVisible();
    }

    private static native void initIDs();

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",val=" + this.value + ",vis=" + this.visibleAmount + ",min=" + this.minimum + ",max=" + this.maximum + (this.orientation == 1 ? ",vert" : ",horz");
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "adjustmentL") {
                this.addAdjustmentListener((AdjustmentListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public void setBlockIncrement(int n) {
        this.setPageIncrement(n);
    }

    public synchronized void setLineIncrement(int n) {
        this.lineIncrement = n;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
        if (scrollbarPeer != null) {
            scrollbarPeer.setLineIncrement(n);
        }
    }

    public void setMaximum(int n) {
        this.setValues(this.value, this.visibleAmount, this.minimum, n);
    }

    public void setMinimum(int n) {
        this.setValues(this.value, this.visibleAmount, n, this.maximum);
    }

    public void setOrientation(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n == this.orientation) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.orientation = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal scrollbar orientation");
                }
            }
            if (this.peer != null) {
                this.removeNotify();
                this.addNotify();
                this.invalidate();
            }
        }
    }

    public synchronized void setPageIncrement(int n) {
        this.pageIncrement = n;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
        if (scrollbarPeer != null) {
            scrollbarPeer.setPageIncrement(n);
        }
    }

    public void setUnitIncrement(int n) {
        this.setLineIncrement(n);
    }

    public void setValue(int n) {
        this.setValues(n, this.visibleAmount, this.minimum, this.maximum);
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        if (n4 <= n3) {
            n4 = n3 + 1;
        }
        if (n2 > n4 - n3) {
            n2 = n4 - n3;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4 - n2) {
            n = n4 - n2;
        }
        this.value = n;
        this.visibleAmount = n2;
        this.minimum = n3;
        this.maximum = n4;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
        if (scrollbarPeer != null) {
            scrollbarPeer.setValues(n, this.visibleAmount, n3, n4);
        }
    }

    public void setVisibleAmount(int n) {
        this.setValues(this.value, n, this.minimum, this.maximum);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "adjustmentL", this.adjustmentListener);
        objectOutputStream.writeObject(null);
    }
}

