/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextLine;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import sun.awt.font.Bidi;
import sun.awt.font.TextLabelFactory;
import sun.awt.font.TextLineComponent;

class TextMeasurer {
    private FontRenderContext fFrc;
    private int fStart;
    private char[] fChars;
    private Bidi fBidi;
    private byte[] fLevels;
    private TextLineComponent[] fComponents;
    private boolean fIsDirectionLTR;
    private byte fBaseline;
    private float[] fBaselineOffsets;
    private float fJustifyRatio = 1.0f;

    public TextMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this.fFrc = fontRenderContext;
        this.initSelf(attributedCharacterIterator);
    }

    private int calcLineBreak(int n, float f) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fComponents.length) {
            int n4 = n2 + this.fComponents[n3].getNumCharacters();
            if (n4 > n) break;
            n2 = n4;
            ++n3;
        }
        while (n3 < this.fComponents.length) {
            TextLineComponent textLineComponent = this.fComponents[n3];
            int n5 = textLineComponent.getNumCharacters();
            int n6 = textLineComponent.getLineBreakIndex(n - n2, f);
            if (n6 == n5) {
                f -= textLineComponent.getAdvanceBetween(n - n2, n6);
            } else {
                return n2 + n6;
            }
            n = n2 += n5;
            ++n3;
        }
        return this.fChars.length;
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.initSelf(attributedCharacterIterator);
    }

    public float getAdvanceBetween(int n, int n2) {
        TextLine textLine = this.makeTextLineOnRange(n - this.fStart, n2 - this.fStart);
        return textLine.getMetrics().advance;
    }

    public TextLayout getLayout(int n, int n2) {
        TextLine textLine = this.makeTextLineOnRange(n - this.fStart, n2 - this.fStart);
        return new TextLayout(textLine, this.fBaseline, this.fBaselineOffsets, this.fJustifyRatio);
    }

    public int getLineBreakIndex(int n, float f) {
        return this.calcLineBreak(n - this.fStart, f) + this.fStart;
    }

    private void initSelf(AttributedCharacterIterator attributedCharacterIterator) {
        Object object;
        int n;
        this.fStart = attributedCharacterIterator.getBeginIndex();
        this.fChars = new char[attributedCharacterIterator.getEndIndex() - this.fStart];
        int n2 = 0;
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            this.fChars[n2++] = c;
            c = attributedCharacterIterator.next();
        }
        TextLine.ACIFontSource aCIFontSource = new TextLine.ACIFontSource(attributedCharacterIterator);
        this.fIsDirectionLTR = true;
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = null;
        attributedCharacterIterator.first();
        Map map = attributedCharacterIterator.getAttributes();
        if (map != null) {
            Serializable serializable;
            try {
                serializable = (Boolean)map.get(TextAttribute.RUN_DIRECTION);
                if (serializable != null) {
                    bl2 = true;
                    this.fIsDirectionLTR = TextAttribute.RUN_DIRECTION_LTR.equals(serializable);
                    bl = this.fIsDirectionLTR ^ true;
                }
            }
            catch (ClassCastException classCastException) {}
            try {
                serializable = (Float)map.get(TextAttribute.JUSTIFICATION);
                if (serializable != null) {
                    this.fJustifyRatio = ((Float)serializable).floatValue();
                    if (this.fJustifyRatio < 0.0f) {
                        this.fJustifyRatio = 0.0f;
                    } else if (this.fJustifyRatio > 1.0f) {
                        this.fJustifyRatio = 1.0f;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
        }
        int n3 = attributedCharacterIterator.getBeginIndex();
        int n4 = attributedCharacterIterator.getEndIndex();
        int n5 = n3;
        byte by = 0;
        byte by2 = (byte)(bl2 && !this.fIsDirectionLTR ? 1 : 0);
        do {
            int n6;
            block30: {
                attributedCharacterIterator.setIndex(n5);
                map = attributedCharacterIterator.getAttributes();
                object = map.get(TextAttribute.BIDI_EMBEDDING);
                n = attributedCharacterIterator.getRunLimit(TextAttribute.BIDI_EMBEDDING);
                if (object != null) {
                    try {
                        n6 = (Integer)object;
                        if (n6 < -15 || n6 >= 16) break block30;
                        by = (byte)n6;
                        if (byArray == null) {
                            byArray = new byte[this.fChars.length];
                            bl = true;
                            if (!bl2) {
                                bl2 = true;
                                this.fIsDirectionLTR = Bidi.defaultIsLTR(this.fChars, 0, this.fChars.length);
                                by2 = (byte)(!this.fIsDirectionLTR ? 1 : 0);
                            }
                            if (!this.fIsDirectionLTR) {
                                int n7 = 0;
                                while (n7 < n5 - n3) {
                                    byArray[n7] = by2;
                                    ++n7;
                                }
                            }
                        }
                    }
                    catch (ClassCastException classCastException) {}
                } else if (byArray != null) {
                    by = by2;
                }
            }
            if (byArray == null || by == 0) continue;
            n6 = n5 - n3;
            while (n6 < n - n3) {
                byArray[n6] = by;
                ++n6;
            }
        } while ((n5 = n) < n4);
        if (!bl) {
            int n8 = 0;
            while (n8 < this.fChars.length) {
                if (Bidi.requiresBidi(this.fChars[n8])) {
                    bl = true;
                    break;
                }
                ++n8;
            }
        }
        if (bl) {
            if (!bl2) {
                this.fIsDirectionLTR = Bidi.defaultIsLTR(this.fChars, 0, this.fChars.length);
            }
            if (byArray == null) {
                byArray = Bidi.getEmbeddingArray(this.fChars, this.fIsDirectionLTR);
            }
            this.fBidi = new Bidi(this.fChars, byArray, this.fIsDirectionLTR);
        }
        object = new TextLabelFactory(this.fFrc, this.fChars, this.fBidi);
        int[] nArray = null;
        this.fLevels = null;
        if (this.fBidi != null) {
            nArray = this.fBidi.getLogicalToVisualMap();
            this.fLevels = this.fBidi.getLevels();
        }
        this.fComponents = TextLine.getComponents(aCIFontSource, this.fChars, 0, this.fChars.length, nArray, this.fLevels, (TextLabelFactory)object);
        Font font = ((TextLine.FontSource)aCIFontSource).fontAt(0);
        if (font == null) {
            font = ((TextLine.FontSource)aCIFontSource).getBestFontAt(0);
        }
        LineMetrics lineMetrics = font.getLineMetrics(this.fChars, 0, 1, this.fFrc);
        this.fBaselineOffsets = lineMetrics.getBaselineOffsets();
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.initSelf(attributedCharacterIterator);
    }

    private TextLineComponent[] makeComponentsOnRange(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.trailingCdWhitespaceStart(n, n2);
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.fComponents.length) {
            n4 = n6 + this.fComponents[n7].getNumCharacters();
            if (n4 > n) break;
            n6 = n4;
            ++n7;
        }
        boolean bl = false;
        int n8 = n6;
        int n9 = n7;
        boolean bl2 = true;
        while (bl2) {
            int n10 = n8 + this.fComponents[n9].getNumCharacters();
            if (n5 > Math.max(n8, n) && n5 < Math.min(n10, n2)) {
                bl = true;
            }
            if (n10 >= n2) {
                bl2 = false;
            } else {
                n8 = n10;
            }
            ++n9;
        }
        n4 = n9 - n7;
        if (bl) {
            ++n4;
        }
        TextLineComponent[] textLineComponentArray = new TextLineComponent[n4];
        int n11 = 0;
        int n12 = n;
        int n13 = n5;
        if (n13 == n) {
            n3 = this.fIsDirectionLTR ? 0 : 1;
            n13 = n2;
        } else {
            n3 = 2;
        }
        while (n12 < n2) {
            int n14 = this.fComponents[n7].getNumCharacters();
            int n15 = n6 + n14;
            int n16 = Math.max(n12, n6);
            int n17 = Math.min(n13, n15);
            textLineComponentArray[n11++] = this.fComponents[n7].getSubset(n16 - n6, n17 - n6, n3);
            if ((n12 += n17 - n16) == n13) {
                n13 = n2;
                int n18 = n3 = this.fIsDirectionLTR ? 0 : 1;
            }
            if (n12 != n15) continue;
            ++n7;
            n6 = n15;
        }
        return textLineComponentArray;
    }

    private TextLine makeTextLineOnRange(int n, int n2) {
        Object object;
        int[] nArray = null;
        byte[] byArray = null;
        if (this.fBidi != null) {
            object = this.fBidi.createLineBidi(n, n2);
            nArray = ((Bidi)object).getLogicalToVisualMap();
            byArray = ((Bidi)object).getLevels();
        }
        object = this.makeComponentsOnRange(n, n2);
        return new TextLine((TextLineComponent[])object, this.fBaselineOffsets, this.fChars, n, n2, nArray, byArray, this.fIsDirectionLTR);
    }

    private int trailingCdWhitespaceStart(int n, int n2) {
        int n3 = n2;
        if (this.fLevels != null) {
            byte by = (byte)(!this.fIsDirectionLTR ? 1 : 0);
            n3 = n2 - 1;
            while (n3 >= n) {
                if (this.fLevels[n3] % 2 == by || Bidi.getDirectionCode(this.fChars[n3]) != 9) {
                    ++n3;
                    break;
                }
                --n3;
            }
        }
        return n3;
    }
}

