/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class CompactCharArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private char[] values;
    private short[] indices;
    private int[] hashes;
    private boolean isCompact;

    public CompactCharArray() {
        this('\u0000');
    }

    public CompactCharArray(char c) {
        this.values = new char[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        int n = 0;
        while (n < 65536) {
            this.values[n] = c;
            ++n;
        }
        n = 0;
        while (n < 512) {
            this.indices[n] = (short)(n << 7);
            this.hashes[n] = 0;
            ++n;
        }
        this.isCompact = false;
    }

    public CompactCharArray(short[] sArray, char[] cArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n = 0;
        while (n < 512) {
            short s = sArray[n];
            if (s < 0 || s >= cArray.length + 128) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n;
        }
        this.indices = sArray;
        this.values = cArray;
        this.isCompact = true;
    }

    static final boolean arrayRegionMatches(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        int n6 = n;
        while (n6 < n4) {
            if (cArray[n6] != cArray2[n6 + n5]) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public Object clone() {
        try {
            CompactCharArray compactCharArray = (CompactCharArray)super.clone();
            compactCharArray.values = (char[])this.values.clone();
            compactCharArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactCharArray.hashes = (int[])this.hashes.clone();
            }
            return compactCharArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = -1;
                n = this.blockTouched(n5) ? 1 : 0;
                if (n == 0 && n4 != -1) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && CompactCharArray.arrayRegionMatches(this.values, n3, this.values, n6, 128)) {
                            this.indices[n5] = (short)n6;
                        }
                        ++n7;
                        n6 += 128;
                    }
                    if (this.indices[n5] == -1) {
                        System.arraycopy(this.values, n3, this.values, n6, 128);
                        this.indices[n5] = (short)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (n == 0) {
                            n4 = (short)n6;
                        }
                    }
                }
                ++n5;
                n3 += 128;
            }
            n = n2 * 128;
            char[] cArray = new char[n];
            System.arraycopy(this.values, 0, cArray, 0, n);
            this.values = cArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    public char elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactCharArray compactCharArray = (CompactCharArray)object;
        int n = 0;
        while (n < 65536) {
            if (this.elementAt((char)n) != compactCharArray.elementAt((char)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void expand() {
        if (this.isCompact) {
            char[] cArray = new char[65536];
            this.hashes = new int[512];
            int n = 0;
            while (n < 65536) {
                char c;
                cArray[n] = c = this.elementAt((char)n);
                this.touchBlock(n >> 7, c);
                ++n;
            }
            n = 0;
            while (n < 512) {
                this.indices[n] = (short)(n << 7);
                ++n;
            }
            this.values = null;
            this.values = cArray;
            this.isCompact = false;
        }
    }

    private char getArrayValue(int n) {
        return this.values[n];
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    private short getIndexArrayValue(int n) {
        return this.indices[n];
    }

    public char[] getStringArray() {
        return this.values;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        int n3 = 0;
        while (n3 < this.values.length) {
            n = n * 37 + this.values[n3];
            n3 += n2;
        }
        return n;
    }

    public void setElementAt(char c, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = c2;
        this.touchBlock(c >> 7, c2);
    }

    public void setElementAt(char n, char c, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        int n2 = n;
        while (n2 <= c) {
            this.values[n2] = c2;
            this.touchBlock(n2 >> 7, c2);
            ++n2;
        }
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }
}

