/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.CompactIntArray;
import java.text.EntryPair;
import java.text.MergeCollation;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.PatternEntry;
import java.util.Vector;

public class RuleBasedCollator
extends Collator {
    static final long serialVersionUID = 2822366911447564107L;
    static final int CHARINDEX = 0x70000000;
    static final int EXPANDCHARINDEX = 0x7E000000;
    static final int CONTRACTCHARINDEX = 0x7F000000;
    static final int UNMAPPED = -1;
    private static final int PRIMARYORDERINCREMENT = 65536;
    private static final int MAXIGNORABLE = 65536;
    private static final int SECONDARYORDERINCREMENT = 256;
    private static final int TERTIARYORDERINCREMENT = 1;
    static final int PRIMARYORDERMASK = -65536;
    static final int SECONDARYORDERMASK = 65280;
    static final int TERTIARYORDERMASK = 255;
    static final int PRIMARYDIFFERENCEONLY = -65536;
    static final int SECONDARYDIFFERENCEONLY = -256;
    private static final int SECONDARYRESETMASK = 65535;
    private static final int IGNORABLEMASK = 65535;
    private static final int INITIALTABLESIZE = 20;
    private static final int MAXKEYSIZE = 5;
    static final int PRIMARYORDERSHIFT = 16;
    static final int SECONDARYORDERSHIFT = 8;
    private static final int MAXTOKENLEN = 256;
    private static final int COLLATIONKEYOFFSET = 1;
    private transient boolean isFrenchSec = false;
    private transient String ruleTable = null;
    private transient CompactIntArray mapping = null;
    private transient Vector contractTable = null;
    private transient Vector expandTable = null;
    private transient MergeCollation mPattern = null;
    private transient boolean isOverIgnore = false;
    private transient short maxSecOrder = 0;
    private transient short maxTerOrder = 0;
    private transient StringBuffer key = new StringBuffer(5);
    private transient int strengthResult = 3;
    private transient StringBuffer primResult = null;
    private transient StringBuffer secResult = null;
    private transient StringBuffer terResult = null;
    private transient CollationElementIterator sourceCursor = null;
    private transient CollationElementIterator targetCursor = null;

    public RuleBasedCollator(String string) throws ParseException {
        this.setStrength(2);
        this.build(string);
    }

    RuleBasedCollator(String string, int n) throws ParseException {
        this.setStrength(2);
        this.setDecomposition(n);
        this.build(string);
    }

    private void addComposedChars() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer(1);
        Normalizer.DecompIterator decompIterator = Normalizer.getDecompositions(1);
        while (decompIterator.hasNext()) {
            char c = decompIterator.next();
            if (this.getCharOrder(c) != -1) continue;
            String string = decompIterator.decomposition();
            int n = this.getContractOrder(string);
            if (n != -1) {
                this.addOrder(c, n);
                continue;
            }
            boolean bl = true;
            int n2 = 0;
            while (n2 < string.length()) {
                if (this.getCharOrder(string.charAt(n2)) == -1) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) continue;
            stringBuffer.setLength(0);
            stringBuffer.append(c);
            this.addExpandOrder(stringBuffer.toString(), string, -1);
        }
    }

    private final void addContractOrder(String string, int n) {
        this.addContractOrder(string, n, true);
    }

    private final void addContractOrder(String string, int n, boolean bl) {
        int n2;
        int n3;
        Vector vector;
        if (this.contractTable == null) {
            this.contractTable = new Vector(20);
        }
        if ((vector = this.getContractValues((n3 = this.mapping.elementAt(string.charAt(0))) - 0x7F000000)) == null) {
            n2 = 0x7F000000 + this.contractTable.size();
            vector = new Vector(20);
            this.contractTable.addElement(vector);
            vector.addElement(new EntryPair(string.substring(0, 1), n3));
            this.mapping.setElementAt(string.charAt(0), n2);
        }
        if ((n2 = RuleBasedCollator.getEntry(vector, string, bl)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n2);
            entryPair.value = n;
        } else {
            vector.addElement(new EntryPair(string, n, bl));
        }
        if (bl) {
            this.addContractOrder(new StringBuffer(string).reverse().toString(), n, false);
        }
    }

    private final void addExpandOrder(String string, String string2, int n) throws ParseException {
        int n2 = this.addExpansion(n, string2);
        if (string.length() > 1) {
            this.addContractOrder(string, n2);
        } else {
            this.addOrder(string.charAt(0), n2);
        }
    }

    private int addExpansion(int n, String string) {
        if (this.expandTable == null) {
            this.expandTable = new Vector(20);
        }
        int n2 = n == -1 ? 0 : 1;
        int[] nArray = new int[string.length() + n2];
        if (n2 == 1) {
            nArray[0] = n;
        }
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            int n4 = this.getCharOrder(c);
            nArray[n3 + n2] = n4 != -1 ? n4 : 0x70000000 + c;
            ++n3;
        }
        int n5 = 0x7E000000 + this.expandTable.size();
        this.expandTable.addElement(nArray);
        return n5;
    }

    private final void addOrder(char c, int n) {
        int n2 = this.mapping.elementAt(c);
        if (n2 >= 0x7F000000) {
            this.key.setLength(0);
            this.key.append(c);
            this.addContractOrder(this.key.toString(), n);
        } else {
            this.mapping.setElementAt(c, n);
        }
    }

    private void build(String string) throws ParseException {
        boolean bl = true;
        int n = 0;
        if (string.length() == 0) {
            throw new ParseException("Build rules empty.", 0);
        }
        this.mapping = new CompactIntArray(-1);
        string = Normalizer.decompose(string, this.getDecomposition());
        this.mPattern = new MergeCollation(string);
        int n2 = 0;
        n = 0;
        while (n < this.mPattern.getCount()) {
            PatternEntry patternEntry = this.mPattern.getItemAt(n);
            if (patternEntry != null) {
                String string2 = patternEntry.getChars();
                if (string2.length() > 1 && string2.charAt(string2.length() - 1) == '@') {
                    this.isFrenchSec = true;
                    string2 = string2.substring(0, string2.length() - 1);
                }
                n2 = this.increment(patternEntry.getStrength(), n2);
                String string3 = patternEntry.getExtension();
                if (string3.length() != 0) {
                    this.addExpandOrder(string2, string3, n2);
                } else if (string2.length() > 1) {
                    this.addContractOrder(string2, n2);
                } else {
                    char c = string2.charAt(0);
                    this.addOrder(c, n2);
                }
            }
            ++n;
        }
        this.addComposedChars();
        this.commit();
        this.mapping.compact();
    }

    public Object clone() {
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)super.clone();
        ruleBasedCollator.primResult = null;
        ruleBasedCollator.secResult = null;
        ruleBasedCollator.terResult = null;
        ruleBasedCollator.sourceCursor = null;
        ruleBasedCollator.targetCursor = null;
        ruleBasedCollator.key = new StringBuffer(5);
        return ruleBasedCollator;
    }

    private final void commit() {
        if (this.expandTable != null) {
            int n = 0;
            while (n < this.expandTable.size()) {
                int[] nArray = (int[])this.expandTable.elementAt(n);
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = nArray[n2];
                    if (n3 < 0x7E000000 && n3 > 0x70000000) {
                        char c = (char)(n3 - 0x70000000);
                        int n4 = this.getCharOrder(c);
                        nArray[n2] = n4 == -1 ? 0xFFFF & c : n4;
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public int compare(String string, String string2) {
        boolean bl;
        int n = 0;
        this.strengthResult = 3;
        if (this.sourceCursor == null) {
            this.sourceCursor = this.getCollationElementIterator(string);
        } else {
            this.sourceCursor.setText(string);
        }
        if (this.targetCursor == null) {
            this.targetCursor = this.getCollationElementIterator(string2);
        } else {
            this.targetCursor.setText(string2);
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = bl = this.getStrength() >= 1;
        boolean bl3 = this.getStrength() >= 2;
        boolean bl4 = true;
        boolean bl5 = true;
        while (true) {
            short s;
            short s2;
            short s3;
            if (bl4) {
                n2 = this.sourceCursor.next();
            } else {
                bl4 = true;
            }
            if (bl5) {
                n3 = this.targetCursor.next();
            } else {
                bl5 = true;
            }
            if (n2 == -1 || n3 == -1) break;
            int n4 = CollationElementIterator.primaryOrder(n2);
            int n5 = CollationElementIterator.primaryOrder(n3);
            if (n2 == n3) {
                if (!this.isFrenchSec || n4 == 0 || bl2) continue;
                bl2 = bl;
                bl3 = false;
                continue;
            }
            if (n4 != n5) {
                if (n2 == 0) {
                    bl5 = false;
                    continue;
                }
                if (n3 == 0) {
                    bl4 = false;
                    continue;
                }
                if (n4 == 0) {
                    if (bl2) {
                        n = 1;
                        bl2 = false;
                    }
                    bl5 = false;
                    continue;
                }
                if (n5 == 0) {
                    if (bl2) {
                        n = -1;
                        bl2 = false;
                    }
                    bl4 = false;
                    continue;
                }
                if (n4 < n5) {
                    return -1;
                }
                return 1;
            }
            if (!bl2) continue;
            short s4 = CollationElementIterator.secondaryOrder(n2);
            if (s4 != (s3 = CollationElementIterator.secondaryOrder(n3))) {
                n = s4 < s3 ? -1 : 1;
                bl2 = false;
                continue;
            }
            if (!bl3 || (s2 = CollationElementIterator.tertiaryOrder(n2)) == (s = CollationElementIterator.tertiaryOrder(n3))) continue;
            n = s2 < s ? -1 : 1;
            bl3 = false;
        }
        if (n2 != -1) {
            do {
                if (CollationElementIterator.primaryOrder(n2) != 0) {
                    return 1;
                }
                if (CollationElementIterator.secondaryOrder(n2) == 0 || !bl2) continue;
                n = 1;
                bl2 = false;
            } while ((n2 = this.sourceCursor.next()) != -1);
        } else if (n3 != -1) {
            do {
                if (CollationElementIterator.primaryOrder(n3) != 0) {
                    return -1;
                }
                if (CollationElementIterator.secondaryOrder(n3) == 0 || !bl2) continue;
                n = -1;
                bl2 = false;
            } while ((n3 = this.targetCursor.next()) != -1);
        }
        if (n == 0 && this.getStrength() == 3) {
            n = Normalizer.decompose(string, this.getDecomposition()).compareTo(Normalizer.decompose(string2, this.getDecomposition()));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)object;
        return this.getRules().equals(ruleBasedCollator.getRules());
    }

    private final int getCharOrder(char c) {
        int n = this.mapping.elementAt(c);
        if (n >= 0x7F000000) {
            Vector vector = this.getContractValues(n - 0x7F000000);
            EntryPair entryPair = (EntryPair)vector.firstElement();
            n = entryPair.value;
        }
        return n;
    }

    public CollationElementIterator getCollationElementIterator(String string) {
        return new CollationElementIterator(string, this);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator characterIterator) {
        return new CollationElementIterator(characterIterator, this);
    }

    public CollationKey getCollationKey(String string) {
        if (string == null) {
            return null;
        }
        if (this.primResult == null) {
            this.primResult = new StringBuffer();
            this.secResult = new StringBuffer();
            this.terResult = new StringBuffer();
        } else {
            this.primResult.setLength(0);
            this.secResult.setLength(0);
            this.terResult.setLength(0);
        }
        int n = 0;
        boolean bl = this.getStrength() >= 1;
        boolean bl2 = this.getStrength() >= 2;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        if (this.sourceCursor == null) {
            this.sourceCursor = this.getCollationElementIterator(string);
        } else {
            this.sourceCursor.setText(string);
        }
        while ((n = this.sourceCursor.next()) != -1) {
            n2 = CollationElementIterator.secondaryOrder(n);
            n3 = CollationElementIterator.tertiaryOrder(n);
            if (!CollationElementIterator.isIgnorable(n)) {
                this.primResult.append((char)(CollationElementIterator.primaryOrder(n) + 1));
                if (bl) {
                    if (this.isFrenchSec && n4 < this.secResult.length()) {
                        this.reverse(this.secResult, n4, this.secResult.length());
                    }
                    this.secResult.append((char)(n2 + 1));
                    n4 = this.secResult.length();
                }
                if (!bl2) continue;
                this.terResult.append((char)(n3 + 1));
                continue;
            }
            if (bl && n2 != 0) {
                this.secResult.append((char)(n2 + this.maxSecOrder + 1));
            }
            if (!bl2 || n3 == 0) continue;
            this.terResult.append((char)(n3 + this.maxTerOrder + 1));
        }
        if (this.isFrenchSec) {
            if (n4 < this.secResult.length()) {
                this.reverse(this.secResult, n4, this.secResult.length());
            }
            this.reverse(this.secResult, 0, this.secResult.length());
        }
        this.primResult.append('\u0000');
        this.secResult.append('\u0000');
        this.secResult.append(this.terResult.toString());
        this.primResult.append(this.secResult.toString());
        if (this.getStrength() == 3) {
            this.primResult.append('\u0000');
            this.primResult.append(Normalizer.decompose(string, this.getDecomposition()));
        }
        return new CollationKey(string, this.primResult.toString());
    }

    private int getContractOrder(String string) {
        int n;
        Vector vector;
        int n2 = -1;
        if (this.contractTable != null && (vector = this.getContractValues(string.charAt(0))) != null && (n = RuleBasedCollator.getEntry(vector, string, true)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n);
            n2 = entryPair.value;
        }
        return n2;
    }

    Vector getContractValues(char c) {
        int n = this.mapping.elementAt(c);
        return this.getContractValues(n - 0x7F000000);
    }

    Vector getContractValues(int n) {
        if (n >= 0) {
            return (Vector)this.contractTable.elementAt(n);
        }
        return null;
    }

    static final int getEntry(Vector vector, String string, boolean bl) {
        int n = 0;
        while (n < vector.size()) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n);
            if (entryPair.fwd == bl && entryPair.entryName.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int[] getExpandValueList(int n) {
        return (int[])this.expandTable.elementAt(n - 0x7E000000);
    }

    int getMaxExpansion(int n) {
        int n2 = 1;
        if (this.expandTable != null) {
            int n3 = 0;
            while (n3 < this.expandTable.size()) {
                int[] nArray = (int[])this.expandTable.elementAt(n3);
                int n4 = nArray.length;
                if (n4 > n2 && nArray[n4 - 1] == n) {
                    n2 = n4;
                }
                ++n3;
            }
        }
        return n2;
    }

    public String getRules() {
        if (this.ruleTable == null) {
            this.ruleTable = this.mPattern.emitPattern();
            this.mPattern = null;
        }
        return this.ruleTable;
    }

    final int getUnicodeOrder(char c) {
        return this.mapping.elementAt(c);
    }

    public int hashCode() {
        return this.getRules().hashCode();
    }

    private final int increment(int n, int n2) {
        switch (n) {
            case 0: {
                n2 += 65536;
                n2 &= 0xFFFF0000;
                this.isOverIgnore = true;
                break;
            }
            case 1: {
                n2 += 256;
                n2 &= 0xFFFFFF00;
                if (this.isOverIgnore) break;
                this.maxSecOrder = (short)(this.maxSecOrder + 1);
                break;
            }
            case 2: {
                ++n2;
                if (this.isOverIgnore) break;
                this.maxTerOrder = (short)(this.maxTerOrder + 1);
                break;
            }
        }
        return n2;
    }

    private final void reverse(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 < n4) {
            char c = stringBuffer.charAt(n3);
            stringBuffer.setCharAt(n3, stringBuffer.charAt(n4));
            stringBuffer.setCharAt(n4, c);
            ++n3;
            --n4;
        }
    }
}

