/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BoxLayout;
import javax.swing.SwingUtilities;

public class Box
extends Container
implements Accessible {
    protected AccessibleContext accessibleContext = null;

    public Box(int n) {
        super.setLayout(new BoxLayout(this, n));
    }

    public static Component createGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public static Box createHorizontalBox() {
        return new Box(0);
    }

    public static Component createHorizontalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
    }

    public static Component createHorizontalStrut(int n) {
        return new Filler(new Dimension(n, 0), new Dimension(n, 0), new Dimension(n, Short.MAX_VALUE));
    }

    public static Component createRigidArea(Dimension dimension) {
        return new Filler(dimension, dimension, dimension);
    }

    public static Box createVerticalBox() {
        return new Box(1);
    }

    public static Component createVerticalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
    }

    public static Component createVerticalStrut(int n) {
        return new Filler(new Dimension(0, n), new Dimension(0, n), new Dimension(Short.MAX_VALUE, n));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleBox();
        }
        return this.accessibleContext;
    }

    public void setLayout(LayoutManager layoutManager) {
        throw new AWTError("Illegal request");
    }

    public static class Filler
    extends Component
    implements Accessible {
        private Dimension reqMin;
        private Dimension reqPref;
        private Dimension reqMax;
        protected AccessibleContext accessibleContext = null;

        public Filler(Dimension dimension, Dimension dimension2, Dimension dimension3) {
            this.reqMin = dimension;
            this.reqPref = dimension2;
            this.reqMax = dimension3;
        }

        public void changeShape(Dimension dimension, Dimension dimension2, Dimension dimension3) {
            this.reqMin = dimension;
            this.reqPref = dimension2;
            this.reqMax = dimension3;
            this.invalidate();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleBoxFiller();
            }
            return this.accessibleContext;
        }

        public Dimension getMaximumSize() {
            return this.reqMax;
        }

        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        public Dimension getPreferredSize() {
            return this.reqPref;
        }

        protected class AccessibleBoxFiller
        extends AccessibleContext
        implements Serializable,
        AccessibleComponent {
            protected AccessibleBoxFiller() {
            }

            public void addFocusListener(FocusListener focusListener) {
                Filler.this.addFocusListener(focusListener);
            }

            public boolean contains(Point point) {
                return Filler.this.contains(point);
            }

            public Accessible getAccessibleAt(Point point) {
                return SwingUtilities.getAccessibleAt(Filler.this, point);
            }

            public Accessible getAccessibleChild(int n) {
                return SwingUtilities.getAccessibleChild(Filler.this, n);
            }

            public int getAccessibleChildrenCount() {
                return SwingUtilities.getAccessibleChildrenCount(Filler.this);
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public int getAccessibleIndexInParent() {
                return SwingUtilities.getAccessibleIndexInParent(Filler.this);
            }

            public Accessible getAccessibleParent() {
                if (this.accessibleParent != null) {
                    return this.accessibleParent;
                }
                Container container = Filler.this.getParent();
                if (container instanceof Accessible) {
                    return (Accessible)((Object)container);
                }
                return null;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.FILLER;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return SwingUtilities.getAccessibleStateSet(Filler.this);
            }

            public Color getBackground() {
                return Filler.this.getBackground();
            }

            public Rectangle getBounds() {
                return Filler.this.getBounds();
            }

            public Cursor getCursor() {
                return Filler.this.getCursor();
            }

            public Font getFont() {
                return Filler.this.getFont();
            }

            public FontMetrics getFontMetrics(Font font) {
                return Filler.this.getFontMetrics(font);
            }

            public Color getForeground() {
                return Filler.this.getForeground();
            }

            public Locale getLocale() {
                return Filler.this.getLocale();
            }

            public Point getLocation() {
                return Filler.this.getLocation();
            }

            public Point getLocationOnScreen() {
                if (Filler.this.isShowing()) {
                    return Filler.this.getLocationOnScreen();
                }
                return null;
            }

            public Dimension getSize() {
                return Filler.this.getSize();
            }

            public boolean isEnabled() {
                return Filler.this.isEnabled();
            }

            public boolean isFocusTraversable() {
                return Filler.this.isFocusTraversable();
            }

            public boolean isShowing() {
                return Filler.this.isShowing();
            }

            public boolean isVisible() {
                return Filler.this.isVisible();
            }

            public void removeFocusListener(FocusListener focusListener) {
                Filler.this.removeFocusListener(focusListener);
            }

            public void requestFocus() {
                Filler.this.requestFocus();
            }

            public void setBackground(Color color) {
                Filler.this.setBackground(color);
            }

            public void setBounds(Rectangle rectangle) {
                Filler.this.setBounds(rectangle);
            }

            public void setCursor(Cursor cursor) {
                Filler.this.setCursor(cursor);
            }

            public void setEnabled(boolean bl) {
                boolean bl2 = Filler.this.isEnabled();
                Filler.this.setEnabled(bl);
                if (bl != bl2 && Filler.this.accessibleContext != null) {
                    if (bl) {
                        Filler.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
                    } else {
                        Filler.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
                    }
                }
            }

            public void setFont(Font font) {
                Filler.this.setFont(font);
            }

            public void setForeground(Color color) {
                Filler.this.setForeground(color);
            }

            public void setLocation(Point point) {
                Filler.this.setLocation(point);
            }

            public void setSize(Dimension dimension) {
                Filler.this.setSize(dimension);
            }

            public void setVisible(boolean bl) {
                boolean bl2 = Filler.this.isVisible();
                Filler.this.setVisible(bl);
                if (bl != bl2 && Filler.this.accessibleContext != null) {
                    if (bl) {
                        Filler.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                    } else {
                        Filler.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                    }
                }
            }
        }
    }

    protected class AccessibleBox
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected AccessibleBox() {
        }

        public void addFocusListener(FocusListener focusListener) {
            Box.this.addFocusListener(focusListener);
        }

        public boolean contains(Point point) {
            return Box.this.contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(Box.this, point);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(Box.this, n);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(Box.this);
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(Box.this);
        }

        public Accessible getAccessibleParent() {
            Container container = Box.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILLER;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return SwingUtilities.getAccessibleStateSet(Box.this);
        }

        public Color getBackground() {
            return Box.this.getBackground();
        }

        public Rectangle getBounds() {
            return Box.this.getBounds();
        }

        public Cursor getCursor() {
            return Box.this.getCursor();
        }

        public Font getFont() {
            return Box.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return Box.this.getFontMetrics(font);
        }

        public Color getForeground() {
            return Box.this.getForeground();
        }

        public Locale getLocale() {
            return Box.this.getLocale();
        }

        public Point getLocation() {
            return Box.this.getLocation();
        }

        public Point getLocationOnScreen() {
            return Box.this.getLocationOnScreen();
        }

        public Dimension getSize() {
            return Box.this.getSize();
        }

        public boolean isEnabled() {
            return Box.this.isEnabled();
        }

        public boolean isFocusTraversable() {
            return Box.this.isFocusTraversable();
        }

        public boolean isShowing() {
            return Box.this.isShowing();
        }

        public boolean isVisible() {
            return Box.this.isVisible();
        }

        public void removeFocusListener(FocusListener focusListener) {
            Box.this.removeFocusListener(focusListener);
        }

        public void requestFocus() {
            Box.this.requestFocus();
        }

        public void setBackground(Color color) {
            Box.this.setBackground(color);
        }

        public void setBounds(Rectangle rectangle) {
            Box.this.setBounds(rectangle);
        }

        public void setCursor(Cursor cursor) {
            Box.this.setCursor(cursor);
        }

        public void setEnabled(boolean bl) {
            Box.this.setEnabled(bl);
        }

        public void setFont(Font font) {
            Box.this.setFont(font);
        }

        public void setForeground(Color color) {
            Box.this.setForeground(color);
        }

        public void setLocation(Point point) {
            Box.this.setLocation(point);
        }

        public void setSize(Dimension dimension) {
            Box.this.setSize(dimension);
        }

        public void setVisible(boolean bl) {
            Box.this.setVisible(bl);
        }
    }
}

