/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.Image;
import sun.awt.image.ImageWatched;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.NativeLibLoader;

public class ImageRepresentation
extends ImageWatched
implements ImageConsumer {
    InputStreamImageSource src;
    Image image;
    int tag;
    long pData;
    int width = -1;
    int height = -1;
    int hints;
    int availinfo;
    Rectangle newbits;
    BufferedImage bimage;
    WritableRaster biRaster;
    ColorModel cmodel;
    ColorModel srcModel = null;
    int[] srcLUT = null;
    int srcLUTtransIndex = -1;
    int numSrcLUT = 0;
    boolean forceCMhint;
    int sstride;
    boolean isDefaultBI = false;
    boolean isSameCM = false;
    static boolean s_useNative;
    private boolean consuming = false;
    private int numWaiters;

    static {
        NativeLibLoader.loadLibraries();
        ImageRepresentation.initIDs();
        s_useNative = true;
    }

    public ImageRepresentation(Image image, ColorModel colorModel, boolean bl) {
        this.image = image;
        if (this.image.getSource() instanceof InputStreamImageSource) {
            this.src = (InputStreamImageSource)this.image.getSource();
        }
        this.setColorModel(colorModel);
        this.forceCMhint = bl;
    }

    synchronized void abort() {
        this.image.getSource().removeConsumer(this);
        this.consuming = false;
        this.newbits = null;
        this.bimage = null;
        this.biRaster = null;
        this.cmodel = null;
        this.srcLUT = null;
        this.isDefaultBI = false;
        this.isSameCM = false;
        this.newInfo(this.image, 128, -1, -1, -1, -1);
        this.availinfo &= 0xFFFFFF87;
    }

    public int check(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x60) == 0) {
            this.addWatcher(imageObserver);
        }
        return this.availinfo;
    }

    private synchronized void checkConsumption() {
        if (this.watchers == null && this.numWaiters == 0 && (this.availinfo & 0x20) == 0) {
            this.dispose();
        }
    }

    private void convertToRGB() {
        Object[] objectArray;
        Object object;
        int n = this.bimage.getWidth();
        int n2 = this.bimage.getHeight();
        int n3 = n * n2;
        int[] nArray = new int[n3];
        if (this.cmodel instanceof IndexColorModel && this.biRaster instanceof ByteComponentRaster && this.biRaster.getNumDataElements() == 1) {
            object = (ByteComponentRaster)this.biRaster;
            objectArray = ((ByteComponentRaster)object).getDataStorage();
            int n4 = ((ByteComponentRaster)object).getDataOffset(0);
            int n5 = 0;
            while (n5 < n3) {
                nArray[n5] = this.srcLUT[objectArray[n4 + n5] & 0xFF];
                ++n5;
            }
        } else {
            object = null;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                int n8 = 0;
                while (n8 < n) {
                    object = this.biRaster.getDataElements(n8, n7, object);
                    nArray[n6++] = this.cmodel.getRGB(object);
                    ++n8;
                }
                ++n7;
            }
        }
        this.isSameCM = false;
        this.cmodel = ColorModel.getRGBdefault();
        object = new DataBufferInt(nArray, nArray.length);
        objectArray = new int[]{0xFF0000, 65280, 255, -16777216};
        this.biRaster = Raster.createPackedRaster((DataBuffer)object, n, n2, n, objectArray, null);
        this.bimage = new BufferedImage(this.cmodel, this.biRaster, this.cmodel.isAlphaPremultiplied(), null);
        this.srcLUT = null;
        this.isDefaultBI = true;
    }

    void createBufferedImage() {
        DirectColorModel directColorModel;
        this.isDefaultBI = false;
        try {
            this.biRaster = this.cmodel.createCompatibleWritableRaster(this.width, this.height);
            this.bimage = new BufferedImage(this.cmodel, this.biRaster, this.cmodel.isAlphaPremultiplied(), null);
        }
        catch (Exception exception) {
            this.cmodel = ColorModel.getRGBdefault();
            this.biRaster = this.cmodel.createCompatibleWritableRaster(this.width, this.height);
            this.bimage = new BufferedImage(this.cmodel, this.biRaster, false, null);
        }
        int n = this.bimage.getType();
        if (this.cmodel == ColorModel.getRGBdefault() || n == 1 || n == 3) {
            this.isDefaultBI = true;
        } else if (this.cmodel instanceof DirectColorModel && (directColorModel = (DirectColorModel)this.cmodel).getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255) {
            this.isDefaultBI = true;
        }
    }

    private synchronized void decrementWaiters() {
        --this.numWaiters;
        this.checkConsumption();
    }

    synchronized void dispose() {
        this.image.getSource().removeConsumer(this);
        this.consuming = false;
        this.newbits = null;
        this.availinfo &= 0xFFFFFFC7;
    }

    public boolean drawToBufImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = (this.availinfo & 0x20) != 0;
        boolean bl3 = bl = (this.availinfo & 0x80) != 0;
        if (!bl2 && !bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl4 = bl2 = (this.availinfo & 0x20) != 0;
        }
        if (bl2 || (this.availinfo & 0x10) != 0) {
            graphics.drawImage(this.bimage, n, n2, n3, n4, n5, n6, n7, n8, color, null);
        }
        return bl2;
    }

    public boolean drawToBufImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = (this.availinfo & 0x20) != 0;
        boolean bl3 = bl = (this.availinfo & 0x80) != 0;
        if (!bl2 && !bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl4 = bl2 = (this.availinfo & 0x20) != 0;
        }
        if (bl2 || (this.availinfo & 0x10) != 0) {
            graphics.drawImage(this.bimage, n, n2, n3, n4, color, null);
        }
        return bl2;
    }

    public boolean drawToBufImage(Graphics graphics, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = (this.availinfo & 0x20) != 0;
        boolean bl3 = bl = (this.availinfo & 0x80) != 0;
        if (!bl2 && !bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl4 = bl2 = (this.availinfo & 0x20) != 0;
        }
        if (bl2 || (this.availinfo & 0x10) != 0) {
            graphics.drawImage(this.bimage, n, n2, color, null);
        }
        return bl2;
    }

    public boolean drawToBufImage(Graphics graphics, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = (this.availinfo & 0x20) != 0;
        boolean bl3 = bl = (this.availinfo & 0x80) != 0;
        if (!bl2 && !bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl4 = bl2 = (this.availinfo & 0x20) != 0;
        }
        if (bl2 || (this.availinfo & 0x10) != 0) {
            graphics2D.drawImage(this.bimage, affineTransform, null);
        }
        return bl2;
    }

    BufferedImage getBufferedImage() {
        return this.bimage;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void imageComplete(int n) {
        int n2;
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        switch (n) {
            default: {
                bl = true;
                n2 = 128;
                break;
            }
            case 1: {
                this.image.addInfo(64);
                bl = true;
                n2 = 64;
                this.dispose();
                break;
            }
            case 3: {
                bl = true;
                n2 = 32;
                break;
            }
            case 2: {
                bl = false;
                n2 = 16;
            }
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (bl) {
                this.image.getSource().removeConsumer(this);
                this.consuming = false;
                this.newbits = null;
            }
            this.availinfo |= n2;
            this.notifyAll();
        }
        this.newInfo(this.image, n2, 0, 0, this.width, this.height);
        this.image.infoDone(n);
    }

    private static native void initIDs();

    public boolean prepare(ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = bl = (this.availinfo & 0x20) != 0;
        if (!bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            bl = (this.availinfo & 0x20) != 0;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void reconstruct(int n) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        int n2 = n & ~this.availinfo;
        if ((this.availinfo & 0x40) != 0) return;
        if (n2 == 0) return;
        ++this.numWaiters;
        try {
            this.startProduction();
            n2 = n & ~this.availinfo;
            while ((this.availinfo & 0x40) == 0 && n2 != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Object var4_3 = null;
                    this.decrementWaiters();
                    return;
                }
                n2 = n & ~this.availinfo;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.decrementWaiters();
            throw throwable;
        }
        Object var4_4 = null;
        this.decrementWaiters();
    }

    public synchronized void removeWatcher(ImageObserver imageObserver) {
        super.removeWatcher(imageObserver);
        this.checkConsumption();
    }

    public native void setBytePixels(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, ByteComponentRaster var8, int var9);

    public void setColorModel(ColorModel colorModel) {
        DirectColorModel directColorModel;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.srcModel = colorModel;
        if (colorModel instanceof IndexColorModel) {
            if (colorModel.getTransparency() == 3) {
                this.cmodel = ColorModel.getRGBdefault();
                this.srcLUT = null;
            } else {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                this.numSrcLUT = indexColorModel.getMapSize();
                this.srcLUT = new int[Math.max(this.numSrcLUT, 256)];
                indexColorModel.getRGBs(this.srcLUT);
                this.srcLUTtransIndex = indexColorModel.getTransparentPixel();
                this.cmodel = colorModel;
            }
        } else if (this.cmodel == null) {
            this.cmodel = colorModel;
            this.srcLUT = null;
        } else if (colorModel instanceof DirectColorModel && (directColorModel = (DirectColorModel)colorModel).getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255) {
            this.cmodel = colorModel;
            this.srcLUT = null;
        }
        boolean bl = this.isSameCM = this.cmodel == colorModel;
        if ((this.availinfo & 3) != 0) {
            this.createBufferedImage();
        }
    }

    public native int setDiffICM(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7, IndexColorModel var8, byte[] var9, int var10, int var11, ByteComponentRaster var12, int var13);

    public void setDimensions(int n, int n2) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.image.setDimensions(n, n2);
        this.newInfo(this.image, 3, 0, 0, n, n2);
        if (n <= 0 || n2 <= 0) {
            this.imageComplete(1);
            return;
        }
        this.width = n;
        this.height = n2;
        this.availinfo |= 3;
        if (this.bimage == null && this.cmodel != null) {
            this.createBufferedImage();
        }
    }

    public void setHints(int n) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.hints = n;
    }

    public native void setICMpixels(int var1, int var2, int var3, int var4, int[] var5, byte[] var6, int var7, int var8, IntegerComponentRaster var9);

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n5;
        Object var11_10 = null;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            int n8;
            Object object;
            Object object2;
            if (this.bimage == null) {
                if (this.cmodel == null) {
                    this.cmodel = colorModel;
                }
                this.createBufferedImage();
            } else if (this.isSameCM && this.cmodel != colorModel && this.srcLUT != null && colorModel instanceof IndexColorModel && this.biRaster instanceof ByteComponentRaster) {
                object2 = (IndexColorModel)colorModel;
                object = (ByteComponentRaster)this.biRaster;
                n8 = this.numSrcLUT;
                if (this.setDiffICM(n, n2, n3, n4, this.srcLUT, this.srcLUTtransIndex, this.numSrcLUT, (IndexColorModel)object2, byArray, n5, n6, (ByteComponentRaster)object, ((ByteComponentRaster)object).getDataOffset(0)) == 0) {
                    this.convertToRGB();
                } else {
                    if (n8 != this.numSrcLUT) {
                        int n9;
                        boolean bl = ((ColorModel)object2).hasAlpha();
                        if (this.srcLUTtransIndex != -1) {
                            bl = true;
                        }
                        this.cmodel = object2 = new IndexColorModel(n9, this.numSrcLUT, this.srcLUT, 0, bl, this.srcLUTtransIndex, (n9 = ((ColorModel)object2).getPixelSize()) > 8 ? 1 : 0);
                        this.bimage = new BufferedImage((ColorModel)object2, (WritableRaster)object, false, null);
                    }
                    Object var13_25 = null;
                    return;
                }
            }
            if (this.isDefaultBI) {
                object = (IntegerComponentRaster)this.biRaster;
                if (this.srcLUT != null && colorModel instanceof IndexColorModel) {
                    if (colorModel != this.srcModel) {
                        ((IndexColorModel)colorModel).getRGBs(this.srcLUT);
                        this.srcModel = colorModel;
                    }
                    if (s_useNative) {
                        this.setICMpixels(n, n2, n3, n4, this.srcLUT, byArray, n5, n6, (IntegerComponentRaster)object);
                    } else {
                        int[] nArray = new int[n3 * n4];
                        int n10 = 0;
                        int n11 = 0;
                        while (n11 < n4) {
                            int n12 = n7;
                            int n13 = 0;
                            while (n13 < n3) {
                                nArray[n10++] = this.srcLUT[byArray[n12++] & 0xFF];
                                ++n13;
                            }
                            ++n11;
                            n7 += n6;
                        }
                        ((IntegerComponentRaster)object).setDataElements(n, n2, n3, n4, nArray);
                    }
                } else {
                    int[] nArray = new int[n3];
                    int n14 = n2;
                    while (n14 < n2 + n4) {
                        int n15 = n7;
                        int n16 = 0;
                        while (n16 < n3) {
                            nArray[n16] = colorModel.getRGB(byArray[n15++] & 0xFF);
                            ++n16;
                        }
                        ((IntegerComponentRaster)object).setDataElements(n, n14, n3, 1, nArray);
                        ++n14;
                        n7 += n6;
                    }
                    this.availinfo |= 8;
                }
            } else if (this.cmodel == colorModel && this.biRaster instanceof ByteComponentRaster && this.biRaster.getNumDataElements() == 1) {
                object2 = (ByteComponentRaster)this.biRaster;
                if (n3 * n4 > 200) {
                    if (n6 == n3) {
                        ((ByteComponentRaster)object2).putByteData(n, n2, n3, n4, byArray);
                    } else {
                        object = new byte[n3];
                        int n17 = n5;
                        n8 = n2;
                        while (n8 < n2 + n4) {
                            System.arraycopy(byArray, n17, object, 0, n3);
                            ((ByteComponentRaster)object2).putByteData(n, n8, n3, 1, (byte[])object);
                            n17 += n6;
                            ++n8;
                        }
                    }
                } else {
                    this.setBytePixels(n, n2, n3, n4, byArray, n5, n6, (ByteComponentRaster)object2, ((ByteComponentRaster)object2).getDataOffset(0));
                }
            } else {
                int n18 = n2;
                while (n18 < n2 + n4) {
                    int n19 = n7;
                    int n20 = n;
                    while (n20 < n + n3) {
                        this.bimage.setRGB(n20, n18, colorModel.getRGB(byArray[n19++] & 0xFF));
                        ++n20;
                    }
                    ++n18;
                    n7 += n6;
                }
                this.availinfo |= 8;
            }
        }
        if ((this.availinfo & 0x10) == 0) {
            this.newInfo(this.image, 8, n, n2, n3, n4);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n5;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (this.bimage == null) {
                if (this.cmodel == null) {
                    this.cmodel = colorModel;
                }
                this.createBufferedImage();
            }
            int[] nArray2 = new int[n3];
            if (this.cmodel instanceof IndexColorModel) {
                this.convertToRGB();
            }
            if (colorModel == this.cmodel && this.biRaster instanceof IntegerComponentRaster) {
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)this.biRaster;
                if (n5 == 0 && n6 == n3) {
                    integerComponentRaster.setDataElements(n, n2, n3, n4, nArray);
                } else {
                    int n8 = n2;
                    while (n8 < n2 + n4) {
                        System.arraycopy(nArray, n7, nArray2, 0, n3);
                        integerComponentRaster.setDataElements(n, n8, n3, 1, nArray2);
                        ++n8;
                        n7 += n6;
                    }
                }
            } else {
                if (colorModel.getTransparency() != 1 && this.cmodel.getTransparency() == 1) {
                    this.convertToRGB();
                }
                if (this.isDefaultBI) {
                    IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)this.biRaster;
                    int[] nArray3 = integerComponentRaster.getDataStorage();
                    if (this.cmodel.equals(colorModel)) {
                        int n9 = integerComponentRaster.getScanlineStride();
                        int n10 = n2 * n9 + n;
                        int n11 = 0;
                        while (n11 < n4) {
                            System.arraycopy(nArray, n7, nArray3, n10, n3);
                            n10 += n9;
                            ++n11;
                            n7 += n6;
                        }
                    } else {
                        int n12 = n2;
                        while (n12 < n2 + n4) {
                            int n13 = n7;
                            int n14 = 0;
                            while (n14 < n3) {
                                nArray2[n14] = colorModel.getRGB(nArray[n13++]);
                                ++n14;
                            }
                            integerComponentRaster.setDataElements(n, n12, n3, 1, nArray2);
                            ++n12;
                            n7 += n6;
                        }
                    }
                    this.availinfo |= 8;
                } else {
                    Object object = null;
                    int n15 = n2;
                    while (n15 < n2 + n4) {
                        int n16 = n7;
                        int n17 = n;
                        while (n17 < n + n3) {
                            int n18 = colorModel.getRGB(nArray[n16]);
                            object = this.cmodel.getDataElements(n18, object);
                            this.biRaster.setDataElements(n17, n15, object);
                            ++n17;
                        }
                        ++n15;
                        n7 += n6;
                    }
                    this.availinfo |= 8;
                }
            }
        }
        if ((this.availinfo & 0x10) == 0) {
            this.newInfo(this.image, 8, n, n2, n3, n4);
        }
    }

    public void setProperties(Hashtable hashtable) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.image.setProperties(hashtable);
        this.newInfo(this.image, 4, 0, 0, 0, 0);
    }

    void startProduction() {
        if (!this.consuming) {
            this.consuming = true;
            this.image.getSource().startProduction(this);
        }
    }
}

