/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.TooManyListenersException;

public abstract class DragGestureRecognizer {
    protected DragSource dragSource;
    protected Component component;
    protected DragGestureListener dragGestureListener;
    protected int sourceActions;
    protected ArrayList events = new ArrayList(1);

    protected DragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (dragSource == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        this.dragSource = dragSource;
        this.component = component;
        this.sourceActions = n & 0x40000003;
        try {
            if (dragGestureListener != null) {
                this.addDragGestureListener(dragGestureListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {}
    }

    public synchronized void addDragGestureListener(DragGestureListener dragGestureListener) throws TooManyListenersException {
        if (this.dragGestureListener != null) {
            throw new TooManyListenersException();
        }
        this.dragGestureListener = dragGestureListener;
        if (this.component != null) {
            this.registerListeners();
        }
    }

    protected synchronized void appendEvent(InputEvent inputEvent) {
        this.events.add(inputEvent);
    }

    protected synchronized void fireDragGestureRecognized(int n, Point point) {
        if (this.dragGestureListener != null) {
            this.dragGestureListener.dragGestureRecognized(new DragGestureEvent(this, n, point, this.events));
        }
        this.events.clear();
    }

    public synchronized Component getComponent() {
        return this.component;
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public synchronized int getSourceActions() {
        return this.sourceActions;
    }

    public InputEvent getTriggerEvent() {
        return this.events.isEmpty() ? null : (InputEvent)this.events.get(0);
    }

    protected abstract void registerListeners();

    public synchronized void removeDragGestureListener(DragGestureListener dragGestureListener) {
        if (this.dragGestureListener == null || !this.dragGestureListener.equals(dragGestureListener)) {
            throw new IllegalArgumentException();
        }
        this.dragGestureListener = null;
        if (this.component != null) {
            this.unregisterListeners();
        }
    }

    public void resetRecognizer() {
        this.events.clear();
    }

    public synchronized void setComponent(Component component) {
        if (this.component != null && this.dragGestureListener != null) {
            this.unregisterListeners();
        }
        this.component = component;
        if (this.component != null && this.dragGestureListener != null) {
            this.registerListeners();
        }
    }

    public synchronized void setSourceActions(int n) {
        this.sourceActions = n & 0x40000003;
    }

    protected abstract void unregisterListeners();
}

