/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.util.TooManyListenersException;
import javax.swing.Timer;

public class DropTarget
implements DropTargetListener,
Serializable {
    static final long serialVersionUID = -6283860791671019047L;
    private static final FlavorMap defaultFlavorMap = SystemFlavorMap.getDefaultFlavorMap();
    private transient DropTargetContext dropTargetContext;
    private Component component;
    private transient ComponentPeer componentPeer;
    private transient ComponentPeer nativePeer;
    int actions = 3;
    boolean active = true;
    private transient DropTargetAutoScroller autoScroller;
    private DropTargetListener dtListener;
    private transient FlavorMap flavorMap = defaultFlavorMap;

    public DropTarget() {
        this(null, 3, null, true, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener) {
        this(component, n, dropTargetListener, true);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl) {
        this(component, n, dropTargetListener, bl, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl, FlavorMap flavorMap) {
        this.component = component;
        this.setDefaultActions(n);
        if (dropTargetListener != null) {
            try {
                this.addDropTargetListener(dropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {}
        }
        if (component != null) {
            component.setDropTarget(this);
            this.setActive(bl);
        }
        if (flavorMap != null) {
            this.flavorMap = flavorMap;
        }
    }

    public DropTarget(Component component, DropTargetListener dropTargetListener) {
        this(component, 3, dropTargetListener, true, null);
    }

    public synchronized void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (dropTargetListener == null) {
            return;
        }
        if (this.equals(dropTargetListener)) {
            throw new IllegalArgumentException("DropTarget may not be its own Listener");
        }
        if (this.dtListener != null) {
            throw new TooManyListenersException();
        }
        this.dtListener = dropTargetListener;
    }

    public void addNotify(ComponentPeer componentPeer) {
        if (componentPeer == this.componentPeer) {
            return;
        }
        this.componentPeer = componentPeer;
        Component component = this.component;
        while (componentPeer instanceof LightweightPeer) {
            componentPeer = component.getPeer();
            component = component.getParent();
        }
        try {
            this.nativePeer = componentPeer;
            ((DropTargetPeer)((Object)this.nativePeer)).addDropTarget(this);
        }
        catch (ClassCastException classCastException) {
            this.nativePeer = null;
        }
    }

    protected void clearAutoscroll() {
        if (this.autoScroller != null) {
            this.autoScroller.stop();
            this.autoScroller = null;
        }
    }

    protected DropTargetAutoScroller createDropTargetAutoScroller(Component component, Point point) {
        return new DropTargetAutoScroller(component, point);
    }

    protected DropTargetContext createDropTargetContext() {
        return new DropTargetContext(this);
    }

    public synchronized void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null) {
            this.dtListener.dragEnter(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.getDropTargetContext().setTargetActions(0);
        }
        this.initializeAutoscrolling(dropTargetDragEvent.getLocation());
    }

    public synchronized void dragExit(DropTargetEvent dropTargetEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null && this.active) {
            this.dtListener.dragExit(dropTargetEvent);
        }
        this.clearAutoscroll();
    }

    public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null && this.active) {
            this.dtListener.dragOver(dropTargetDragEvent);
        }
        this.updateAutoscroll(dropTargetDragEvent.getLocation());
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.dtListener != null && this.active) {
            this.dtListener.drop(dropTargetDropEvent);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null) {
            this.dtListener.dropActionChanged(dropTargetDragEvent);
        }
        this.updateAutoscroll(dropTargetDragEvent.getLocation());
    }

    public synchronized Component getComponent() {
        return this.component;
    }

    public synchronized int getDefaultActions() {
        return this.actions;
    }

    public DropTargetContext getDropTargetContext() {
        if (this.dropTargetContext == null) {
            this.dropTargetContext = this.createDropTargetContext();
        }
        return this.dropTargetContext;
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    protected void initializeAutoscrolling(Point point) {
        if (this.component == null || !(this.component instanceof Autoscroll)) {
            return;
        }
        this.autoScroller = this.createDropTargetAutoScroller(this.component, point);
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener != null && this.dtListener != null) {
            if (this.dtListener.equals(dropTargetListener)) {
                this.dtListener = null;
            } else {
                throw new IllegalArgumentException("listener mismatch");
            }
        }
    }

    public void removeNotify(ComponentPeer componentPeer) {
        if (this.nativePeer != null) {
            ((DropTargetPeer)((Object)this.nativePeer)).removeDropTarget(this);
        }
        this.nativePeer = null;
        this.componentPeer = null;
    }

    public synchronized void setActive(boolean bl) {
        if (bl != this.active) {
            this.active = bl;
        }
        if (!this.active) {
            this.clearAutoscroll();
        }
    }

    public synchronized void setComponent(Component component) {
        block5: {
            if (this.component == component || this.component != null && this.component.equals(component)) {
                return;
            }
            ComponentPeer componentPeer = null;
            Component component2 = this.component;
            if (component2 != null) {
                this.clearAutoscroll();
                this.component = null;
                if (this.componentPeer != null) {
                    componentPeer = this.componentPeer;
                    this.removeNotify(this.componentPeer);
                }
                component2.setDropTarget(null);
            }
            if ((this.component = component) == null) break block5;
            try {
                component.setDropTarget(this);
            }
            catch (Exception exception) {
                if (component2 == null) break block5;
                component2.setDropTarget(this);
                this.addNotify(componentPeer);
            }
        }
    }

    public synchronized void setDefaultActions(int n) {
        this.actions = n & 0x40000003;
        if (this.dropTargetContext != null) {
            this.dropTargetContext.setTargetActions(this.actions);
        }
    }

    public void setFlavorMap(FlavorMap flavorMap) {
        this.flavorMap = flavorMap == null ? defaultFlavorMap : flavorMap;
    }

    protected void updateAutoscroll(Point point) {
        if (this.autoScroller != null) {
            this.autoScroller.updateLocation(point);
        }
    }

    protected static class DropTargetAutoScroller
    implements ActionListener {
        private Component component;
        private Autoscroll autoScroll;
        private Timer timer;
        private Point locn;
        private Point prev;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;

        protected DropTargetAutoScroller(Component component, Point point) {
            this.component = component;
            this.autoScroll = (Autoscroll)((Object)this.component);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Integer n = new Integer(100);
            Integer n2 = new Integer(100);
            try {
                n = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {}
            try {
                n2 = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {}
            this.timer = new Timer(n2, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(n);
            this.locn = point;
            this.prev = point;
            try {
                this.hysteresis = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {}
            this.timer.start();
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            this.updateRegion();
            if (this.outer.contains(this.locn) && !this.inner.contains(this.locn)) {
                this.autoScroll.autoscroll(this.locn);
            }
        }

        protected void stop() {
            this.timer.stop();
        }

        protected synchronized void updateLocation(Point point) {
            this.prev = this.locn;
            this.locn = point;
            if (Math.abs(this.locn.x - this.prev.x) > this.hysteresis || Math.abs(this.locn.y - this.prev.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }

        private void updateRegion() {
            Insets insets = this.autoScroll.getAutoscrollInsets();
            Dimension dimension = this.component.getSize();
            if (dimension.width != this.outer.width || dimension.height != this.outer.height) {
                this.outer.reshape(0, 0, dimension.width, dimension.height);
            }
            if (this.inner.x != insets.left || this.inner.y != insets.top) {
                this.inner.setLocation(insets.left, insets.top);
            }
            int n = dimension.width - (insets.left + insets.right);
            int n2 = dimension.height - (insets.top + insets.bottom);
            if (n != this.inner.width || n2 != this.inner.height) {
                this.inner.setSize(n, n2);
            }
        }
    }
}

