/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;

public class ObjectStreamClass
implements Serializable {
    private static ObjectStreamClassEntry[] descriptorFor = new ObjectStreamClassEntry[61];
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    private long suid;
    int primBytes;
    int objFields;
    private boolean hasWriteObjectMethod;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    Method readResolveMethod;
    Method writeReplaceMethod;
    private ObjectStreamClass localClassDesc;
    private boolean disableInstanceDeserialization = false;
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private static Comparator compareClassByName = new CompareClassByName();
    private static Comparator compareMemberByName = new CompareMemberByName();
    private static final Class[] NULL_ARGS = new Class[0];
    private static Class[] OIS_ARGS = null;
    private static Class[] OOS_ARGS = null;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectInputStream;

    private ObjectStreamClass(final Class clazz, ObjectStreamClass objectStreamClass, boolean bl, boolean bl2) {
        this.ofClass = clazz;
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl;
        this.externalizable = bl2;
        ObjectStreamClass.insertDescriptorFor(this);
        if (!this.serializable || this.externalizable) {
            this.fields = NO_FIELDS;
        } else if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Object object;
                    AccessibleObject[] accessibleObjectArray;
                    try {
                        accessibleObjectArray = clazz.getDeclaredField("serialPersistentFields");
                        accessibleObjectArray.setAccessible(true);
                        object = (ObjectStreamField[])accessibleObjectArray.get(clazz);
                        int n = accessibleObjectArray.getModifiers();
                        if (Modifier.isPrivate(n)) {
                            fields = (ObjectStreamField[])object;
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        fields = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        fields = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        fields = null;
                    }
                    if (fields == null) {
                        accessibleObjectArray = clazz.getDeclaredFields();
                        AccessibleObject.setAccessible(accessibleObjectArray, true);
                        int n = 0;
                        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[accessibleObjectArray.length];
                        int n2 = 0;
                        while (n2 < accessibleObjectArray.length) {
                            int n3 = ((Field)accessibleObjectArray[n2]).getModifiers();
                            if (!Modifier.isStatic(n3) && !Modifier.isTransient(n3)) {
                                objectStreamFieldArray[n++] = new ObjectStreamField((Field)accessibleObjectArray[n2]);
                            }
                            ++n2;
                        }
                        fields = new ObjectStreamField[n];
                        System.arraycopy(objectStreamFieldArray, 0, fields, 0, n);
                    } else {
                        int n = fields.length - 1;
                        while (n >= 0) {
                            try {
                                object = clazz.getDeclaredField(fields[n].getName());
                                if (fields[n].getType() == ((Field)object).getType()) {
                                    ((AccessibleObject)object).setAccessible(true);
                                    fields[n].setField((Field)object);
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {}
                            --n;
                        }
                    }
                    return null;
                }
            });
            if (this.fields.length > 1) {
                Arrays.sort(this.fields);
            }
            this.computeFieldInfo();
        }
        if (this.isNonSerializable()) {
            this.suid = 0L;
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Field field = clazz.getDeclaredField("serialVersionUID");
                        int n = field.getModifiers();
                        if (Modifier.isStatic(n) && Modifier.isFinal(n)) {
                            field.setAccessible(true);
                            suid = field.getLong(clazz);
                        } else {
                            suid = ObjectStreamClass.computeSerialVersionUID(clazz);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        suid = ObjectStreamClass.computeSerialVersionUID(clazz);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        suid = ObjectStreamClass.computeSerialVersionUID(clazz);
                    }
                    writeReplaceMethod = this.getDeclaredMethod("writeReplace", NULL_ARGS, 0, 8);
                    if (writeReplaceMethod == null && superclass != null && this.checkSuperMethodAccess(((ObjectStreamClass)this).superclass.writeReplaceMethod)) {
                        writeReplaceMethod = ((ObjectStreamClass)this).superclass.writeReplaceMethod;
                    }
                    readResolveMethod = this.getDeclaredMethod("readResolve", NULL_ARGS, 0, 8);
                    if (readResolveMethod == null && superclass != null && this.checkSuperMethodAccess(((ObjectStreamClass)this).superclass.readResolveMethod)) {
                        readResolveMethod = ((ObjectStreamClass)this).superclass.readResolveMethod;
                    }
                    if (serializable) {
                        if (OOS_ARGS == null || OIS_ARGS == null) {
                            ObjectStreamClass.initStaticMethodArgs();
                        }
                        writeObjectMethod = this.getDeclaredMethod("writeObject", OOS_ARGS, 2, 8);
                        if (writeObjectMethod != null) {
                            hasWriteObjectMethod = true;
                        }
                        readObjectMethod = this.getDeclaredMethod("readObject", OIS_ARGS, 2, 8);
                    }
                    return null;
                }
            });
        }
    }

    ObjectStreamClass(String string, long l) {
        this.name = string;
        this.suid = l;
        this.superclass = null;
    }

    static /* synthetic */ boolean access$13(ObjectStreamClass objectStreamClass) {
        return objectStreamClass.hasWriteObjectMethod;
    }

    static /* synthetic */ long access$2(ObjectStreamClass objectStreamClass) {
        return objectStreamClass.suid;
    }

    private boolean checkSuperMethodAccess(Method method) {
        if (method == null) {
            return false;
        }
        int n = method.getModifiers();
        if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return ObjectStreamClass.isSameClassPackage(method.getDeclaringClass(), this.ofClass);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static boolean compareClassNames(String string, String string2, char c) {
        int n;
        int n2 = string.lastIndexOf(c);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string2.lastIndexOf(c)) < 0) {
            n = 0;
        }
        return string.regionMatches(false, n2, string2, n, string.length() - n2);
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        int n = 0;
        while (n < this.fields.length) {
            switch (this.fields[n].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    this.fields[n].setOffset(this.primBytes);
                    ++this.primBytes;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.fields[n].setOffset(this.primBytes);
                    this.primBytes += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.fields[n].setOffset(this.primBytes);
                    this.primBytes += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.fields[n].setOffset(this.primBytes);
                    this.primBytes += 8;
                    break;
                }
                case 'L': 
                case '[': {
                    this.fields[n].setOffset(this.objFields);
                    ++this.objFields;
                    break;
                }
            }
            ++n;
        }
    }

    private static long computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            Object object;
            Object object2;
            int n;
            MethodSignature[] methodSignatureArray;
            int n2;
            Object[] objectArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n3 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n3 &= 0x611) & 0x200) != 0) {
                n3 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n3 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n3);
            if (!clazz.isArray()) {
                objectArray = clazz.getInterfaces();
                Arrays.sort(objectArray, compareClassByName);
                n2 = 0;
                while (n2 < objectArray.length) {
                    dataOutputStream.writeUTF(((Class)objectArray[n2]).getName());
                    ++n2;
                }
            }
            objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, compareMemberByName);
            n2 = 0;
            while (n2 < objectArray.length) {
                methodSignatureArray = objectArray[n2];
                n = methodSignatureArray.getModifiers();
                if (!Modifier.isPrivate(n) || !Modifier.isTransient(n) && !Modifier.isStatic(n)) {
                    dataOutputStream.writeUTF(methodSignatureArray.getName());
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(methodSignatureArray.getType()));
                }
                ++n2;
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            n = 0;
            while (n < methodSignatureArray.length) {
                object2 = methodSignatureArray[n];
                String string = "<init>";
                object = object2.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(object2.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                ++n;
            }
            object2 = MethodSignature.removePrivateAndSort(memberArray);
            int n4 = 0;
            while (n4 < ((MethodSignature[])object2).length) {
                object = object2[n4];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ++n4;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n5 = 0;
            while (n5 < Math.min(8, ((Object)object).length)) {
                l += (long)(object[n5] & 0xFF) << n5 * 8;
                ++n5;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n = clazz.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n2]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    public Class forClass() {
        return this.ofClass;
    }

    private Method getDeclaredMethod(String string, Class[] classArray, int n, int n2) {
        Method method = null;
        try {
            method = this.ofClass.getDeclaredMethod(string, classArray);
            if (method != null) {
                int n3 = method.getModifiers();
                if ((n3 & n2) != 0 || (n3 & n) != n) {
                    method = null;
                } else {
                    method.setAccessible(true);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return method;
    }

    public ObjectStreamField getField(String string) {
        ObjectStreamField objectStreamField = ObjectStreamField.constructSearchKey(string, Byte.TYPE);
        int n = -1;
        if (this.objFields != this.fields.length) {
            n = Arrays.binarySearch(this.fields, objectStreamField);
        }
        if (n < 0 && this.objFields > 0) {
            objectStreamField.setSearchKeyTypeString(true);
            n = Arrays.binarySearch(this.fields, objectStreamField);
        }
        return n < 0 ? null : this.fields[n];
    }

    ObjectStreamField getField(String string, Class clazz) {
        ObjectStreamField objectStreamField = ObjectStreamField.constructSearchKey(string, clazz);
        int n = Arrays.binarySearch(this.fields, objectStreamField);
        return n < 0 ? null : this.fields[n];
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        return this.suid;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("[");
                ++n2;
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    private static native boolean hasStaticInitializer(Class var0);

    boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    private static void initStaticMethodArgs() {
        OOS_ARGS = new Class[1];
        ObjectStreamClass.OOS_ARGS[0] = class$java$io$ObjectOutputStream != null ? class$java$io$ObjectOutputStream : (class$java$io$ObjectOutputStream = ObjectStreamClass.class$("java.io.ObjectOutputStream"));
        OIS_ARGS = new Class[1];
        ObjectStreamClass.OIS_ARGS[0] = class$java$io$ObjectInputStream != null ? class$java$io$ObjectInputStream : (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream"));
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n = objectStreamClass.ofClass.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n2];
        ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry;
    }

    static Object invokeMethod(Method method, Object object, Object[] objectArray) throws IOException {
        Object object2 = null;
        try {
            object2 = method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("interal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("interal error");
        }
        return object2;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isNonSerializable() {
        return (this.externalizable || this.serializable) ^ true;
    }

    boolean isReplaceable() {
        return this.writeReplaceMethod != null;
    }

    boolean isResolvable() {
        return this.readResolveMethod != null;
    }

    private static boolean isSameClassPackage(Class clazz, Class clazz2) {
        if (clazz.getClassLoader() != clazz2.getClassLoader()) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        int n2 = string2.lastIndexOf(46);
        if (n == -1 || n2 == -1) {
            return n == n2;
        }
        return string.regionMatches(false, 0, string2, 0, n - 1);
    }

    boolean isSerializable() {
        return this.serializable;
    }

    ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    public static ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        if (objectStreamClass.isSerializable() || objectStreamClass.isExternalizable()) {
            return objectStreamClass;
        }
        return null;
    }

    static ObjectStreamClass lookupInternal(Class clazz) {
        ObjectStreamClass objectStreamClass = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (objectStreamClassEntryArray) {
            Class clazz2;
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass != null) {
                ObjectStreamClass objectStreamClass2 = objectStreamClass;
                Object var4_4 = null;
                return objectStreamClass2;
            }
            boolean bl = (class$java$io$Serializable != null ? class$java$io$Serializable : (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable"))).isAssignableFrom(clazz);
            ObjectStreamClass objectStreamClass3 = null;
            if (bl && (clazz2 = clazz.getSuperclass()) != null) {
                objectStreamClass3 = ObjectStreamClass.lookup(clazz2);
            }
            boolean bl2 = false;
            if (bl) {
                boolean bl3 = (objectStreamClass3 == null || !objectStreamClass3.isExternalizable()) && !(class$java$io$Externalizable != null ? class$java$io$Externalizable : (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable"))).isAssignableFrom(clazz) ? false : (bl2 = true);
                if (bl2) {
                    bl = false;
                }
            }
            objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass3, bl, bl2);
        }
        return objectStreamClass;
    }

    void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte by = objectInputStream.readByte();
        this.serializable = (by & 2) != 0;
        boolean bl = this.externalizable = (by & 4) != 0;
        boolean bl2 = this.serializable ? (by & 1) != 0 : (this.hasWriteObjectMethod = false);
        this.hasExternalizableBlockData = this.externalizable ? (by & 8) != 0 : false;
        int n = objectInputStream.readShort();
        this.fields = new ObjectStreamField[n];
        boolean bl3 = objectInputStream.enableResolve;
        objectInputStream.enableResolve = false;
        try {
            int n2 = 0;
            while (n2 < n) {
                char c = (char)objectInputStream.readByte();
                String string = objectInputStream.readUTF();
                String string2 = null;
                if (c == '[' || c == 'L') {
                    string2 = (String)objectInputStream.readObject();
                }
                this.fields[n2] = new ObjectStreamField(string, c, null, string2);
                ++n2;
            }
        }
        finally {
            Object var6_9 = null;
            objectInputStream.enableResolve = bl3;
        }
    }

    void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(clazz);
        this.validateLocalClass(clazz);
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable) {
            this.disableInstanceDeserialization = true;
            this.ofClass = clazz;
            return;
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.fields;
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n = 0;
        int n2 = 0;
        while (n2 < objectStreamFieldArray2.length) {
            int n3 = n;
            while (n3 < objectStreamFieldArray.length) {
                if (objectStreamFieldArray2[n2].getName().equals(objectStreamFieldArray[n3].getName())) {
                    if (objectStreamFieldArray2[n2].isPrimitive() && !objectStreamFieldArray2[n2].typeEquals(objectStreamFieldArray[n3])) {
                        throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray[n2].getName() + " of class " + this.name + " is incompatible.");
                    }
                    n = n3;
                    objectStreamFieldArray2[n2].setField(objectStreamFieldArray[n].getField());
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        this.computeFieldInfo();
        this.ofClass = clazz;
        this.readObjectMethod = this.localClassDesc.readObjectMethod;
        this.readResolveMethod = this.localClassDesc.readResolveMethod;
    }

    void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    private void validateLocalClass(Class clazz) throws InvalidClassException {
        if (this.localClassDesc == null) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid) {
            boolean bl;
            boolean bl2 = this.isNonSerializable() || this.localClassDesc.isNonSerializable();
            boolean bl3 = bl = clazz.isArray() && !clazz.getName().equals(this.name);
            if (!bl && !bl2) {
                throw new InvalidClassException(clazz.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
            }
        }
        if (!ObjectStreamClass.compareClassNames(this.name, clazz.getName(), '.')) {
            throw new InvalidClassException(clazz.getName(), "Incompatible local class name. Expected class name compatible with " + this.name);
        }
        if (this.serializable && this.localClassDesc.externalizable || this.externalizable && this.localClassDesc.serializable) {
            throw new InvalidClassException(clazz.getName(), "Serializable is incompatible with Externalizable");
        }
    }

    void verifyInstanceDeserialization() throws InvalidClassException {
        if (this.disableInstanceDeserialization) {
            String string = this.serializable || this.externalizable ? this.localClassDesc.getName() : this.getName();
            String string2 = this.serializable || this.localClassDesc.serializable ? "Serializable" : "Externalizable";
            throw new InvalidClassException(string, "is not " + string2);
        }
    }

    void write(ObjectOutputStream objectOutputStream) throws IOException {
        int n = 0;
        if (this.hasWriteObjectMethod) {
            n |= 1;
        }
        if (this.serializable) {
            n |= 2;
        }
        if (this.externalizable) {
            n |= 4;
            if (!objectOutputStream.useDeprecatedExternalizableFormat) {
                n |= 8;
            }
        }
        objectOutputStream.writeByte(n);
        if (this.fields == null) {
            objectOutputStream.writeShort(0);
            return;
        }
        objectOutputStream.writeShort(this.fields.length);
        int n2 = 0;
        while (n2 < this.fields.length) {
            ObjectStreamField objectStreamField = this.fields[n2];
            objectOutputStream.writeByte(objectStreamField.getTypeCode());
            objectOutputStream.writeUTF(objectStreamField.getName());
            if (!objectStreamField.isPrimitive()) {
                objectOutputStream.writeTypeString(objectStreamField.getTypeString());
            }
            ++n2;
        }
    }

    private static class ObjectStreamClassEntry
    extends SoftReference {
        ObjectStreamClassEntry next;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            super(objectStreamClass);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = String.valueOf(string) + ObjectStreamClass.getSignature((Method)object);
                string2 = String.valueOf(string2) + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = String.valueOf(string) + ObjectStreamClass.getSignature((Constructor)object);
                string2 = String.valueOf(string2) + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n == 0) {
                    n = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n;
        }

        private boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n2].getModifiers())) {
                    ++n;
                }
                ++n2;
            }
            Object[] objectArray = new MethodSignature[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n4].getModifiers())) {
                    objectArray[n3] = new MethodSignature(memberArray[n4]);
                    ++n3;
                }
                ++n4;
            }
            if (n3 > 0) {
                Arrays.sort(objectArray, objectArray[0]);
            }
            return objectArray;
        }
    }
}

