/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Writer {
    private char[] writeBuffer;
    private final int writeBufferSize = 1024;
    protected Object lock;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock = object;
    }

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.writeBuffer == null) {
                this.writeBuffer = new char[1024];
            }
            this.writeBuffer[0] = (char)n;
            this.write(this.writeBuffer, 0, 1);
        }
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray;
            if (n2 <= 1024) {
                if (this.writeBuffer == null) {
                    this.writeBuffer = new char[1024];
                }
                cArray = this.writeBuffer;
            } else {
                cArray = new char[n2];
            }
            string.getChars(n, n + n2, cArray, 0);
            this.write(cArray, 0, n2);
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws IOException;
}

