/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.awt.geom.Rectangle2D;
import sun.awt.geom.Crossings;
import sun.awt.geom.Curve;

final class Order1
extends Curve {
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;

    public Order1(double d, double d2, double d3, double d4, int n) {
        super(n);
        this.x0 = d;
        this.y0 = d2;
        this.x1 = d3;
        this.y1 = d4;
        if (d < d3) {
            this.xmin = d;
            this.xmax = d3;
        } else {
            this.xmin = d3;
            this.xmax = d;
        }
    }

    public double TforY(double d) {
        return (d - this.y0) / (this.y1 - this.y0);
    }

    public double XforT(double d) {
        return this.x0 + d * (this.x1 - this.x0);
    }

    public double XforY(double d) {
        if (this.x0 == this.x1 || d == this.y0) {
            return this.x0;
        }
        if (d == this.y1) {
            return this.x1;
        }
        return this.x0 + (d - this.y0) * (this.x1 - this.x0) / (this.y1 - this.y0);
    }

    public double YforT(double d) {
        return this.y0 + d * (this.y1 - this.y0);
    }

    public boolean accumulateCrossings(Crossings crossings) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = crossings.getXLo();
        double d6 = crossings.getYLo();
        double d7 = crossings.getXHi();
        double d8 = crossings.getYHi();
        if (this.xmin >= d7) {
            return false;
        }
        if (this.y0 < d6) {
            if (this.y1 <= d6) {
                return false;
            }
            d4 = d6;
            d3 = this.XforY(d6);
        } else {
            if (this.y0 >= d8) {
                return false;
            }
            d4 = this.y0;
            d3 = this.x0;
        }
        if (this.y1 > d8) {
            d2 = d8;
            d = this.XforY(d8);
        } else {
            d2 = this.y1;
            d = this.x1;
        }
        if (d3 >= d7 && d >= d7) {
            return false;
        }
        if (d3 > d5 || d > d5) {
            return true;
        }
        crossings.record(d4, d2, this.direction);
        return false;
    }

    public int compareTo(Curve curve, double[] dArray) {
        if (!(curve instanceof Order1)) {
            return super.compareTo(curve, dArray);
        }
        Order1 order1 = (Order1)curve;
        if (dArray[1] <= dArray[0]) {
            throw new InternalError("yrange already screwed up...");
        }
        dArray[1] = Math.min(Math.min(dArray[1], this.y1), order1.y1);
        if (dArray[1] <= dArray[0]) {
            throw new InternalError("backstepping from " + dArray[0] + " to " + dArray[1]);
        }
        if (this.xmax <= order1.xmin) {
            return this.xmin == order1.xmax ? 0 : -1;
        }
        if (this.xmin >= order1.xmax) {
            return 1;
        }
        double d = order1.x1 - order1.x0;
        double d2 = this.y1 - this.y0;
        double d3 = this.x1 - this.x0;
        double d4 = order1.y1 - order1.y0;
        double d5 = d * d2 - d3 * d4;
        if (d5 == 0.0) {
            double d6 = Math.max(this.y0, order1.y0);
            return Curve.orderof(this.XforY(d6), order1.XforY(d6));
        }
        double d7 = (this.x0 - order1.x0) * d2 * d4 - this.y0 * d3 * d4 + order1.y0 * d * d2;
        double d8 = d7 / d5;
        if (d8 <= dArray[0]) {
            return Curve.orderof(d3 / d2, d / d4);
        }
        dArray[1] = Math.min(dArray[1], d8);
        return Curve.orderof(d / d4, d3 / d2);
    }

    public double dXforT(double d, int n) {
        switch (n) {
            case 0: {
                return this.x0 + d * (this.x1 - this.x0);
            }
            case 1: {
                return this.x1 - this.x0;
            }
        }
        return 0.0;
    }

    public double dYforT(double d, int n) {
        switch (n) {
            case 0: {
                return this.y0 + d * (this.y1 - this.y0);
            }
            case 1: {
                return this.y1 - this.y0;
            }
        }
        return 0.0;
    }

    public void enlarge(Rectangle2D rectangle2D) {
        rectangle2D.add(this.x0, this.y0);
        rectangle2D.add(this.x1, this.y1);
    }

    public int getOrder() {
        return 1;
    }

    public Curve getReversedCurve() {
        return new Order1(this.x0, this.y0, this.x1, this.y1, -this.direction);
    }

    public int getSegment(double[] dArray) {
        if (this.direction == 1) {
            dArray[0] = this.x1;
            dArray[1] = this.y1;
        } else {
            dArray[0] = this.x0;
            dArray[1] = this.y0;
        }
        return 1;
    }

    public Curve getSubCurve(double d, double d2, int n) {
        if (d == this.y0 && d2 == this.y1) {
            return this.getWithDirection(n);
        }
        if (this.x0 == this.x1) {
            return new Order1(this.x0, d, this.x1, d2, n);
        }
        double d3 = this.x0 - this.x1;
        double d4 = this.y0 - this.y1;
        double d5 = this.x0 + (d - this.y0) * d3 / d4;
        double d6 = this.x0 + (d2 - this.y0) * d3 / d4;
        return new Order1(d5, d, d6, d2, n);
    }

    public double getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    public double getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    public double getXBot() {
        return this.x1;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXTop() {
        return this.x0;
    }

    public double getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public double getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    public double getYBot() {
        return this.y1;
    }

    public double getYTop() {
        return this.y0;
    }

    public double nextVertical(double d, double d2) {
        return d2;
    }
}

