/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.robot;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class ScreenCapture {
    private Image image;

    ScreenCapture(Image image) {
        this.image = image;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScreenCapture)) {
            return false;
        }
        ScreenCapture screenCapture = (ScreenCapture)object;
        Image image = screenCapture.getImage();
        if (image.getWidth(null) != this.image.getWidth(null) || image.getHeight(null) != this.image.getHeight(null)) {
            return false;
        }
        int[] nArray = this.getPixels(this.image);
        int[] nArray2 = this.getPixels(image);
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Image getImage() {
        return this.image;
    }

    private int[] getPixels(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Problem grabbing pixels.");
        }
        return nArray;
    }

    public void writeAsGifToStream(OutputStream outputStream) throws IOException {
        throw new Error("NOT IMPLEMENTED");
    }
}

