/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import sun.awt.windows.TextRenderingGDI;
import sun.awt.windows.WGraphics;
import sun.awt.windows.WPrintJob;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.GraphicsPrimitives;
import sun.java2d.loops.ImageData;
import sun.java2d.loops.RasterOutputManager;

class WPrintGraphics
extends WGraphics
implements PrintGraphics {
    static final String newDevID = "WPrintGraphics";
    WPrintJob pjob;
    int pageNum;
    boolean hasPageNum;
    boolean drawingText = false;

    static {
        RasterOutputManager rasterOutputManager = RasterOutputManager.getManager();
        GraphicsPrimitiveMgr.register((GraphicsPrimitives)new TextRenderingGDI(), newDevID);
        WPrintGraphics.initIDs();
    }

    public WPrintGraphics(WPrintJob wPrintJob) {
        super(wPrintJob);
        this.pjob = wPrintJob;
    }

    public Object clone() {
        WPrintGraphics wPrintGraphics = (WPrintGraphics)super.clone();
        wPrintGraphics.hasPageNum = false;
        wPrintGraphics.pageNum = 0;
        return wPrintGraphics;
    }

    Graphics create(int n) {
        WPrintGraphics wPrintGraphics = (WPrintGraphics)this.create();
        wPrintGraphics.hasPageNum = true;
        wPrintGraphics.pageNum = n;
        return wPrintGraphics;
    }

    protected void disposeImpl() {
        if (this.hasPageNum && this.pjob != null) {
            this.pjob.flushPage(this.pageNum);
        }
        super.disposeImpl();
    }

    public final String getDevID() {
        return newDevID;
    }

    public PrintJob getPrintJob() {
        return this.pjob;
    }

    private static native void initIDs();

    public ImageData lock(int n, int n2, int n3, int n4, int n5) {
        ImageData imageData = super.lock(n, n2, n3, n4, n5);
        if (!this.drawingText) {
            return imageData;
        }
        if (imageData != null) {
            imageData.setOriginX((int)this.transform.getTranslateX());
            imageData.setOriginY((int)this.transform.getTranslateY());
            imageData.setType(0);
        }
        return imageData;
    }
}

