/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.rmi.server.LogStream;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.proxy.RMISocketInfo;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPTransport;

public class TCPConnection
implements Connection {
    private Socket socket;
    private Channel channel;
    private InputStream in = null;
    private OutputStream out = null;
    private long expiration = Long.MAX_VALUE;
    private long lastuse = Long.MIN_VALUE;
    private long roundtrip = 5L;

    TCPConnection(TCPChannel tCPChannel, InputStream inputStream, OutputStream outputStream) {
        this(tCPChannel, null, inputStream, outputStream);
    }

    TCPConnection(TCPChannel tCPChannel, Socket socket) {
        this(tCPChannel, socket, null, null);
    }

    TCPConnection(TCPChannel tCPChannel, Socket socket, InputStream inputStream, OutputStream outputStream) {
        this.socket = socket;
        this.channel = tCPChannel;
        this.in = inputStream;
        this.out = outputStream;
    }

    public void close() throws IOException {
        if (TCPTransport.logLevel >= 10) {
            LogStream.log("tcp").println("TCPConnection.close: close connection");
        }
        if (this.socket != null) {
            this.socket.close();
        } else {
            this.in.close();
            this.out.close();
        }
    }

    boolean expired(long l) {
        return this.expiration <= l;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(this.socket.getInputStream());
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        return this.out;
    }

    public boolean isDead() {
        OutputStream outputStream;
        InputStream inputStream;
        long l = System.currentTimeMillis();
        if (this.roundtrip > 0L && l < this.lastuse + this.roundtrip) {
            return false;
        }
        try {
            inputStream = this.getInputStream();
            outputStream = this.getOutputStream();
        }
        catch (IOException iOException) {
            return true;
        }
        int n = 0;
        try {
            outputStream.write(82);
            outputStream.flush();
            n = inputStream.read();
        }
        catch (IOException iOException) {
            if (TCPTransport.logLevel >= 20) {
                iOException.printStackTrace(LogStream.log("tcp"));
            }
            if (TCPTransport.logLevel >= 10) {
                LogStream.log("tcp").println("TCPConnection.isDead: server ping failed");
            }
            return true;
        }
        if (n == 83) {
            this.roundtrip = (System.currentTimeMillis() - l) * 2L;
            return false;
        }
        if (TCPTransport.logLevel >= 10) {
            LogStream.log("tcp").println("TCPConnection.isDead: " + (n == -1 ? "server has been deactivated" : "server protocol error: ping response = " + n));
        }
        return true;
    }

    public boolean isReusable() {
        if (this.socket != null && this.socket instanceof RMISocketInfo) {
            return ((RMISocketInfo)((Object)this.socket)).isReusable();
        }
        return true;
    }

    public void releaseInputStream() {
    }

    public void releaseOutputStream() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    void setExpiration(long l) {
        this.expiration = l;
    }

    void setLastUseTime(long l) {
        this.lastuse = l;
    }
}

