/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Locale;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.ConstrainableGraphics;
import sun.awt.SunToolkit;
import sun.java2d.loops.RasterOutputManager;
import sun.security.action.GetPropertyAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    transient ComponentPeer peer;
    transient Container parent;
    transient AppContext appContext;
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    boolean visible = true;
    boolean enabled = true;
    boolean valid = false;
    DropTarget dropTarget;
    boolean hasFocus = false;
    Vector popups;
    private String name;
    private boolean nameExplicitlySet = false;
    static final Object LOCK = new AWTTreeLock();
    Dimension minSize;
    Dimension prefSize;
    transient ComponentOrientation componentOrientation = ComponentOrientation.UNKNOWN;
    boolean newEventsOnly = false;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient InputMethodListener inputMethodListener;
    static final String actionListenerK = "actionL";
    static final String adjustmentListenerK = "adjustmentL";
    static final String componentListenerK = "componentL";
    static final String containerListenerK = "containerL";
    static final String focusListenerK = "focusL";
    static final String itemListenerK = "itemL";
    static final String keyListenerK = "keyL";
    static final String mouseListenerK = "mouseL";
    static final String mouseMotionListenerK = "mouseMotionL";
    static final String textListenerK = "textL";
    static final String ownedWindowK = "ownedL";
    static final String windowListenerK = "windowL";
    static final String inputMethodListenerK = "inputMethodL";
    long eventMask = 4096L;
    private static final boolean assert = false;
    static boolean isInc;
    static int incRate;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    private static final long serialVersionUID = -7644114512714619750L;
    private PropertyChangeSupport changeSupport;
    boolean isPacked = false;
    private int componentSerializedDataVersion = 2;

    static {
        Toolkit.loadLibraries();
        Component.initIDs();
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("awt.image.incrementaldraw"));
        isInc = string == null || string.equals("true");
        string = (String)AccessController.doPrivileged(new GetPropertyAction("awt.image.redrawrate"));
        incRate = string != null ? Integer.parseInt(string) : 100;
    }

    protected Component() {
        this.appContext = AppContext.getAppContext();
        SunToolkit.insertTargetMapping(this, this.appContext);
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public synchronized void add(PopupMenu popupMenu) {
        if (popupMenu.parent != null) {
            popupMenu.parent.remove(popupMenu);
        }
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.addElement(popupMenu);
        popupMenu.parent = this;
        if (this.peer != null && popupMenu.peer == null) {
            popupMenu.addNotify();
        }
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            return;
        }
        this.componentListener = AWTEventMulticaster.add(this.componentListener, componentListener);
        this.newEventsOnly = true;
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(4L);
        }
    }

    public synchronized void addInputMethodListener(InputMethodListener inputMethodListener) {
        if (inputMethodListener == null) {
            return;
        }
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, inputMethodListener);
        this.newEventsOnly = true;
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(8L);
        }
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(16L);
        }
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(32L);
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuContainer menuContainer;
            ComponentPeer componentPeer = this.peer;
            if (componentPeer == null || componentPeer instanceof LightweightPeer) {
                if (componentPeer == null) {
                    this.peer = componentPeer = this.getToolkit().createComponent(this);
                }
                long l = 0L;
                if (this.mouseListener != null || (this.eventMask & 0x10L) != 0L) {
                    l |= 0x10L;
                }
                if (this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L) {
                    l |= 0x20L;
                }
                if (this.focusListener != null || (this.eventMask & 4L) != 0L) {
                    l |= 4L;
                }
                if (this.keyListener != null || (this.eventMask & 8L) != 0L) {
                    l |= 8L;
                }
                if (l != 0L) {
                    this.parent.proxyEnableEvents(l);
                }
            } else {
                Container container = this.parent;
                if (container != null && container.peer instanceof LightweightPeer) {
                    new NativeInLightFixer();
                }
            }
            this.invalidate();
            int n = this.popups != null ? this.popups.size() : 0;
            int n2 = 0;
            while (n2 < n) {
                menuContainer = (PopupMenu)this.popups.elementAt(n2);
                ((PopupMenu)menuContainer).addNotify();
                ++n2;
            }
            menuContainer = this.getParent();
            while (menuContainer != null) {
                if (menuContainer instanceof Window) {
                    ((Window)menuContainer).getWarningString();
                    break;
                }
                menuContainer = ((Component)menuContainer).getParent();
            }
            if (this.dropTarget != null) {
                this.dropTarget.addNotify(componentPeer);
            }
            this.peerFont = this.getFont();
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    boolean areInputMethodsEnabled() {
        return (this.eventMask & 0x1000L) != 0L && ((this.eventMask & 8L) != 0L || this.keyListener != null);
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent.checkImage(image, n, n2, imageObserver);
        }
        return componentPeer != null ? componentPeer.checkImage(image, n, n2, imageObserver) : this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return this.checkImage(image, -1, -1, imageObserver);
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        int n = aWTEvent.getID();
        switch (n) {
            case 503: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (mouseEvent.getModifiers() != ((MouseEvent)aWTEvent2).getModifiers()) break;
                return aWTEvent2;
            }
            case 800: 
            case 801: {
                PaintEvent paintEvent = (PaintEvent)aWTEvent;
                PaintEvent paintEvent2 = (PaintEvent)aWTEvent2;
                Rectangle rectangle = paintEvent.getUpdateRect();
                Rectangle rectangle2 = paintEvent2.getUpdateRect();
                if (rectangle.contains(rectangle2)) {
                    return aWTEvent;
                }
                if (!rectangle2.contains(rectangle)) break;
                return aWTEvent2;
            }
        }
        return null;
    }

    String constructComponentName() {
        return null;
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Image createImage(int n, int n2) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent.createImage(n, n2);
        }
        return componentPeer != null ? componentPeer.createImage(n, n2) : null;
    }

    public Image createImage(ImageProducer imageProducer) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.createImage(imageProducer);
        }
        return this.getToolkit().createImage(imageProducer);
    }

    public void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public void disable() {
        if (this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.enabled = false;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.disable();
                }
            }
        }
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        Object object;
        int n = aWTEvent.getID();
        Toolkit.getDefaultToolkit().notifyAWTEventListeners(aWTEvent);
        if (this.areInputMethodsEnabled() && (aWTEvent instanceof InputMethodEvent && this.getInputMethodRequests() == null || aWTEvent instanceof ComponentEvent && !(aWTEvent instanceof PaintEvent)) && (object = this.getInputContext()) != null) {
            ((InputContext)object).dispatchEvent(aWTEvent);
            if (aWTEvent.isConsumed()) {
                return;
            }
        }
        switch (n) {
            case 1004: {
                if (this.parent == null || this instanceof Window) break;
                this.parent.setFocusOwner(this);
                break;
            }
            case 401: 
            case 402: {
                object = (Container)(this instanceof Container ? this : this.parent);
                if (object == null) break;
                ((Container)object).preProcessKeyEvent((KeyEvent)aWTEvent);
                if (!aWTEvent.isConsumed()) break;
                return;
            }
        }
        if (this.newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
            }
        } else if ((!(aWTEvent instanceof MouseEvent) || this.postsOldMouseEvents()) && (object = aWTEvent.convertToOld()) != null) {
            int n2 = ((Event)object).key;
            int n3 = ((Event)object).modifiers;
            this.postEvent((Event)object);
            if (((Event)object).isConsumed()) {
                aWTEvent.consume();
            }
            switch (((Event)object).id) {
                case 401: 
                case 402: 
                case 403: 
                case 404: {
                    if (((Event)object).key != n2) {
                        ((KeyEvent)aWTEvent).setKeyChar(((Event)object).getKeyEventChar());
                    }
                    if (((Event)object).modifiers == n3) break;
                    ((KeyEvent)aWTEvent).setModifiers(((Event)object).modifiers);
                    break;
                }
            }
        }
        if (!aWTEvent.isConsumed() && aWTEvent instanceof KeyEvent && (object = (Container)(this instanceof Container ? this : this.parent)) != null) {
            ((Container)object).postProcessKeyEvent((KeyEvent)aWTEvent);
        }
        if (this.peer != null) {
            this.peer.handleEvent(aWTEvent);
        }
    }

    public void doLayout() {
        this.layout();
    }

    public void enable() {
        if (!this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.enabled = true;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.enable();
                }
            }
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(this.eventMask);
        }
    }

    public void enableInputMethods(boolean bl) {
        if (bl) {
            InputContext inputContext;
            if ((this.eventMask & 0x1000L) != 0L) {
                return;
            }
            if (this.hasFocus() && (inputContext = this.getInputContext()) != null) {
                FocusEvent focusEvent = new FocusEvent(this, 1004);
                inputContext.dispatchEvent(focusEvent);
            }
            this.eventMask |= 0x1000L;
        } else {
            InputContext inputContext;
            if (this.areInputMethodsEnabled() && (inputContext = this.getInputContext()) != null) {
                inputContext.endComposition();
                inputContext.removeNotify(this);
            }
            this.eventMask &= 0xFFFFFFFFFFFFEFFFL;
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                if ((this.eventMask & 1L) == 0L && this.componentListener == null) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this.eventMask & 4L) == 0L && this.focusListener == null) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this.eventMask & 8L) == 0L && this.keyListener == null) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this.eventMask & 0x10L) == 0L && this.mouseListener == null) break;
                return true;
            }
            case 503: 
            case 506: {
                if ((this.eventMask & 0x20L) == 0L && this.mouseMotionListener == null) break;
                return true;
            }
            case 1100: 
            case 1101: {
                if ((this.eventMask & 0x800L) == 0L && this.inputMethodListener == null) break;
                return true;
            }
        }
        return aWTEvent.id > 1999;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public Color getBackground() {
        Color color = this.background;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        return container != null ? container.getBackground() : null;
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    public ColorModel getColorModel() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getColorModel();
        }
        return this.getToolkit().getColorModel();
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public ComponentOrientation getComponentOrientation() {
        return this.componentOrientation;
    }

    public Cursor getCursor() {
        Cursor cursor = this.cursor;
        if (cursor != null) {
            return cursor;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getCursor();
        }
        return Cursor.getPredefinedCursor(0);
    }

    public synchronized DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        return container != null ? container.getFont() : null;
    }

    public FontMetrics getFontMetrics(Font font) {
        Graphics graphics;
        if (RasterOutputManager.usesPlatformFont() && this.peer != null && !(this.peer instanceof LightweightPeer)) {
            return this.peer.getFontMetrics(font);
        }
        if (this.parent != null && (graphics = this.parent.getGraphics()) != null) {
            return graphics.getFontMetrics(font);
        }
        return this.getToolkit().getFontMetrics(font);
    }

    final Font getFont_NoClientCode() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        return container != null ? container.getFont_NoClientCode() : null;
    }

    public Color getForeground() {
        Color color = this.foreground;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        return container != null ? container.getForeground() : null;
    }

    public Graphics getGraphics() {
        if (this.peer instanceof LightweightPeer) {
            Graphics graphics = this.parent.getGraphics();
            if (graphics instanceof ConstrainableGraphics) {
                ((ConstrainableGraphics)((Object)graphics)).constrain(this.x, this.y, this.width, this.height);
            } else {
                graphics.translate(this.x, this.y);
                graphics.setClip(0, 0, this.width, this.height);
            }
            graphics.setFont(this.getFont());
            return graphics;
        }
        ComponentPeer componentPeer = this.peer;
        return componentPeer != null ? componentPeer.getGraphics() : null;
    }

    public int getHeight() {
        return this.height;
    }

    public InputContext getInputContext() {
        Container container = this.parent;
        if (container == null) {
            return null;
        }
        return container.getInputContext();
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    Cursor getIntrinsicCursor() {
        return this.cursor;
    }

    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale != null) {
            return locale;
        }
        Container container = this.parent;
        if (container == null) {
            throw new IllegalComponentStateException("This component must have a parent in order to determine its locale");
        }
        return container.getLocale();
    }

    public Point getLocation() {
        return this.location();
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point getLocationOnScreen() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
            if (!this.isShowing()) throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
            Point point = this.peer.getLocationOnScreen();
            if (!(this.peer instanceof LightweightPeer)) return point;
            Container container = this.getNativeContainer();
            Point point2 = container.peer.getLocationOnScreen();
            Component component = this;
            while (component != container) {
                point2.x += component.x;
                point2.y += component.y;
                component = component.getParent();
            }
            return point2;
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            Component component = this;
            synchronized (component) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    Container getNativeContainer() {
        Container container = this.parent;
        while (container != null && container.peer instanceof LightweightPeer) {
            container = container.getParent();
        }
        return container;
    }

    public Container getParent() {
        return this.getParent_NoClientCode();
    }

    final Container getParent_NoClientCode() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public Toolkit getToolkit() {
        return this.getToolkitImpl();
    }

    final Toolkit getToolkitImpl() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getToolkit();
        }
        Container container = this.parent;
        if (container != null) {
            return container.getToolkitImpl();
        }
        return Toolkit.getDefaultToolkit();
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    public int getWidth() {
        return this.width;
    }

    private Window getWindowForObject(Object object) {
        if (object instanceof Component) {
            while (object != null) {
                if (object instanceof Window) {
                    return (Window)object;
                }
                object = ((Component)object).getParent();
            }
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyDown(event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(event, event.key);
            }
            case 1001: {
                return this.action(event, event.arg);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
        }
        return false;
    }

    public boolean hasFocus() {
        if ((this.eventMask & 4L) != 0L) {
            return this.hasFocus;
        }
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return ((Window)container).getFocusOwner() == this;
            }
            container = container.getParent();
        }
        return false;
    }

    public void hide() {
        if (this.visible) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.visible = false;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.hide();
                    if (componentPeer instanceof LightweightPeer) {
                        this.repaint();
                    }
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 103);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        int n6 = -1;
        if ((n & 0x30) != 0) {
            n6 = 0;
        } else if ((n & 8) != 0 && isInc) {
            try {
                n6 = incRate;
                if (n6 < 0) {
                    n6 = 0;
                }
            }
            catch (Exception exception) {
                n6 = 100;
            }
        }
        if (n6 >= 0) {
            this.repaint(n6, 0, 0, this.width, this.height);
        }
        return (n & 0xA0) == 0;
    }

    private static native void initIDs();

    public boolean inside(int n, int n2) {
        return n >= 0 && n < this.width && n2 >= 0 && n2 < this.height;
    }

    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.valid = false;
            this.prefSize = null;
            this.minSize = null;
            if (this.parent != null && this.parent.valid) {
                this.parent.invalidate();
            }
        }
    }

    public boolean isDisplayable() {
        return this.getPeer() != null;
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public boolean isEnabled() {
        return this.isEnabledImpl();
    }

    final boolean isEnabledImpl() {
        return this.enabled;
    }

    public boolean isFocusTraversable() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.isFocusTraversable();
        }
        return false;
    }

    public boolean isLightweight() {
        return this.getPeer() instanceof LightweightPeer;
    }

    public boolean isOpaque() {
        return this.isLightweight() ^ true;
    }

    public boolean isShowing() {
        if (this.visible && this.peer != null) {
            Container container = this.parent;
            return container == null || container.isShowing();
        }
        return false;
    }

    public boolean isValid() {
        return this.peer != null && this.valid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean keyDown(Event event, int n) {
        return false;
    }

    public boolean keyUp(Event event, int n) {
        return false;
    }

    public void layout() {
    }

    void lightweightPrint(Graphics graphics) {
        this.print(graphics);
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print("  ");
            ++n2;
        }
        printStream.println(this);
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, 0);
    }

    public void list(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("  ");
            ++n2;
        }
        printWriter.println(this);
    }

    public Component locate(int n, int n2) {
        return this.contains(n, n2) ? this : null;
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.minSize = this.peer != null ? this.peer.minimumSize() : this.size();
            Object var4_4 = null;
            return dimension2;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public void move(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height);
    }

    public void nextFocus() {
        Container container = this.parent;
        if (container != null) {
            container.transferFocus(this);
        }
    }

    public void paint(Graphics graphics) {
    }

    public void paintAll(Graphics graphics) {
        ComponentPeer componentPeer = this.peer;
        if (this.visible && componentPeer != null) {
            this.validate();
            if (componentPeer instanceof LightweightPeer) {
                this.paint(graphics);
            } else {
                componentPeer.paint(graphics);
            }
        }
    }

    protected String paramString() {
        String string = this.getName();
        String string2 = String.valueOf(string != null ? string : "") + "," + this.x + "," + this.y + "," + this.width + "x" + this.height;
        if (!this.valid) {
            string2 = String.valueOf(string2) + ",invalid";
        }
        if (!this.visible) {
            string2 = String.valueOf(string2) + ",hidden";
        }
        if (!this.enabled) {
            string2 = String.valueOf(string2) + ",disabled";
        }
        return string2;
    }

    public boolean postEvent(Event event) {
        ComponentPeer componentPeer = this.peer;
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        Container container = this.parent;
        int n = event.x;
        int n2 = event.y;
        if (container != null) {
            event.translate(this.x, this.y);
            if (container.postEvent(event)) {
                event.consume();
                return true;
            }
            event.x = n;
            event.y = n2;
        }
        return false;
    }

    boolean postsOldMouseEvents() {
        return false;
    }

    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.prefSize = this.peer != null ? this.peer.preferredSize() : this.getMinimumSize();
            Object var4_4 = null;
            return dimension2;
        }
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent.prepareImage(image, n, n2, imageObserver);
        }
        return componentPeer != null ? componentPeer.prepareImage(image, n, n2, imageObserver) : this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, -1, -1, imageObserver);
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        ComponentPeer componentPeer = this.peer;
        if (this.visible && componentPeer != null) {
            Graphics graphics2;
            block4: {
                this.validate();
                graphics2 = graphics.create(0, 0, this.width, this.height);
                graphics2.setFont(this.getFont());
                try {
                    if (componentPeer instanceof LightweightPeer) {
                        this.lightweightPrint(graphics2);
                        break block4;
                    }
                    componentPeer.print(graphics2);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
            Object var5_4 = null;
            graphics2.dispose();
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        ComponentListener componentListener = this.componentListener;
        if (componentListener != null) {
            int n = componentEvent.getID();
            switch (n) {
                case 101: {
                    componentListener.componentResized(componentEvent);
                    break;
                }
                case 100: {
                    componentListener.componentMoved(componentEvent);
                    break;
                }
                case 102: {
                    componentListener.componentShown(componentEvent);
                    break;
                }
                case 103: {
                    componentListener.componentHidden(componentEvent);
                    break;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent);
                    return;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
            return;
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
            return;
        } else {
            if (!(aWTEvent instanceof InputMethodEvent)) return;
            this.processInputMethodEvent((InputMethodEvent)aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        FocusListener focusListener = this.focusListener;
        if (focusListener != null) {
            int n = focusEvent.getID();
            switch (n) {
                case 1004: {
                    focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    focusListener.focusLost(focusEvent);
                    break;
                }
            }
        }
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        InputMethodListener inputMethodListener = this.inputMethodListener;
        if (inputMethodListener != null) {
            int n = inputMethodEvent.getID();
            switch (n) {
                case 1100: {
                    inputMethodListener.inputMethodTextChanged(inputMethodEvent);
                    break;
                }
                case 1101: {
                    inputMethodListener.caretPositionChanged(inputMethodEvent);
                    break;
                }
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        KeyListener keyListener = this.keyListener;
        if (keyListener != null) {
            int n = keyEvent.getID();
            switch (n) {
                case 400: {
                    keyListener.keyTyped(keyEvent);
                    break;
                }
                case 401: {
                    keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    keyListener.keyReleased(keyEvent);
                    break;
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        MouseListener mouseListener = this.mouseListener;
        if (mouseListener != null) {
            int n = mouseEvent.getID();
            switch (n) {
                case 501: {
                    mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    mouseListener.mouseEntered(mouseEvent);
                    break;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        MouseMotionListener mouseMotionListener = this.mouseMotionListener;
        if (mouseMotionListener != null) {
            int n = mouseEvent.getID();
            switch (n) {
                case 503: {
                    mouseMotionListener.mouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    mouseMotionListener.mouseDragged(mouseEvent);
                    break;
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        block11: {
            Object object2;
            objectInputStream.defaultReadObject();
            this.appContext = AppContext.getAppContext();
            SunToolkit.insertTargetMapping(this, this.appContext);
            while ((object2 = objectInputStream.readObject()) != null) {
                object = ((String)object2).intern();
                if (object == componentListenerK) {
                    this.addComponentListener((ComponentListener)objectInputStream.readObject());
                    continue;
                }
                if (object == focusListenerK) {
                    this.addFocusListener((FocusListener)objectInputStream.readObject());
                    continue;
                }
                if (object == keyListenerK) {
                    this.addKeyListener((KeyListener)objectInputStream.readObject());
                    continue;
                }
                if (object == mouseListenerK) {
                    this.addMouseListener((MouseListener)objectInputStream.readObject());
                    continue;
                }
                if (object == mouseMotionListenerK) {
                    this.addMouseMotionListener((MouseMotionListener)objectInputStream.readObject());
                    continue;
                }
                if (object == inputMethodListenerK) {
                    this.addInputMethodListener((InputMethodListener)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
            object = null;
            try {
                object = objectInputStream.readObject();
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block11;
                throw optionalDataException;
            }
        }
        this.componentOrientation = object != null ? (ComponentOrientation)object : ComponentOrientation.UNKNOWN;
        if (this.popups != null) {
            int n = this.popups.size();
            int n2 = 0;
            while (n2 < n) {
                PopupMenu popupMenu = (PopupMenu)this.popups.elementAt(n2);
                popupMenu.parent = this;
                ++n2;
            }
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        int n;
        if (this.popups != null && (n = this.popups.indexOf(menuComponent)) >= 0) {
            PopupMenu popupMenu = (PopupMenu)menuComponent;
            if (popupMenu.peer != null) {
                popupMenu.removeNotify();
            }
            popupMenu.parent = null;
            this.popups.removeElementAt(n);
            if (this.popups.size() == 0) {
                this.popups = null;
            }
        }
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            return;
        }
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, componentListener);
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public synchronized void removeInputMethodListener(InputMethodListener inputMethodListener) {
        if (inputMethodListener == null) {
            return;
        }
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, inputMethodListener);
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Object object2;
            int n = this.popups != null ? this.popups.size() : 0;
            int n2 = 0;
            while (n2 < n) {
                object2 = (PopupMenu)this.popups.elementAt(n2);
                ((Menu)object2).removeNotify();
                ++n2;
            }
            if (this.areInputMethodsEnabled() && (object2 = this.getInputContext()) != null) {
                ((InputContext)object2).removeNotify(this);
            }
            if ((object2 = this.peer) != null) {
                if (this.dropTarget != null) {
                    this.dropTarget.removeNotify(this.peer);
                }
                if (this.visible) {
                    object2.hide();
                }
                this.peer = null;
                this.peerFont = null;
                Toolkit.getEventQueue().removeSourceEvents(this);
                object2.dispose();
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.repaint(0L, n, n2, n3, n4);
    }

    public void repaint(long l) {
        this.repaint(l, 0, 0, this.width, this.height);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.peer instanceof LightweightPeer) {
            int n5 = this.x + (n < 0 ? 0 : n);
            int n6 = this.y + (n2 < 0 ? 0 : n2);
            int n7 = n3 > this.width ? this.width : n3;
            int n8 = n4 > this.height ? this.height : n4;
            this.parent.repaint(l, n5, n6, n7, n8);
        } else {
            ComponentPeer componentPeer = this.peer;
            if (componentPeer != null && n3 > 0 && n4 > 0) {
                componentPeer.repaint(l, n, n2, n3, n4);
            }
        }
    }

    public void requestFocus() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            if (componentPeer instanceof LightweightPeer) {
                this.parent.proxyRequestFocus(this);
            } else {
                componentPeer.requestFocus();
                Toolkit.getEventQueue().changeKeyEventFocus(this);
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Object object = this.getTreeLock();
        synchronized (object) {
            boolean bl = this.width != n3 || this.height != n4;
            boolean bl2 = this.x != n || this.y != n2;
            boolean bl3 = this.peer instanceof LightweightPeer;
            if (bl) {
                this.isPacked = false;
            }
            if (bl || bl2) {
                if (bl3 && this.visible) {
                    this.repaint();
                }
                this.x = n;
                this.y = n2;
                this.width = n3;
                this.height = n4;
                if (this.peer != null) {
                    if (bl3) {
                        this.peer.setBounds(n, n2, n3, n4);
                    } else {
                        int n5 = n;
                        int n6 = n2;
                        Container container = this.parent;
                        while (container != null && container.peer instanceof LightweightPeer) {
                            n5 += container.x;
                            n6 += container.y;
                            container = container.parent;
                        }
                        this.peer.setBounds(n5, n6, n3, n4);
                    }
                    if (bl) {
                        this.invalidate();
                        if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                            ComponentEvent componentEvent = new ComponentEvent(this, 101);
                            Toolkit.getEventQueue().postEvent(componentEvent);
                        }
                    }
                    if (bl2 && (this.componentListener != null || (this.eventMask & 1L) != 0L)) {
                        ComponentEvent componentEvent = new ComponentEvent(this, 100);
                        Toolkit.getEventQueue().postEvent(componentEvent);
                    }
                    if (this.parent != null && this.parent.valid) {
                        this.parent.invalidate();
                    }
                }
                if (bl3 && this.visible) {
                    this.repaint();
                }
            }
        }
    }

    public void resize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2);
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setBackground(Color color) {
        Color color2 = this.background;
        ComponentPeer componentPeer = this.peer;
        this.background = color;
        if (componentPeer != null && (color = this.getBackground()) != null) {
            componentPeer.setBackground(color);
        }
        this.firePropertyChange("background", color2, color);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        ComponentOrientation componentOrientation2 = this.componentOrientation;
        this.componentOrientation = componentOrientation;
        this.firePropertyChange("componentOrientation", componentOrientation2, componentOrientation);
        if (this.valid) {
            this.invalidate();
        }
    }

    public synchronized void setCursor(Cursor cursor) {
        this.cursor = cursor;
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            this.getNativeContainer().updateCursor(this);
        } else if (componentPeer != null) {
            componentPeer.setCursor(cursor);
        }
    }

    public synchronized void setDropTarget(DropTarget dropTarget) {
        block11: {
            if (dropTarget == this.dropTarget || this.dropTarget != null && this.dropTarget.equals(dropTarget)) {
                return;
            }
            DropTarget dropTarget2 = this.dropTarget;
            if (dropTarget2 != null) {
                if (this.peer != null) {
                    this.dropTarget.removeNotify(this.peer);
                }
                DropTarget dropTarget3 = this.dropTarget;
                this.dropTarget = null;
                try {
                    dropTarget3.setComponent(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if ((this.dropTarget = dropTarget) == null) break block11;
            try {
                this.dropTarget.setComponent(this);
                if (this.peer != null) {
                    this.dropTarget.addNotify(this.peer);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (dropTarget2 == null) break block11;
                try {
                    dropTarget2.setComponent(this);
                    if (this.peer != null) {
                        this.dropTarget.addNotify(this.peer);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException2) {}
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void setFont(Font font) {
        Component component = this;
        synchronized (component) {
            Font font2 = this.font;
            ComponentPeer componentPeer = this.peer;
            this.font = font;
            if (componentPeer != null && (font = this.getFont()) != null) {
                componentPeer.setFont(font);
                this.peerFont = font;
            }
            this.firePropertyChange("font", font2, this.font);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public void setForeground(Color color) {
        Color color2 = this.foreground;
        ComponentPeer componentPeer = this.peer;
        this.foreground = color;
        if (componentPeer != null && (color = this.getForeground()) != null) {
            componentPeer.setForeground(color);
        }
        this.firePropertyChange("foreground", color2, color);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.valid) {
            this.invalidate();
        }
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setName(String string) {
        Component component = this;
        synchronized (component) {
            this.name = string;
            this.nameExplicitlySet = true;
        }
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void setVisible(boolean bl) {
        this.show(bl);
    }

    public void show() {
        if (!this.visible) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.visible = true;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.show();
                    if (componentPeer instanceof LightweightPeer) {
                        this.repaint();
                    }
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 102);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public void update(Graphics graphics) {
        if (this instanceof Canvas || this instanceof Panel || this instanceof Frame || this instanceof Dialog || this instanceof Window) {
            graphics.clearRect(0, 0, this.width, this.height);
        }
        this.paint(graphics);
    }

    public void validate() {
        if (!this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Font font;
                Font font2;
                ComponentPeer componentPeer = this.peer;
                if (!(this.valid || componentPeer == null || (font2 = this.getFont()) == (font = this.peerFont) || font != null && font.equals(font2))) {
                    componentPeer.setFont(font2);
                    this.peerFont = font2;
                }
            }
            this.valid = true;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, componentListenerK, this.componentListener);
        AWTEventMulticaster.save(objectOutputStream, focusListenerK, this.focusListener);
        AWTEventMulticaster.save(objectOutputStream, keyListenerK, this.keyListener);
        AWTEventMulticaster.save(objectOutputStream, mouseListenerK, this.mouseListener);
        AWTEventMulticaster.save(objectOutputStream, mouseMotionListenerK, this.mouseMotionListener);
        AWTEventMulticaster.save(objectOutputStream, inputMethodListenerK, this.inputMethodListener);
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(this.componentOrientation);
    }

    static class AWTTreeLock {
        AWTTreeLock() {
        }
    }

    private final class NativeInLightFixer
    implements ComponentListener,
    ContainerListener {
        Vector lightParents = new Vector();
        Container nativeHost;

        NativeInLightFixer() {
            Container container = Component.this.parent;
            while (container.peer instanceof LightweightPeer) {
                container.addComponentListener(this);
                container.addContainerListener(this);
                this.lightParents.addElement(container);
                container = container.parent;
            }
            this.nativeHost = container;
            container.addContainerListener(this);
            this.componentMoved(null);
        }

        public void componentAdded(ContainerEvent containerEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (Component.this.visible) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.hide();
                    }
                }
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            Object object = Component.this.getTreeLock();
            synchronized (object) {
                int n = Component.this.x;
                int n2 = Component.this.y;
                Container container = Component.this.parent;
                while (container != null && container.peer instanceof LightweightPeer) {
                    n += container.x;
                    n2 += container.y;
                    container = container.parent;
                }
                if (Component.this.peer != null) {
                    Component.this.peer.setBounds(n, n2, Component.this.width, Component.this.height);
                }
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component == Component.this) {
                this.removeReferences();
            } else {
                int n = this.lightParents.size();
                int n2 = 0;
                while (n2 < n) {
                    Container container = (Container)this.lightParents.elementAt(n2);
                    if (container == component) {
                        this.removeReferences();
                        break;
                    }
                    ++n2;
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (Component.this.isShowing()) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.show();
                    }
                }
            }
        }

        void removeReferences() {
            int n = this.lightParents.size();
            int n2 = 0;
            while (n2 < n) {
                Container container = (Container)this.lightParents.elementAt(n2);
                container.removeComponentListener(this);
                container.removeContainerListener(this);
                ++n2;
            }
            this.nativeHost.removeContainerListener(this);
        }
    }
}

