/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ComponentPeer;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;

class LightweightDispatcher
implements Serializable,
AWTEventListener {
    private static final long serialVersionUID = 5184291520170872969L;
    private static final int LWD_MOUSE_DRAGGED_OVER = 2000;
    private Container nativeContainer;
    private Component focus;
    private transient Component mouseEventTarget;
    private transient Component cursorOn;
    private transient Component targetLastEntered;
    private transient boolean isMouseInNativeContainer = false;
    private transient boolean isClickOrphaned = false;
    private boolean dragging;
    private transient Cursor lightCursor;
    private Cursor nativeCursor;
    private long eventMask;
    private static final long PROXY_EVENT_MASK = 60L;
    private static final long MOUSE_MASK = 48L;

    LightweightDispatcher(Container container) {
        this.nativeContainer = container;
        this.focus = null;
        this.mouseEventTarget = null;
        this.eventMask = 0L;
    }

    boolean dispatchEvent(AWTEvent aWTEvent) {
        ComponentEvent componentEvent;
        boolean bl = false;
        if ((this.eventMask & 0x3CL) != 0L) {
            if (aWTEvent instanceof MouseEvent && (this.eventMask & 0x30L) != 0L) {
                componentEvent = (MouseEvent)aWTEvent;
                bl = this.processMouseEvent((MouseEvent)componentEvent);
            } else if (aWTEvent instanceof FocusEvent) {
                componentEvent = (FocusEvent)aWTEvent;
                bl = this.processFocusEvent((FocusEvent)componentEvent);
            } else if (aWTEvent instanceof KeyEvent) {
                componentEvent = (KeyEvent)aWTEvent;
                bl = this.processKeyEvent((KeyEvent)componentEvent);
            }
        }
        if (aWTEvent instanceof MouseEvent && (componentEvent = (MouseEvent)aWTEvent).getID() == 503) {
            this.cursorOn = this.nativeContainer.getCursorTarget(((MouseEvent)componentEvent).getX(), ((MouseEvent)componentEvent).getY());
            this.updateCursor(this.cursorOn);
        }
        return bl;
    }

    void dispose() {
        this.stopListeningForOtherDrags();
    }

    void enableEvents(long l) {
        this.eventMask |= l;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        boolean bl;
        boolean bl2 = bl = aWTEvent instanceof MouseEvent && aWTEvent.id == 506 && aWTEvent.getSource() != this.nativeContainer;
        if (!bl) {
            return;
        }
        MouseEvent mouseEvent2 = (MouseEvent)aWTEvent;
        Object object = this.nativeContainer.getTreeLock();
        synchronized (object) {
            Component component;
            block8: {
                block7: {
                    component = mouseEvent2.getComponent();
                    if (!component.isShowing()) break block7;
                    if (this.nativeContainer.isShowing()) break block8;
                }
                Object var6_6 = null;
                return;
            }
            mouseEvent = new MouseEvent(this.nativeContainer, 2000, mouseEvent2.getWhen(), mouseEvent2.getModifiers(), mouseEvent2.getX(), mouseEvent2.getY(), mouseEvent2.getClickCount(), mouseEvent2.isPopupTrigger());
            mouseEvent2.copyPrivateDataInto(mouseEvent);
            Point point = component.getLocationOnScreen();
            Point point2 = this.nativeContainer.getLocationOnScreen();
            mouseEvent.translatePoint(point.x - point2.x, point.y - point2.y);
        }
        object = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit((Component)object, mouseEvent);
    }

    Component getCursorOn() {
        return this.cursorOn;
    }

    private boolean processFocusEvent(FocusEvent focusEvent) {
        if (this.focus != null) {
            int n = focusEvent.getID();
            FocusEvent focusEvent2 = new FocusEvent(this.focus, n, focusEvent.isTemporary());
            focusEvent.copyPrivateDataInto(focusEvent2);
            this.focus.dispatchEvent(focusEvent2);
            if (n == 1005 && !focusEvent.isTemporary()) {
                this.focus = null;
            }
            return true;
        }
        return false;
    }

    private boolean processKeyEvent(KeyEvent keyEvent) {
        if (this.focus != null) {
            Component component = keyEvent.getComponent();
            keyEvent.setSource(this.focus);
            this.focus.dispatchEvent(keyEvent);
            keyEvent.setSource(component);
            return keyEvent.isConsumed();
        }
        return false;
    }

    private boolean processMouseEvent(MouseEvent mouseEvent) {
        Component component;
        int n = mouseEvent.getID();
        Component component2 = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit(component2, mouseEvent);
        if (this.mouseEventTarget == null && (n == 503 || n == 501)) {
            component = component2 != this.nativeContainer ? component2 : null;
            this.setMouseTarget(component, mouseEvent);
        }
        if (this.mouseEventTarget != null) {
            switch (n) {
                case 506: {
                    if (!this.dragging) break;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
                case 501: {
                    this.dragging = true;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
                case 502: {
                    Component component3 = this.mouseEventTarget;
                    this.dragging = false;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), false);
                    this.setMouseTarget(component, mouseEvent);
                    this.isClickOrphaned = component != component3;
                    break;
                }
                case 500: {
                    if (!this.isClickOrphaned) {
                        this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    }
                    this.isClickOrphaned = false;
                    break;
                }
                case 505: {
                    if (this.dragging) break;
                    this.setMouseTarget(null, mouseEvent);
                    break;
                }
                case 503: {
                    component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), false);
                    this.setMouseTarget(component, mouseEvent);
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
            }
            mouseEvent.consume();
        }
        return mouseEvent.isConsumed();
    }

    void retargetMouseEvent(Component component, int n, MouseEvent mouseEvent) {
        if (component == null) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Component component2 = component;
        while (component2 != null && component2 != this.nativeContainer) {
            n2 -= component2.x;
            n3 -= component2.y;
            component2 = component2.getParent();
        }
        if (component2 != null) {
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            mouseEvent.copyPrivateDataInto(mouseEvent2);
            if (component == this.nativeContainer) {
                ((Container)component).dispatchEventToSelf(mouseEvent2);
            } else {
                component.dispatchEvent(mouseEvent2);
            }
        }
    }

    boolean setFocusRequest(Component component) {
        boolean bl = true;
        Window window = this.nativeContainer.getWindow();
        if (window != null && component != null) {
            Component component2 = window.getFocusOwner();
            if (component2 == null) {
                this.focus = component;
            } else if (component2 == this.nativeContainer) {
                this.nativeContainer.dispatchEvent(new FocusEvent(this.nativeContainer, 1005, false));
                this.focus = component;
                component.dispatchEvent(new FocusEvent(component, 1004, false));
                bl = false;
            } else if (component2 == component) {
                this.focus = component;
                bl = false;
            } else if (component2 == this.focus) {
                if (this.focus != null) {
                    this.focus.dispatchEvent(new FocusEvent(this.focus, 1005, false));
                }
                this.focus = component;
                component.dispatchEvent(new FocusEvent(component, 1004, false));
                bl = false;
            } else {
                this.focus = component;
            }
        }
        return bl;
    }

    private void setMouseTarget(Component component, MouseEvent mouseEvent) {
        if (component != this.mouseEventTarget) {
            this.mouseEventTarget = component;
        }
    }

    private void startListeningForOtherDrags() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LightweightDispatcher.this.nativeContainer.getToolkit().addAWTEventListener(LightweightDispatcher.this, 48L);
                return null;
            }
        });
    }

    private void stopListeningForOtherDrags() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LightweightDispatcher.this.nativeContainer.getToolkit().removeAWTEventListener(LightweightDispatcher.this);
                return null;
            }
        });
    }

    private void trackMouseEnterExit(Component component, MouseEvent mouseEvent) {
        Component component2 = null;
        int n = mouseEvent.getID();
        if (n != 505 && n != 506 && n != 2000 && !this.isMouseInNativeContainer) {
            this.isMouseInNativeContainer = true;
            this.startListeningForOtherDrags();
        } else if (n == 505) {
            this.isMouseInNativeContainer = false;
            this.stopListeningForOtherDrags();
        }
        if (this.isMouseInNativeContainer) {
            component2 = component;
        }
        if (this.targetLastEntered == component2) {
            return;
        }
        this.retargetMouseEvent(this.targetLastEntered, 505, mouseEvent);
        if (n == 505) {
            mouseEvent.consume();
        }
        this.retargetMouseEvent(component2, 504, mouseEvent);
        if (n == 504) {
            mouseEvent.consume();
        }
        this.targetLastEntered = component2;
    }

    void updateCursor(Component component) {
        if (component != this.cursorOn) {
            return;
        }
        if (component == null) {
            component = this.nativeContainer;
        }
        Cursor cursor = component.getIntrinsicCursor();
        while (cursor == null && component != this.nativeContainer) {
            if ((component = component.getParent()) == null) {
                cursor = this.nativeContainer.getCursor();
                break;
            }
            cursor = component.getIntrinsicCursor();
        }
        if (cursor != this.lightCursor) {
            this.lightCursor = cursor;
            ComponentPeer componentPeer = this.nativeContainer.getPeer();
            if (componentPeer != null) {
                componentPeer.setCursor(cursor);
            }
        }
    }
}

