/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import java.text.CharacterIterator;

public final class LineBreakMeasurer {
    private AttributedCharacterIterator text;
    private BreakIterator breakIter;
    private int pos;
    private int limit;
    private TextMeasurer measurer;

    public LineBreakMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this(attributedCharacterIterator, BreakIterator.getLineInstance(), fontRenderContext);
    }

    public LineBreakMeasurer(AttributedCharacterIterator attributedCharacterIterator, BreakIterator breakIterator, FontRenderContext fontRenderContext) {
        this.text = attributedCharacterIterator;
        this.breakIter = breakIterator;
        this.breakIter.setText((CharacterIterator)attributedCharacterIterator.clone());
        this.measurer = new TextMeasurer(attributedCharacterIterator, fontRenderContext);
        this.limit = attributedCharacterIterator.getEndIndex();
        this.pos = attributedCharacterIterator.getBeginIndex();
        attributedCharacterIterator.setIndex(this.pos);
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.text = attributedCharacterIterator;
        this.breakIter.setText((CharacterIterator)this.text.clone());
        this.limit = this.text.getEndIndex();
        this.pos = this.text.getBeginIndex();
        this.measurer.deleteChar(attributedCharacterIterator, n);
    }

    public int getPosition() {
        return this.pos;
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.text = attributedCharacterIterator;
        this.breakIter.setText((CharacterIterator)this.text.clone());
        this.limit = this.text.getEndIndex();
        this.pos = this.text.getBeginIndex();
        this.measurer.insertChar(attributedCharacterIterator, n);
    }

    public TextLayout nextLayout(float f) {
        return this.nextLayout(f, this.limit, false);
    }

    public TextLayout nextLayout(float f, int n, boolean bl) {
        if (this.pos < this.text.getEndIndex()) {
            int n2 = this.nextOffset(f, n, bl);
            if (n2 == this.pos) {
                return null;
            }
            TextLayout textLayout = this.measurer.getLayout(this.pos, n2);
            this.pos = n2;
            return textLayout;
        }
        return null;
    }

    public int nextOffset(float f) {
        return this.nextOffset(f, this.limit, false);
    }

    public int nextOffset(float f, int n, boolean bl) {
        int n2 = this.pos;
        if (this.pos < this.limit) {
            if (n <= this.pos) {
                throw new IllegalArgumentException("offsetLimit must be after current position");
            }
            int n3 = this.measurer.getLineBreakIndex(this.pos, f);
            this.text.setIndex(n3);
            if (n3 == this.limit) {
                n2 = this.limit;
            } else if (Character.isWhitespace(this.text.current())) {
                n2 = this.breakIter.following(n3);
            } else {
                this.breakIter.following(n3);
                n2 = this.breakIter.previous();
                if (n2 <= this.pos) {
                    n2 = bl ? this.pos : Math.max(this.pos + 1, n3);
                }
            }
        }
        if (n2 > n) {
            n2 = n;
        }
        return n2;
    }

    public void setPosition(int n) {
        if (n < this.text.getBeginIndex() || n > this.limit) {
            throw new IllegalArgumentException("position is out of range");
        }
        this.pos = n;
    }
}

