/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

class EllipseIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    AffineTransform affine;
    int index;
    private static final double angle = 0.7853981633974483;
    private static final double a = 1.0 - Math.cos(0.7853981633974483);
    private static final double b = Math.tan(0.7853981633974483);
    private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
    private static final double cv = 1.3333333333333333 * a * b / c;
    private static double[][] ctrlpts;

    static {
        double[][] dArrayArray = new double[4][];
        double[] dArray = new double[6];
        dArray[0] = 1.0;
        dArray[1] = cv;
        dArray[2] = cv;
        dArray[3] = 1.0;
        dArray[5] = 1.0;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[6];
        dArray2[0] = -cv;
        dArray2[1] = 1.0;
        dArray2[2] = -1.0;
        dArray2[3] = cv;
        dArray2[4] = -1.0;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[6];
        dArray3[0] = -1.0;
        dArray3[1] = -cv;
        dArray3[2] = -cv;
        dArray3[3] = -1.0;
        dArray3[5] = -1.0;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[6];
        dArray4[0] = cv;
        dArray4[1] = -1.0;
        dArray4[2] = 1.0;
        dArray4[3] = -cv;
        dArray4[4] = 1.0;
        dArrayArray[3] = dArray4;
        ctrlpts = dArrayArray;
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 6) {
                EllipseIterator.ctrlpts[n][n2] = ctrlpts[n][n2] * 0.5 + 0.5;
                ++n2;
            }
            ++n;
        }
    }

    EllipseIterator(Ellipse2D ellipse2D, AffineTransform affineTransform) {
        this.x = ellipse2D.getX();
        this.y = ellipse2D.getY();
        this.w = ellipse2D.getWidth();
        this.h = ellipse2D.getHeight();
        this.affine = affineTransform;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index = 6;
        }
    }

    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("ellipse iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        if (this.index == 0) {
            double[] dArray2 = ctrlpts[3];
            dArray[0] = this.x + dArray2[4] * this.w;
            dArray[1] = this.y + dArray2[5] * this.h;
            if (this.affine != null) {
                this.affine.transform(dArray, 0, dArray, 0, 1);
            }
            return 0;
        }
        double[] dArray3 = ctrlpts[this.index - 1];
        dArray[0] = this.x + dArray3[0] * this.w;
        dArray[1] = this.y + dArray3[1] * this.h;
        dArray[2] = this.x + dArray3[2] * this.w;
        dArray[3] = this.y + dArray3[3] * this.h;
        dArray[4] = this.x + dArray3[4] * this.w;
        dArray[5] = this.y + dArray3[5] * this.h;
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, 3);
        }
        return 3;
    }

    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("ellipse iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        if (this.index == 0) {
            double[] dArray = ctrlpts[3];
            fArray[0] = (float)(this.x + dArray[4] * this.w);
            fArray[1] = (float)(this.y + dArray[5] * this.h);
            if (this.affine != null) {
                this.affine.transform(fArray, 0, fArray, 0, 1);
            }
            return 0;
        }
        double[] dArray = ctrlpts[this.index - 1];
        fArray[0] = (float)(this.x + dArray[0] * this.w);
        fArray[1] = (float)(this.y + dArray[1] * this.h);
        fArray[2] = (float)(this.x + dArray[2] * this.w);
        fArray[3] = (float)(this.y + dArray[3] * this.h);
        fArray[4] = (float)(this.x + dArray[4] * this.w);
        fArray[5] = (float)(this.y + dArray[5] * this.h);
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, 3);
        }
        return 3;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index > 5;
    }

    public void next() {
        ++this.index;
    }
}

