/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.util.Enumeration;
import java.util.Hashtable;

public class FeatureDescriptor {
    private boolean expert;
    private boolean hidden;
    private boolean preferred;
    private String shortDescription;
    private String name;
    private String displayName;
    private Hashtable table;

    public FeatureDescriptor() {
    }

    FeatureDescriptor(FeatureDescriptor featureDescriptor) {
        this.expert = featureDescriptor.expert;
        this.hidden = featureDescriptor.hidden;
        this.name = featureDescriptor.name;
        this.shortDescription = featureDescriptor.shortDescription;
        this.displayName = featureDescriptor.displayName;
        this.addTable(featureDescriptor.table);
    }

    FeatureDescriptor(FeatureDescriptor featureDescriptor, FeatureDescriptor featureDescriptor2) {
        this.expert = featureDescriptor.expert | featureDescriptor2.expert;
        this.hidden = featureDescriptor.hidden | featureDescriptor2.hidden;
        this.name = featureDescriptor2.name;
        this.shortDescription = featureDescriptor.shortDescription;
        if (featureDescriptor2.shortDescription != null) {
            this.shortDescription = featureDescriptor2.shortDescription;
        }
        this.displayName = featureDescriptor.displayName;
        if (featureDescriptor2.displayName != null) {
            this.displayName = featureDescriptor2.displayName;
        }
        this.addTable(featureDescriptor.table);
        this.addTable(featureDescriptor2.table);
    }

    private void addTable(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = hashtable.get(string);
            this.setValue(string, object);
        }
    }

    public Enumeration attributeNames() {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        return this.table.keys();
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getName();
        }
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            return this.getDisplayName();
        }
        return this.shortDescription;
    }

    public Object getValue(String string) {
        if (this.table == null) {
            return null;
        }
        return this.table.get(string);
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setExpert(boolean bl) {
        this.expert = bl;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPreferred(boolean bl) {
        this.preferred = bl;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    public void setValue(String string, Object object) {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        this.table.put(string, object);
    }
}

