/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class Finalizer
extends FinalReference {
    private static ReferenceQueue queue;
    private static Finalizer unfinalized;
    private static Object lock;
    private Finalizer next = null;
    private Finalizer prev = null;
    private static boolean runOnExit;

    static {
        ThreadGroup threadGroup;
        queue = new ReferenceQueue();
        unfinalized = null;
        lock = new Object();
        runOnExit = false;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        FinalizerThread finalizerThread = new FinalizerThread(threadGroup);
        finalizerThread.setPriority(8);
        finalizerThread.setDaemon(true);
        finalizerThread.start();
    }

    private Finalizer(Object object) {
        super(object, queue);
        this.add();
    }

    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
        }
    }

    private static void forkSecondaryFinalizer(final Runnable runnable) {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                Thread thread = new Thread(threadGroup, runnable, "Secondary finalizer");
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    static native void invokeFinalizeMethod(Object var0) throws Throwable;

    static void register(Object object) {
        new Finalizer(object);
    }

    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
        }
    }

    static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            public void run() {
                Finalizer finalizer;
                while ((finalizer = (Finalizer)queue.poll()) != null) {
                    finalizer.runFinalizer();
                }
            }
        });
    }

    private void runFinalizer() {
        Object object = this;
        synchronized (object) {
            if (this.hasBeenFinalized()) {
                Object var2_2 = null;
                return;
            }
            this.remove();
        }
        try {
            object = this.get();
            if (object != null) {
                Finalizer.invokeFinalizeMethod(object);
                object = null;
            }
        }
        catch (Throwable throwable) {}
        super.clear();
    }

    static void runFinalizersOnExit() {
        if (!runOnExit) {
            return;
        }
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            public void run() {
                while (true) {
                    Finalizer finalizer;
                    Object object = lock;
                    synchronized (object) {
                        finalizer = unfinalized;
                        if (finalizer == null) {
                            Object var3_3 = null;
                            break;
                        }
                        unfinalized = finalizer.next;
                    }
                    finalizer.runFinalizer();
                }
            }
        });
    }

    static void setRunFinalizersOnExit(boolean bl) {
        runOnExit = bl;
    }

    private static class FinalizerThread
    extends Thread {
        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Finalizer finalizer = (Finalizer)queue.remove();
                        finalizer.runFinalizer();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

