/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import javax.swing.text.Ligaturizer;

class CharBasedLigaturizer
extends Ligaturizer {
    private char[] data;
    private Ligaturizer.Filter filter;
    private static final int[] exp2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    private static final int[] pows = new int[256];

    static {
        int n = 0;
        int n2 = 1;
        while (n2 < pows.length) {
            if (n2 >= exp2[n]) {
                ++n;
            }
            CharBasedLigaturizer.pows[n2] = n - 1;
            ++n2;
        }
    }

    CharBasedLigaturizer(char[] cArray) {
        this.data = cArray;
        this.filter = null;
    }

    CharBasedLigaturizer(char[] cArray, Ligaturizer.Filter filter) {
        char[] cArray2 = (char[])cArray.clone();
        int n = CharBasedLigaturizer.recursiveRestrict(0, cArray2, filter);
        if (2 * n < cArray2.length) {
            cArray2 = CharBasedLigaturizer.compress(cArray2);
        }
        this.data = cArray2;
        this.filter = filter;
    }

    private static char[] compress(char[] cArray) {
        int n = CharBasedLigaturizer.recursiveCompress(cArray, 0, 0);
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    private static boolean isCombiningMark(char c) {
        return (448 >> Character.getType(c) & 1) != 0;
    }

    void ligaturize(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[50];
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = n3;
            int n6 = 0;
            int n7 = -1;
            do {
                char c;
                int n8;
                if ((n8 = this.subnode(n6, c = cArray[n5])) != -1) {
                    n6 = n8;
                    cArray2[n5 - n3] = 65535;
                    c = this.data[n6 + 1];
                    if (c == '\uffff') continue;
                    cArray2[0] = c;
                    n7 = n5;
                    continue;
                }
                if (!CharBasedLigaturizer.isCombiningMark(c)) break;
                cArray2[n5 - n3] = c;
            } while (++n5 < n4);
            if (n7 != -1) {
                System.arraycopy(cArray2, 0, cArray, n3, n7 - n3 + 1);
                n3 = n7;
            }
            ++n3;
        }
    }

    private static int recursiveCompress(char[] cArray, int n, int n2) {
        cArray[n2] = cArray[n];
        cArray[++n2] = cArray[++n];
        int n3 = cArray[++n];
        cArray[++n2] = (char)n3;
        int n4 = n2;
        n2 += n3 + '\u0001';
        while (--n3 >= 0) {
            char c = cArray[++n];
            cArray[++n4] = (char)n2;
            n2 = CharBasedLigaturizer.recursiveCompress(cArray, c, n2);
        }
        return n2;
    }

    private static int recursiveRestrict(int n, char[] cArray, Ligaturizer.Filter filter) {
        char c;
        int n2 = 0;
        int n3 = 0;
        int n4 = cArray[n + 2];
        int n5 = 0;
        while (n5 < n4) {
            c = cArray[n + 3 + n5];
            int n6 = CharBasedLigaturizer.recursiveRestrict(c, cArray, filter);
            if (n6 != 0) {
                cArray[n + 3 + n3] = c;
                ++n3;
                n2 += n6;
            }
            ++n5;
        }
        n2 += n3;
        cArray[n + 2] = (char)n3;
        c = cArray[n + 1];
        if (c != '\uffff') {
            if (filter.accepts(c)) {
                n2 += 3;
            } else {
                cArray[n + 1] = 65535;
                if (n3 > 0) {
                    n2 += 3;
                }
            }
        }
        return n2;
    }

    Ligaturizer restrict(Ligaturizer.Filter filter) {
        if (!filter.equals(this.filter)) {
            return new CharBasedLigaturizer(this.data, filter);
        }
        return this;
    }

    private int subnode(int n, char c) {
        int n2;
        int n3;
        char c2 = this.data[n + 2];
        if (c2 == '\u0000') {
            return -1;
        }
        int n4 = n + 3;
        if (c2 == '\u0001') {
            n3 = n4;
        } else {
            n2 = pows[c2];
            int n5 = c2 - exp2[n2];
            n3 = exp2[n2] - 1 + n4;
            if (c >= this.data[this.data[n4 + n5]]) {
                n3 += n5;
            }
            switch (n2) {
                case 8: {
                    if (c < this.data[this.data[n3 - 128]]) {
                        n3 -= 128;
                    }
                }
                case 7: {
                    if (c < this.data[this.data[n3 - 64]]) {
                        n3 -= 64;
                    }
                }
                case 6: {
                    if (c < this.data[this.data[n3 - 32]]) {
                        n3 -= 32;
                    }
                }
                case 5: {
                    if (c < this.data[this.data[n3 - 16]]) {
                        n3 -= 16;
                    }
                }
                case 4: {
                    if (c < this.data[this.data[n3 - 8]]) {
                        n3 -= 8;
                    }
                }
                case 3: {
                    if (c < this.data[this.data[n3 - 4]]) {
                        n3 -= 4;
                    }
                }
                case 2: {
                    if (c < this.data[this.data[n3 - 2]]) {
                        n3 -= 2;
                    }
                }
                case 1: {
                    if (c < this.data[this.data[n3 - 1]]) {
                        --n3;
                    }
                }
                case 0: {
                    if (c >= this.data[this.data[n3]]) break;
                    --n3;
                }
            }
        }
        n2 = this.data[n3];
        if (c == this.data[n2]) {
            return n2;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[filter: ");
        stringBuffer.append(this.filter);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

