/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import sun.awt.ScreenUpdater;
import sun.awt.SunToolkit;
import sun.awt.UpdateClient;
import sun.awt.image.OffScreenImage;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WGraphics;
import sun.awt.windows.WImage;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WPrintGraphicsWrapper;
import sun.awt.windows.WToolkit;

abstract class WComponentPeer
extends WObjectPeer
implements ComponentPeer,
UpdateClient,
DropTargetPeer {
    private boolean repaintPending;
    private Rectangle repaintRect;
    int nDropTargets;
    int nativeDropTargetContext;
    public int serialNum = 0;
    private int updateX1;
    private int updateY1;
    private int updateX2;
    private int updateY2;

    WComponentPeer(Component component) {
        this.target = component;
        this.repaintRect = new Rectangle();
        this.repaintPending = false;
        Container container = SunToolkit.getNativeContainer(component);
        WComponentPeer wComponentPeer = (WComponentPeer)WToolkit.targetToPeer(container);
        this.create(wComponentPeer);
        this.initialize();
        this.start();
    }

    public native void _beginValidate();

    private synchronized native void _dispose();

    public native void _setBackground(int var1);

    public native void _setForeground(int var1);

    public synchronized void addDropTarget(DropTarget dropTarget) {
        if (this.nDropTargets == 0) {
            this.nativeDropTargetContext = this.addNativeDropTarget();
        }
        ++this.nDropTargets;
    }

    native int addNativeDropTarget();

    private synchronized void addRepaintArea(int n, int n2, int n3, int n4) {
        if (!this.repaintPending) {
            this.repaintPending = true;
            this.repaintRect = new Rectangle(n, n2, n3, n4);
        } else {
            this.repaintRect = this.repaintRect.union(new Rectangle(n, n2, n3, n4));
        }
    }

    public void beginValidate() {
        this._beginValidate();
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    void clearRectBeforePaint(Graphics graphics, Rectangle rectangle) {
        graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    abstract void create(WComponentPeer var1);

    public Image createImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        return new OffScreenImage((Component)this.target, colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied());
    }

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    public synchronized native void disable();

    protected void disposeImpl() {
        ScreenUpdater.updater.removeClient(this);
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public synchronized native void enable();

    public native void endValidate();

    public ColorModel getColorModel() {
        return WToolkit.config.getColorModel();
    }

    public ColorModel getColorModel(int n) {
        return WToolkit.config.getColorModel(n);
    }

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    public synchronized Graphics getGraphics() {
        if (!this.isDisposed()) {
            WGraphics wGraphics = new WGraphics(this);
            ((Graphics)wGraphics).setColor(((Component)this.target).getForeground());
            ((Graphics)wGraphics).setFont(((Component)this.target).getFont());
            return wGraphics;
        }
        return null;
    }

    public native Point getLocationOnScreen();

    public Dimension getMinimumSize() {
        return ((Component)this.target).getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 800: 
            case 801: {
                Rectangle rectangle = ((PaintEvent)aWTEvent).getUpdateRect();
                Graphics graphics = ((Component)this.target).getGraphics();
                if (graphics == null) {
                    return;
                }
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (n == 800) {
                    this.clearRectBeforePaint(graphics, rectangle);
                    ((Component)this.target).paint(graphics);
                } else {
                    ((Component)this.target).update(graphics);
                }
                graphics.dispose();
                return;
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    void handleExpose(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle(n, n2, n3, n4)));
    }

    void handlePaint(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle(n, n2, n3, n4)));
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
    }

    public synchronized native void hide();

    public native void initCursor();

    public void initZOrderPosition() {
        Container container = ((Component)this.target).getParent();
        WComponentPeer wComponentPeer = null;
        if (container != null) {
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] == this.target) break;
                Object object = WToolkit.targetToPeer(componentArray[n]);
                if (object != null && !(object instanceof LightweightPeer)) {
                    wComponentPeer = (WComponentPeer)object;
                }
                ++n;
            }
        }
        this.setZOrderPosition(wComponentPeer);
    }

    void initialize() {
        Font font;
        Color color;
        this.initZOrderPosition();
        if (((Component)this.target).isVisible()) {
            this.show();
        }
        if ((color = ((Component)this.target).getForeground()) != null) {
            this.setForeground(color);
        }
        if ((font = ((Component)this.target).getFont()) != null) {
            this.setFont(font);
        }
        if (!((Component)this.target).isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = ((Component)this.target).getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.initCursor();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    native void nativeHandleEvent(AWTEvent var1);

    public void paint(Graphics graphics) {
        graphics.setColor(((Component)this.target).getForeground());
        graphics.setFont(((Component)this.target).getFont());
        ((Component)this.target).paint(graphics);
    }

    void postEvent(AWTEvent aWTEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(this.target), aWTEvent);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public void print(Graphics graphics) {
        ((Component)this.target).print(graphics);
        WGraphics wGraphics = graphics instanceof WGraphics ? (WGraphics)graphics : (WGraphics)((WPrintGraphicsWrapper)graphics).getTarget();
        wGraphics.print(this);
    }

    public synchronized void removeDropTarget(DropTarget dropTarget) {
        if (this.nDropTargets-- == 0) {
            this.removeNativeDropTarget();
            this.nativeDropTargetContext = 0;
        }
    }

    native void removeNativeDropTarget();

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.addRepaintArea(n, n2, n3, n4);
        ScreenUpdater.updater.notify(this, l);
    }

    public synchronized native void requestFocus();

    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    public synchronized void setBackground(Color color) {
        this._setBackground(color.getRGB());
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
        ++this.serialNum;
    }

    public synchronized native void setCursor(Cursor var1);

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public synchronized native void setFont(Font var1);

    public synchronized void setForeground(Color color) {
        this._setForeground(color.getRGB());
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    native void setZOrderPosition(WComponentPeer var1);

    public synchronized native void show();

    synchronized native void start();

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.target + "]";
    }

    public void updateClient(Object object) {
        Rectangle rectangle = null;
        WComponentPeer wComponentPeer = this;
        synchronized (wComponentPeer) {
            if (this.repaintPending) {
                rectangle = this.repaintRect;
                this.repaintPending = false;
            }
        }
        if (rectangle != null) {
            this.postEvent(new PaintEvent((Component)this.target, 801, rectangle));
        }
    }
}

