/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralNamesException;
import sun.security.x509.PKIXExtensions;

public class SubjectAlternativeNameExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.SubjectAlternativeName";
    public static final String NAME = "SubjectAlternativeName";
    public static final String SUBJECT_NAME = "subject_name";
    GeneralNames names = null;

    public SubjectAlternativeNameExtension() {
        this.extensionId = PKIXExtensions.SubjectAlternativeName_Id;
        this.critical = false;
        this.names = new GeneralNames();
    }

    public SubjectAlternativeNameExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.SubjectAlternativeName_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new IOException("SubjectAlternativeName: Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        try {
            this.names = new GeneralNames(derValue);
        }
        catch (GeneralNamesException generalNamesException) {
            throw new IOException("SubjectAlternativeName: " + generalNamesException);
        }
    }

    public SubjectAlternativeNameExtension(GeneralNames generalNames) throws IOException {
        this.names = generalNames;
        this.extensionId = PKIXExtensions.SubjectAlternativeName_Id;
        this.critical = false;
        this.encodeThis();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(SUBJECT_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
        }
        this.names = null;
        this.encodeThis();
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectAlternativeName_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    private void encodeThis() throws IOException {
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.names.encode(derOutputStream);
        }
        catch (GeneralNamesException generalNamesException) {
            throw new IOException("SubjectAlternativeName: " + generalNamesException);
        }
        this.extensionValue = derOutputStream.toByteArray();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(SUBJECT_NAME)) {
            return this.names;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(SUBJECT_NAME);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(SUBJECT_NAME)) {
            if (!(object instanceof GeneralNames)) {
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
        }
        this.names = (GeneralNames)object;
        this.encodeThis();
    }

    public String toString() {
        if (this.names == null) {
            return "";
        }
        String string = String.valueOf(super.toString()) + "SubjectAlternativeName [\n" + this.names.toString() + "]\n";
        return string;
    }
}

