/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.ole.event;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import sun.beans.ole.event.EncapsulatedEvent;
import sun.beans.ole.event.EncapsulatedEventAdaptorGenerator;
import sun.beans.ole.event.EncapsulatedEventException;
import sun.beans.ole.event.EncapsulatedEventInformation;
import sun.beans.ole.event.EncapsulatedEventListener;

public abstract class EncapsulatedEventAdaptor {
    protected EncapsulatedEventInformation eei;
    protected Object source;
    protected Vector listeners = new Vector(0, 1);
    private static Hashtable cache = new Hashtable();
    static /* synthetic */ Class class$java$util$EventListener;

    public static EncapsulatedEventAdaptor getEncapsulatedEventAdaptor(EncapsulatedEventInformation encapsulatedEventInformation, Object object) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IntrospectionException {
        Class clazz = null;
        EncapsulatedEventAdaptor encapsulatedEventAdaptor = null;
        clazz = (Class)cache.get(encapsulatedEventInformation.getListenerType().getName());
        if (clazz == null) {
            clazz = EncapsulatedEventAdaptor.getEncapsulatedEventAdaptorClass(encapsulatedEventInformation.getListenerType());
            cache.put(encapsulatedEventInformation.getListenerType().getName(), clazz);
        }
        encapsulatedEventAdaptor = (EncapsulatedEventAdaptor)clazz.newInstance();
        encapsulatedEventAdaptor.setEventInformation(encapsulatedEventInformation);
        encapsulatedEventAdaptor.source = object;
        return encapsulatedEventAdaptor;
    }

    public static Class getEncapsulatedEventAdaptorClass(Class clazz) throws ClassNotFoundException {
        if (!(class$java$util$EventListener != null ? class$java$util$EventListener : (class$java$util$EventListener = EncapsulatedEventAdaptor.class$("java.util.EventListener"))).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class is not a subinterface of java.util.EventListenerEventListener");
        }
        return EncapsulatedEventAdaptorGenerator.getAdaptorClassForListenerClass(clazz);
    }

    protected EncapsulatedEventAdaptor() {
    }

    public abstract Class getListenerClass();

    public void setEventInformation(EncapsulatedEventInformation encapsulatedEventInformation) {
        this.eei = encapsulatedEventInformation;
    }

    public String getListenerClassName() {
        return this.getListenerClass().getName();
    }

    public synchronized Object getSource() {
        return this.source;
    }

    public void addEncapsulatedEventListener(EncapsulatedEventListener encapsulatedEventListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(encapsulatedEventListener)) {
                this.listeners.addElement(encapsulatedEventListener);
            }
            return;
        }
    }

    public void removeEncapsulatedEventListener(EncapsulatedEventListener encapsulatedEventListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(encapsulatedEventListener)) {
                this.listeners.removeElement(encapsulatedEventListener);
            }
            return;
        }
    }

    public int getEncapsulatedListenerCount() {
        int n;
        Vector vector = this.listeners;
        synchronized (vector) {
            n = this.listeners.size();
        }
        return n;
    }

    public Vector getEncapsulatedListeners() {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        return vector;
    }

    protected void fire(EventObject eventObject, Method method) throws Exception {
        Vector vector = null;
        EncapsulatedEvent encapsulatedEvent = new EncapsulatedEvent(eventObject, method);
        EncapsulatedEventListener encapsulatedEventListener = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            try {
                encapsulatedEventListener = (EncapsulatedEventListener)vector.elementAt(n);
                encapsulatedEventListener.encapsulatedEvent(encapsulatedEvent);
            }
            catch (EncapsulatedEventException encapsulatedEventException) {
                this.handleEncapsulatedEventException(encapsulatedEventException, encapsulatedEventListener, method);
            }
            ++n;
        }
    }

    protected void fire(Object[] objectArray, Method method) throws Exception {
        Vector vector = null;
        EncapsulatedEvent encapsulatedEvent = new EncapsulatedEvent(this.source, method, objectArray);
        EncapsulatedEventListener encapsulatedEventListener = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            try {
                encapsulatedEventListener = (EncapsulatedEventListener)vector.elementAt(n);
                encapsulatedEventListener.encapsulatedEvent(encapsulatedEvent);
            }
            catch (EncapsulatedEventException encapsulatedEventException) {
                this.handleEncapsulatedEventException(encapsulatedEventException, encapsulatedEventListener, method);
            }
            ++n;
        }
    }

    protected final void handleEncapsulatedEventException(EncapsulatedEventException encapsulatedEventException, EncapsulatedEventListener encapsulatedEventListener, Method method) throws Exception {
        Class clazz = encapsulatedEventException.getExceptionClass();
        Class<?>[] classArray = method.getExceptionTypes();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].isAssignableFrom(clazz)) {
                throw encapsulatedEventException.getException();
            }
            ++n;
        }
        throw new RuntimeException("Event Source [" + this.source + "] is not prepared to catch [" + encapsulatedEventException.getException() + "] from listener [" + encapsulatedEventListener);
    }

    protected void addAdaptorToSource() {
        try {
            Object[] objectArray = new Object[]{this};
            this.eei.getAddListenerMethod().invoke(this.source, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("cannot add adaptor [" + this + "] to source [" + this.source + "] InvocationTargetException: " + invocationTargetException.getMessage());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("cannot add adaptor [" + this + "] to source [" + this.source + "] IllegalAccessException: " + illegalAccessException.getMessage());
            return;
        }
    }

    protected void removeAdaptorFromSource() {
        try {
            Object[] objectArray = new Object[]{this};
            this.eei.getRemoveListenerMethod().invoke(this.source, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("cannot remove adaptor [" + this + "] from source [" + this.source + "] InvocationTargetException: " + invocationTargetException.getMessage());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("cannot remove adaptor [" + this + "] from source [" + this.source + "] IllegalAccessException: " + illegalAccessException.getMessage());
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

