/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.ole.event;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import sunw.demo.classfile.EncapsulatedEventAdaptorClassFile;

public final class EncapsulatedEventAdaptorGenerator
extends ClassLoader {
    private static String packagePrefix = "sunw.demo.encapsulatedEvents";
    private static String adaptorInfix = ".DYN_EE_ADAPTOR.";
    private static String adaptorClassNamePrefix = String.valueOf(packagePrefix) + adaptorInfix;
    private ClassLoader delegateLoader;
    private static EncapsulatedEventAdaptorGenerator generator = new EncapsulatedEventAdaptorGenerator();

    private boolean debug() {
        return false;
    }

    private EncapsulatedEventAdaptorGenerator() {
    }

    private static Class loadClassNamed(ClassLoader classLoader, String string) throws ClassNotFoundException {
        EncapsulatedEventAdaptorGenerator.generator.delegateLoader = classLoader;
        return generator.loadClass(string);
    }

    static Class getAdaptorClassForListenerClass(Class clazz) throws ClassNotFoundException {
        return EncapsulatedEventAdaptorGenerator.loadClassNamed(clazz.getClassLoader(), EncapsulatedEventAdaptorGenerator.mapListenerNameToAdaptorName(clazz.getName()));
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (this.debug()) {
            System.err.println("loadClass(" + string + ")");
        }
        if (clazz == null) {
            if (EncapsulatedEventAdaptorGenerator.isAdaptorClassName(string)) {
                clazz = this.generateAdaptorClass(string);
            } else {
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    if (classLoader != null) {
                        clazz = classLoader.loadClass(string);
                    }
                    if (clazz == null && this.delegateLoader != null) {
                        clazz = this.delegateLoader.loadClass(string);
                    }
                    if (clazz == null) {
                        clazz = this.findSystemClass(string);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new ClassNotFoundException(noClassDefFoundError.getMessage());
                }
            }
        }
        if (clazz != null) {
            if (bl) {
                this.resolveClass(clazz);
            }
        } else {
            throw new ClassNotFoundException(string);
        }
        if (this.debug()) {
            System.err.println("loaded: " + clazz.getName());
        }
        return clazz;
    }

    private static String mapListenerNameToAdaptorName(String string) {
        return String.valueOf(adaptorClassNamePrefix) + string;
    }

    private static boolean isAdaptorClassName(String string) {
        return string.startsWith(adaptorClassNamePrefix);
    }

    public static String getBaseNameFromAdaptorName(String string) {
        if (string != null && EncapsulatedEventAdaptorGenerator.isAdaptorClassName(string)) {
            return string.substring(adaptorClassNamePrefix.length());
        }
        return null;
    }

    private Class generateAdaptorClass(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        byte[] byArray = null;
        Class<?> clazz = null;
        if (this.debug()) {
            System.err.println("generateAdaptorClass(" + string + ")");
        }
        try {
            Class<?> clazz2 = this.delegateLoader != null ? this.delegateLoader.loadClass(EncapsulatedEventAdaptorGenerator.getBaseNameFromAdaptorName(string)) : Class.forName(EncapsulatedEventAdaptorGenerator.getBaseNameFromAdaptorName(string));
            new EncapsulatedEventAdaptorClassFile(string, clazz2, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        byArray = byteArrayOutputStream.toByteArray();
        try {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (ClassFormatError classFormatError) {
            System.err.println("Failed to define adaptor for " + string);
            System.err.println("Caught: " + classFormatError);
            classFormatError.printStackTrace();
        }
        return clazz;
    }
}

