/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.navig.win32;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Hashtable;
import sun.plugin.navig.URLDecoder;
import sun.plugin.navig.win32.PluginContext;
import sun.plugin.navig.win32.PluginFrame;
import sun.plugin.navig.win32.PluginPanel;

abstract class PluginObject {
    private PluginFrame frame;
    protected PluginPanel panel;
    private URL documentURL;
    protected int id = -1;
    private boolean javaEnabled = true;
    private boolean mayScript = false;
    protected Hashtable atts = new Hashtable(20);
    private int handle;
    private int width;
    private int height;
    private int startCount = -1;
    private boolean initialized = false;

    PluginObject(String[] stringArray, String[] stringArray2, int n, boolean bl) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.atts.put(stringArray[n2].toLowerCase(), stringArray2[n2]);
            ++n2;
        }
        this.id = n;
        this.javaEnabled = bl;
        try {
            String string = this.getParameter("MAYSCRIPT");
            if (string != null && new Boolean(string.toString()).booleanValue()) {
                this.mayScript = true;
                return;
            }
        }
        catch (Throwable throwable) {}
    }

    private PluginFrame createFrame(int n, int n2, int n3, int n4) {
        return new PluginFrame(this, n, n2, n3, n4);
    }

    abstract PluginPanel createPanel(URL var1, boolean var2, boolean var3);

    Frame setWindow(int n, int n2, int n3) {
        if (this.handle == n) {
            return this.frame;
        }
        if (this.frame != null) {
            WindowEvent windowEvent = new WindowEvent((Window)((Object)this.frame), 201);
            EventQueue eventQueue = ((Window)((Object)this.frame)).getToolkit().getSystemEventQueue();
            eventQueue.postEvent(windowEvent);
            Thread.yield();
        }
        this.frame = null;
        this.handle = n;
        if (n != 0) {
            try {
                this.width = Integer.parseInt(this.getParameter("width"));
                this.height = Integer.parseInt(this.getParameter("height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.setParameter("width", new Integer(n2));
                this.setParameter("height", new Integer(n3));
                this.width = n2;
                this.height = n3;
            }
            this.frame = this.createFrame(n, this.id, this.width, this.height);
            this.initPlugin();
        }
        return this.frame;
    }

    private synchronized void initPlugin() {
        if (this.frame != null && this.panel != null) {
            Panel panel = this.panel.getPanel();
            if (panel != null) {
                ((Container)((Object)this.frame)).add(panel);
                ((Component)((Object)this.frame)).setVisible(true);
            }
            new Initer(this.panel, this).start();
        }
    }

    synchronized void startPlugin() {
        if (this.initialized && this.panel != null) {
            this.panel.startPanel();
            return;
        }
        if (this.startCount < 0) {
            this.startCount = 0;
        }
        ++this.startCount;
    }

    synchronized void stopPlugin() {
        if (this.initialized && this.panel != null) {
            this.panel.stopPanel();
            return;
        }
        --this.startCount;
    }

    synchronized void destroyPlugin() {
        PluginContext.inst2plugin.remove(new Integer(this.id));
        if (this.panel != null) {
            if (this.frame != null) {
                ((Component)((Object)this.frame)).setVisible(false);
                WindowEvent windowEvent = new WindowEvent((Window)((Object)this.frame), 201);
                EventQueue eventQueue = ((Window)((Object)this.frame)).getToolkit().getSystemEventQueue();
                eventQueue.postEvent(windowEvent);
                Thread.yield();
            }
            this.panel.destroyPanel();
            try {
                Thread.yield();
                Thread.sleep(200L);
                Thread.yield();
            }
            catch (Throwable throwable) {}
            this.panel = null;
            this.frame = null;
        }
    }

    synchronized void setDocumentURL(String string) {
        string = URLDecoder.decode(string);
        try {
            this.documentURL = new URL(string);
            if (this.panel == null) {
                this.panel = this.createPanel(this.documentURL, this.javaEnabled, this.mayScript);
                this.setParameter("width", new Integer(this.width));
                this.setParameter("height", new Integer(this.height));
                this.notifyAll();
            }
            this.initPlugin();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public String getParameter(String string) {
        return (String)this.atts.get(string.toLowerCase());
    }

    private Frame getFrame() {
        return this.frame;
    }

    void setFocus() {
        if (this.frame != null) {
            this.frame.requestFocus();
        }
    }

    void setFrameSize(int n, int n2) {
        PluginObject pluginObject = this;
        synchronized (pluginObject) {
            this.setParameter("width", new Integer(n));
            this.setParameter("height", new Integer(n2));
            if (this.frame != null) {
                ((Component)((Object)this.frame)).setSize(n, n2);
            }
            if (this.panel != null) {
                Applet applet;
                Panel panel = this.panel.getPanel();
                panel.setSize(n, n2);
                Object object = this.panel.getJavaObject();
                if (object instanceof Applet) {
                    applet = (Applet)object;
                } else {
                    Component component = (Component)object;
                    component.setSize(n, n2);
                    applet = (Applet)component.getParent();
                }
                applet.resize(n, n2);
            }
            return;
        }
    }

    public abstract Object getJavaObject();

    private void setParameter(String string, Object object) {
        this.atts.put(string.toLowerCase(), object);
        if (this.panel != null) {
            this.panel.setParameter(string, object);
        }
    }

    static /* synthetic */ boolean access$0(PluginObject pluginObject) {
        return pluginObject.initialized;
    }

    private class Initer
    extends Thread {
        PluginPanel that;
        PluginObject obj;

        Initer(PluginPanel pluginPanel, PluginObject pluginObject2) {
            PluginObject.this = PluginObject.this;
            this.that = pluginPanel;
            this.obj = pluginObject2;
        }

        public void run() {
            this.that.initPanel();
            PluginObject pluginObject = this.obj;
            synchronized (pluginObject) {
                this.obj.initialized = true;
                if (this.obj.startCount > 0) {
                    this.obj.startCount = 0;
                    this.obj.startPlugin();
                } else if (this.obj.startCount == 0) {
                    this.obj.startPlugin();
                    this.obj.stopPlugin();
                }
                return;
            }
        }
    }
}

