/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;

public class BasicPanel
extends ActivatorSubPanel
implements ActionListener,
KeyListener,
PropertyChangeListener {
    private JCheckBox enableJava;
    private JCheckBox showConsole;
    private JCheckBox cacheJars;
    private JComboBox networkAccess;
    private JTextField javaParms;
    private JLabel networkTitle;
    private MessageHandler mh = new MessageHandler("basic");

    BasicPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createGlue());
        Dimension dimension = new Dimension(1, 5);
        this.add(Box.createRigidArea(dimension));
        this.enableJava = new JCheckBox(this.mh.getMessage("enable_java"));
        this.enableJava.addActionListener(this);
        this.add(this.enableJava);
        this.add(Box.createRigidArea(dimension));
        this.showConsole = new JCheckBox(this.mh.getMessage("show_console"));
        this.showConsole.addActionListener(this);
        this.add(this.showConsole);
        this.add(Box.createRigidArea(dimension));
        this.cacheJars = new JCheckBox(this.mh.getMessage("cache_jars"));
        this.cacheJars.addActionListener(this);
        this.add(this.cacheJars);
        this.add(Box.createRigidArea(new Dimension(1, 10)));
        this.add(Box.createGlue());
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 2);
        gridLayout.setVgap(5);
        jPanel.setLayout(gridLayout);
        String[] stringArray = new String[]{this.mh.getMessage("network_none"), this.mh.getMessage("network_host"), this.mh.getMessage("network_all")};
        this.networkTitle = new JLabel(this.mh.getMessage("network_access"));
        this.networkAccess = this.addComboBoxFor(jPanel, this.networkTitle, stringArray, configurationInfo.getNetworkAccessLevel());
        this.propertyChange(null);
        configurationInfo.addPropertyChangeListener(this);
        jPanel.add(new JLabel(this.mh.getMessage("java_parms")));
        this.javaParms = new JTextField(configurationInfo.getJavaParms());
        jPanel.add(this.javaParms);
        this.javaParms.addKeyListener(this);
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(1, 10)));
        this.add(Box.createGlue());
        this.add(Box.createGlue());
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.networkAccess) {
            this.model.setNetworkAccessLevel(this.networkAccess.getSelectedIndex());
        }
        if (actionEvent.getSource() == this.enableJava) {
            this.model.setJavaEnabled(this.enableJava.isSelected());
        }
        if (actionEvent.getSource() == this.showConsole) {
            this.model.setConsoleEnabled(this.showConsole.isSelected());
        }
        if (actionEvent.getSource() == this.cacheJars) {
            this.model.setJarCacheEnabled(this.cacheJars.isSelected());
        }
    }

    private JComboBox addComboBoxFor(JPanel jPanel, JLabel jLabel, String[] stringArray, int n) {
        jPanel.add(jLabel);
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            jComboBox.addItem(stringArray[n2]);
            ++n2;
        }
        jComboBox.setSelectedIndex(n);
        jComboBox.addActionListener(this);
        jPanel.add(jComboBox);
        return jComboBox;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.javaParms) {
            this.model.setJavaParms(this.javaParms.getText());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = this.model.getJDK();
        boolean bl = false;
        if (string.startsWith("JRE")) {
            bl = string.startsWith("JRE 1.1");
        } else if (string.startsWith("JDK")) {
            bl = string.startsWith("JDK 1.1");
        }
        this.networkTitle.setEnabled(bl);
        this.networkAccess.setEnabled(bl);
    }

    public void reset() {
        this.showConsole.setSelected(this.model.isConsoleEnabled());
        this.enableJava.setSelected(this.model.isJavaEnabled());
        this.cacheJars.setSelected(this.model.isJarCacheEnabled());
        this.networkAccess.setSelectedIndex(this.model.getNetworkAccessLevel());
    }
}

