/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;

public class ProxyPanel
extends ActivatorSubPanel
implements ActionListener,
KeyListener {
    private JLabel httpLabel;
    private JLabel ftpLabel;
    private JLabel gopherLabel;
    private JLabel secureLabel;
    private JLabel socksLabel;
    private JTextField http;
    private JTextField ftp;
    private JTextField gopher;
    private JTextField secure;
    private JTextField socks;
    private JTextField httpPort;
    private JTextField ftpPort;
    private JTextField gopherPort;
    private JTextField securePort;
    private JTextField socksPort;
    private JCheckBox useDefault;
    private JCheckBox sameProxies;
    private MessageHandler mh = new MessageHandler("proxy");

    public ProxyPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.useDefault = new JCheckBox(this.mh.getMessage("use_browser"));
        this.useDefault.addActionListener(this);
        jPanel.add(this.useDefault);
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("proxy_settings")));
        GridLayout gridLayout = new GridLayout(6, 3);
        gridLayout.setVgap(5);
        gridLayout.setHgap(10);
        jPanel3.setLayout(gridLayout);
        this.addCenteredLabel(jPanel3, this.mh.getMessage("protocol_type"));
        this.addCenteredLabel(jPanel3, this.mh.getMessage("proxy_address"));
        this.addCenteredLabel(jPanel3, this.mh.getMessage("proxy_port"));
        this.httpLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("http"));
        this.http = this.addProxyTextField(jPanel3);
        this.httpPort = this.addProxyPortField(jPanel3);
        this.secureLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("https"));
        this.secure = this.addProxyTextField(jPanel3);
        this.securePort = this.addProxyPortField(jPanel3);
        this.ftpLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("ftp"));
        this.ftp = this.addProxyTextField(jPanel3);
        this.ftpPort = this.addProxyPortField(jPanel3);
        this.gopherLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("gopher"));
        this.gopher = this.addProxyTextField(jPanel3);
        this.gopherPort = this.addProxyPortField(jPanel3);
        this.socksLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("socks"));
        this.socks = this.addProxyTextField(jPanel3);
        this.socksPort = this.addProxyPortField(jPanel3);
        this.initProxySettings(configurationInfo.getProxySettingsString());
        jPanel2.add(jPanel3);
        this.sameProxies = new JCheckBox(this.mh.getMessage("same_for_all_protocols"));
        this.sameProxies.addActionListener(this);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        jPanel2.add(this.sameProxies);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        this.reset();
        this.add(jPanel2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (actionEvent.getSource() == this.useDefault) {
            bl = this.useDefault.isSelected();
            this.model.setDefaultProxySettings(bl);
            this.reset();
        }
        if (actionEvent.getSource() == this.sameProxies) {
            bl = this.sameProxies.isSelected();
            this.model.setUseSameProxy(bl);
            this.reset();
        }
    }

    private JLabel addCenteredLabel(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jPanel.add(jLabel);
        return jLabel;
    }

    private JTextField addProxyPortField(JPanel jPanel) {
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(this);
        jPanel.add(jTextField);
        return jTextField;
    }

    private JTextField addProxyTextField(JPanel jPanel) {
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(this);
        jPanel.add(jTextField);
        return jTextField;
    }

    private String fillProtocolProxySetting(String string, JTextField jTextField, JTextField jTextField2) {
        String string2;
        String string3;
        String string4 = string.substring(string.indexOf(61) + 1);
        int n = string4.indexOf(58);
        int n2 = string4.indexOf(59);
        if (n2 == -1) {
            n2 = string4.length();
        }
        if (n != -1 && n < n2) {
            string3 = string4.substring(0, n);
            string2 = string4.substring(n + 1, n2);
        } else {
            string3 = string4.substring(0, n2);
            string2 = "";
        }
        jTextField.setText(string3);
        jTextField2.setText(string2);
        return string4.substring(n2);
    }

    private void initProxySettings(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        String string2 = string;
        do {
            String string3;
            if ("http".equals(string3 = string2.substring(0, string2.indexOf(61)))) {
                string2 = this.fillProtocolProxySetting(string2, this.http, this.httpPort);
            }
            if (string3.endsWith("https")) {
                string2 = this.fillProtocolProxySetting(string2, this.secure, this.securePort);
            }
            if (string3.endsWith("ftp")) {
                string2 = this.fillProtocolProxySetting(string2, this.ftp, this.ftpPort);
            }
            if (string3.endsWith("gopher")) {
                string2 = this.fillProtocolProxySetting(string2, this.gopher, this.gopherPort);
            }
            if (!string3.endsWith("socks")) continue;
            string2 = this.fillProtocolProxySetting(string2, this.socks, this.socksPort);
        } while (string2.length() != 0);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.setProxySettings();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.setProxySettings();
    }

    public void reset() {
        this.initProxySettings(this.model.getProxySettingsString());
        boolean bl = this.model.useDefaultProxy();
        this.useDefault.setSelected(bl);
        boolean bl2 = this.model.useSameProxy();
        this.sameProxies.setSelected(bl2);
        boolean bl3 = bl ^ true;
        this.setEnabled(this.sameProxies, bl3);
        this.setEnabled(this.httpLabel, bl3);
        this.setEnabled(this.http, bl3);
        this.setEnabled(this.httpPort, bl3);
        bl3 = !bl && !bl2;
        this.setEnabled(this.secureLabel, bl3);
        this.setEnabled(this.secure, bl3);
        this.setEnabled(this.securePort, bl3);
        this.setEnabled(this.ftpLabel, bl3);
        this.setEnabled(this.ftp, bl3);
        this.setEnabled(this.ftpPort, bl3);
        this.setEnabled(this.gopherLabel, bl3);
        this.setEnabled(this.gopher, bl3);
        this.setEnabled(this.gopherPort, bl3);
        this.setEnabled(this.socksLabel, bl3);
        this.setEnabled(this.socks, bl3);
        this.setEnabled(this.socksPort, bl3);
    }

    private void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        jComponent.repaint();
    }

    private void setProxySettings() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.http.getText().length() != 0) {
            bl = true;
            stringBuffer.append(this.http.getText());
            if (this.httpPort.getText().length() != 0) {
                stringBuffer.append(":");
                stringBuffer.append(this.httpPort.getText());
            }
        }
        String string = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        if (this.sameProxies.isSelected() && string.length() != 0) {
            stringBuffer.append("http=");
            stringBuffer.append(string);
            stringBuffer.append(";https=");
            stringBuffer.append(string);
            stringBuffer.append(";ftp=");
            stringBuffer.append(string);
            stringBuffer.append(";gopher=");
            stringBuffer.append(string);
        } else {
            if (this.http.getText().length() != 0) {
                stringBuffer.append("http=");
                stringBuffer.append(string);
            }
            if (this.secure.getText().length() != 0) {
                if (bl) {
                    stringBuffer.append(";");
                } else {
                    bl = true;
                }
                stringBuffer.append("https=");
                stringBuffer.append(this.secure.getText());
                if (this.securePort.getText().length() != 0) {
                    stringBuffer.append(":");
                    stringBuffer.append(this.securePort.getText());
                }
            }
            if (this.ftp.getText().length() != 0) {
                if (bl) {
                    stringBuffer.append(";");
                } else {
                    bl = true;
                }
                stringBuffer.append("ftp=");
                stringBuffer.append(this.ftp.getText());
                if (this.ftpPort.getText().length() != 0) {
                    stringBuffer.append(":");
                    stringBuffer.append(this.ftpPort.getText());
                }
            }
            if (this.gopher.getText().length() != 0) {
                if (bl) {
                    stringBuffer.append(";");
                } else {
                    bl = true;
                }
                stringBuffer.append("gopher=");
                stringBuffer.append(this.gopher.getText());
                if (this.gopherPort.getText().length() != 0) {
                    stringBuffer.append(":");
                    stringBuffer.append(this.gopherPort.getText());
                }
            }
            if (this.socks.getText().length() != 0) {
                if (bl) {
                    stringBuffer.append(";");
                }
                stringBuffer.append("socks=");
                stringBuffer.append(this.socks.getText());
                if (this.socksPort.getText().length() != 0) {
                    stringBuffer.append(":");
                    stringBuffer.append(this.socksPort.getText());
                }
            }
        }
        string = stringBuffer.toString();
        if (string.length() != 0) {
            this.model.setProxySettingsString(string);
        } else {
            this.model.setProxySettingsString(null);
        }
    }
}

