/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CORBA;

import com.sun.CORBA.MarshalInputStream;
import com.sun.CORBA.MarshalOutputStream;
import com.sun.CORBA.ORB;
import org.omg.CORBA.SystemException;

public final class Profile {
    private String host;
    private int port;
    private byte major;
    private byte minor;
    private byte[] objectKey;
    private byte[] data;
    private ORB factory;

    Profile(ORB oRB, String string, int n, byte[] byArray) {
        this.factory = oRB;
        this.host = string;
        this.port = n;
        this.objectKey = byArray;
        this.major = 1;
        this.minor = 0;
    }

    Profile(ORB oRB, byte[] byArray) throws SystemException {
        this.factory = oRB;
        MarshalInputStream marshalInputStream = oRB.newInputStream(byArray, byArray.length);
        marshalInputStream.consumeEndian();
        this.major = marshalInputStream.read_octet();
        this.minor = marshalInputStream.read_octet();
        this.host = marshalInputStream.read_string();
        this.port = marshalInputStream.read_short() & 0xFFFF;
        this.objectKey = new byte[marshalInputStream.read_long()];
        marshalInputStream.read_octet_array(this.objectKey, 0, this.objectKey.length);
        this.data = byArray;
    }

    byte[] getEncapsulation() throws SystemException {
        if (this.data != null) {
            return this.data;
        }
        MarshalOutputStream marshalOutputStream = this.factory.newOutputStream();
        marshalOutputStream.putEndian();
        marshalOutputStream.write_octet(this.major);
        marshalOutputStream.write_octet(this.minor);
        marshalOutputStream.write_string(this.host);
        marshalOutputStream.write_short((short)this.port);
        marshalOutputStream.write_long(this.objectKey.length);
        marshalOutputStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
        this.data = marshalOutputStream.toByteArray();
        return this.data;
    }

    public String getHost() {
        return this.host;
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public int getPort() {
        return this.port;
    }

    boolean isEquivalent(Profile profile) {
        if (this.getPort() != profile.getPort() || !this.getHost().equalsIgnoreCase(profile.getHost()) || this.getObjectKey().length != profile.getObjectKey().length) {
            return false;
        }
        byte[] byArray = profile.getObjectKey();
        int n = 0;
        while (n < this.objectKey.length) {
            if (this.objectKey[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

