/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CORBA.iiop;

import com.sun.CORBA.ClientGIOP;
import com.sun.CORBA.ClientRequest;
import com.sun.CORBA.EndPoint;
import com.sun.CORBA.IOR;
import com.sun.CORBA.Profile;
import com.sun.CORBA.RequestHandler;
import com.sun.CORBA.ServerGIOP;
import com.sun.CORBA.ServiceContext;
import com.sun.CORBA.iiop.ClientRequestImpl;
import com.sun.CORBA.iiop.Connection;
import com.sun.CORBA.iiop.ConnectionTable;
import com.sun.CORBA.iiop.EndPointImpl;
import com.sun.CORBA.iiop.ListenerThread;
import com.sun.CORBA.iiop.ORB;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class GIOPImpl
implements ClientGIOP,
ServerGIOP {
    private int requestId = 5;
    private ConnectionTable table;
    private ORB orb;
    private RequestHandler handler;
    private int listenerPort;
    private Vector endPoints = new Vector();
    private ListenerThread listenerThread;
    private EndPoint bootstrapEndpoint;

    public GIOPImpl(ORB oRB, RequestHandler requestHandler) {
        this.orb = oRB;
        this.table = new ConnectionTable(oRB, this);
        this.setRequestHandler(requestHandler);
    }

    public int allocateRequestId() {
        return this.getNextRequestId();
    }

    private synchronized ListenerThread createListener(int n) {
        ListenerThread listenerThread;
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            listenerThread = new ListenerThread(this.table, serverSocket);
            listenerThread.setDaemon(true);
            listenerThread.start();
        }
        catch (Exception exception) {
            throw new INTERNAL(8, CompletionStatus.COMPLETED_NO);
        }
        return listenerThread;
    }

    public ClientRequest createRequest(IOR iOR, String string, boolean bl, ServiceContext[] serviceContextArray) {
        return this.createRequest(iOR, string, bl, serviceContextArray, this.getNextRequestId());
    }

    public ClientRequest createRequest(IOR iOR, String string, boolean bl, ServiceContext[] serviceContextArray, int n) {
        Profile profile = iOR.getProfile();
        String string2 = profile.getHost();
        int n2 = profile.getPort();
        byte[] byArray = profile.getObjectKey();
        Connection connection = this.table.get(string2, n2);
        return new ClientRequestImpl(byArray, string, bl, serviceContextArray, n, connection);
    }

    public synchronized EndPoint getBootstrapEndpoint(int n) {
        if (this.bootstrapEndpoint == null) {
            this.bootstrapEndpoint = this.getEndpoint(123, n, null);
        }
        return this.bootstrapEndpoint;
    }

    public ConnectionTable getConnectionTable() {
        return this.table;
    }

    public synchronized EndPoint getDefaultEndpoint() {
        if (this.endPoints.size() == 0) {
            return null;
        }
        return (EndPoint)this.endPoints.elementAt(0);
    }

    public synchronized EndPoint getEndpoint(int n, int n2, InetAddress inetAddress) {
        Object object;
        Enumeration enumeration = this.endPoints.elements();
        while (enumeration.hasMoreElements()) {
            object = (EndPoint)enumeration.nextElement();
            if (object.getType() != n || object.getPort() != n2 || object.getInetAddress() != inetAddress) continue;
            return object;
        }
        if (n2 == 0 && this.orb.getORBServerPort() != 0) {
            n2 = this.orb.getORBServerPort();
        }
        this.listenerThread = this.createListener(n2);
        object = this.listenerThread.getSocket();
        this.listenerPort = ((ServerSocket)object).getLocalPort();
        EndPointImpl endPointImpl = new EndPointImpl(n, this.listenerPort, inetAddress, this.orb.getORBServerHost());
        this.endPoints.addElement(endPointImpl);
        return endPointImpl;
    }

    synchronized int getNextRequestId() {
        return this.requestId++;
    }

    public RequestHandler getRequestHandler() {
        return this.handler;
    }

    public synchronized void initEndpoints() {
        if (this.endPoints.size() == 0) {
            this.getEndpoint(123, 0, null);
        }
    }

    public boolean isLocalHost(String string) {
        return string.equals(this.orb.getORBServerHost()) || string.equals(Connection.getLocalHost());
    }

    public IOR locate(IOR iOR) {
        Profile profile = iOR.getProfile();
        String string = profile.getHost();
        int n = profile.getPort();
        byte[] byArray = profile.getObjectKey();
        Connection connection = this.table.get(string, n);
        IOR iOR2 = connection.locate(this.getNextRequestId(), byArray);
        if (iOR2 == null) {
            iOR2 = iOR;
        }
        return iOR2;
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.handler = requestHandler;
    }
}

