/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;

public final class URL
implements Serializable {
    static final long serialVersionUID = -7627629688361524110L;
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    private String host;
    private transient InetAddress hostAddress;
    private int port = -1;
    private String file;
    private String ref;
    transient URLStreamHandler handler;
    private int hashCode = -1;
    private static NetPermission specifyHandlerPerm;
    static URLStreamHandlerFactory factory;
    static Hashtable handlers;

    static {
        handlers = new Hashtable();
    }

    public URL(String string) throws MalformedURLException {
        this(null, string);
    }

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        this(string, string2, n, string3, null);
    }

    public URL(String string, String string2, int n, String string3, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        SecurityManager securityManager;
        if (uRLStreamHandler != null && (securityManager = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler(securityManager);
        }
        this.protocol = string;
        this.host = string2;
        this.port = n;
        int n2 = string3.indexOf(35);
        this.file = n2 < 0 ? string3 : string3.substring(0, n2);
        String string4 = this.ref = n2 < 0 ? null : string3.substring(n2 + 1);
        if (uRLStreamHandler == null && (uRLStreamHandler = URL.getURLStreamHandler(string)) == null) {
            throw new MalformedURLException("unknown protocol: " + string);
        }
        this.handler = uRLStreamHandler;
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3);
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        this(uRL, string, null);
    }

    public URL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        Object object;
        String string2 = string;
        int n = 0;
        Object object2 = null;
        boolean bl = false;
        if (uRLStreamHandler != null && (object = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler((SecurityManager)object);
        }
        try {
            char c;
            int n2 = string.length();
            while (n2 > 0 && string.charAt(n2 - 1) <= ' ') {
                --n2;
            }
            while (n < n2 && string.charAt(n) <= ' ') {
                ++n;
            }
            if (string.regionMatches(true, n, "url:", 0, 4)) {
                n += 4;
            }
            if (n < string.length() && string.charAt(n) == '#') {
                bl = true;
            }
            int n3 = n;
            while (!bl && n3 < n2 && (c = string.charAt(n3)) != '/') {
                if (c == ':') {
                    object = string.substring(n, n3).toLowerCase();
                    if (!this.isValidProtocol((String)object)) break;
                    object2 = object;
                    n = n3 + 1;
                    break;
                }
                ++n3;
            }
            if (uRL != null && (object2 == null || ((String)object2).equals(uRL.protocol))) {
                this.protocol = uRL.protocol;
                this.host = uRL.host;
                this.port = uRL.port;
                this.file = uRL.file;
                if (uRLStreamHandler == null) {
                    uRLStreamHandler = uRL.handler;
                }
            } else {
                this.protocol = object2;
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + string2);
            }
            if (uRLStreamHandler == null && (uRLStreamHandler = URL.getURLStreamHandler(this.protocol)) == null) {
                throw new MalformedURLException("unknown protocol: " + this.protocol);
            }
            this.handler = uRLStreamHandler;
            n3 = string.indexOf(35, n);
            if (n3 >= 0) {
                this.ref = string.substring(n3 + 1, n2);
                n2 = n3;
            }
            uRLStreamHandler.parseURL(this, string, n, n2);
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (Exception exception) {
            throw new MalformedURLException(String.valueOf(string2) + ": " + exception);
        }
    }

    private void checkSpecifyHandler(SecurityManager securityManager) {
        if (specifyHandlerPerm == null) {
            specifyHandlerPerm = new NetPermission("specifyStreamHandler");
        }
        securityManager.checkPermission(specifyHandlerPerm);
    }

    public boolean equals(Object object) {
        if (!(object instanceof URL)) {
            return false;
        }
        URL uRL = (URL)object;
        return this.sameFile(uRL) && (this.ref == uRL.ref || this.ref != null && this.ref.equals(uRL.ref));
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    private synchronized InetAddress getHostAddress() {
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        if (this.host == null || this.host.equals("")) {
            return null;
        }
        try {
            this.hostAddress = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        return this.hostAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    static synchronized URLStreamHandler getURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler = (URLStreamHandler)handlers.get(string);
        if (uRLStreamHandler == null) {
            if (factory != null) {
                uRLStreamHandler = factory.createURLStreamHandler(string);
            }
            if (uRLStreamHandler == null) {
                String string2 = null;
                string2 = (String)AccessController.doPrivileged(new GetPropertyAction(protocolPathProp, ""));
                if (string2 != "") {
                    string2 = String.valueOf(string2) + "|";
                }
                string2 = String.valueOf(string2) + "sun.net.www.protocol";
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                while (uRLStreamHandler == null && stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    try {
                        Class clazz;
                        block10: {
                            String string4 = String.valueOf(string3) + "." + string + ".Handler";
                            clazz = null;
                            try {
                                clazz = Class.forName(string4);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                if (classLoader == null) break block10;
                                clazz = classLoader.loadClass(string4);
                            }
                        }
                        if (clazz == null) continue;
                        uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
                    }
                    catch (Exception exception) {}
                }
            }
            if (uRLStreamHandler != null) {
                handlers.put(string, uRLStreamHandler);
            }
        }
        return uRLStreamHandler;
    }

    public synchronized int hashCode() {
        InetAddress inetAddress;
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        int n = 0;
        if (this.protocol != null) {
            n += this.protocol.hashCode();
        }
        if ((inetAddress = this.getHostAddress()) != null) {
            n += inetAddress.hashCode();
        } else if (this.host != null) {
            n += this.host.toLowerCase().hashCode();
        }
        if (this.file != null) {
            n += this.file.hashCode();
        }
        n += this.port;
        if (this.ref != null) {
            n += this.ref.hashCode();
        }
        this.hashCode = n;
        return n;
    }

    private static boolean hostsEqual(URL uRL, URL uRL2) {
        InetAddress inetAddress = uRL.getHostAddress();
        InetAddress inetAddress2 = uRL2.getHostAddress();
        if (inetAddress != null && inetAddress2 != null) {
            return inetAddress.equals(inetAddress2);
        }
        if (uRL.host != null && uRL2.host != null) {
            return uRL.host.equalsIgnoreCase(uRL2.host);
        }
        return uRL.host == null && uRL2.host == null;
    }

    private boolean isValidProtocol(String string) {
        int n = string.length();
        if (n < 2) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.handler = URL.getURLStreamHandler(this.protocol);
        if (this.handler == null) {
            throw new IOException("unknown protocol: " + this.protocol);
        }
    }

    public boolean sameFile(URL uRL) {
        if (!(uRL.protocol == this.protocol || this.protocol != null && this.protocol.equalsIgnoreCase(uRL.protocol))) {
            return false;
        }
        if (!URL.hostsEqual(this, uRL)) {
            return false;
        }
        if (!(this.file == uRL.file || this.file != null && this.file.equals(uRL.file))) {
            return false;
        }
        return this.port == uRL.port;
    }

    protected void set(String string, String string2, int n, String string3, String string4) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = string;
            this.host = string2;
            this.port = n;
            this.file = string3;
            this.ref = string4;
            this.hashCode = -1;
            this.hostAddress = null;
        }
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        handlers.clear();
        factory = uRLStreamHandlerFactory;
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public String toString() {
        return this.toExternalForm();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

