/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.security.AccessController;
import java.util.Vector;
import sun.rmi.transport.Connection;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.tcp.TCPTransport;

class ConnectionAcceptor
implements Runnable {
    private TCPTransport transport;
    private Vector queue = new Vector(4);
    private static int threadNum = 0;

    public ConnectionAcceptor(TCPTransport tCPTransport) {
        this.transport = tCPTransport;
    }

    public void accept(Connection connection) {
        Vector vector = this.queue;
        synchronized (vector) {
            this.queue.addElement(connection);
            this.queue.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection connection;
        Vector vector = this.queue;
        synchronized (vector) {
            while (true) {
                if (this.queue.size() != 0) {
                    this.startNewAcceptor();
                    connection = (Connection)this.queue.elementAt(0);
                    this.queue.removeElementAt(0);
                    break;
                }
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.transport.handleMessages(connection, true);
    }

    public void startNewAcceptor() {
        Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this, "Multiplex Accept-" + ++threadNum, true));
        thread.start();
    }
}

